/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.pi.PIClusterModifier;
import com.ibm.hsc.cim.provider.pi.PICommonUtilMethods;
import com.ibm.hsc.cim.provider.pi.PIHscProviderUtils;
import com.ibm.hsc.cim.provider.pi.PILparActivateFunc;
import com.ibm.hsc.cim.provider.pi.PIResourcesAllocationUtils;
import com.ibm.hsc.cim.provider.pi.PIVirtualEthernetMACAddressUtils;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.client.rmc.HSCRMCException;
import com.ibm.hsc.client.rmc.PIHSCRMCClient;
import com.ibm.hsc.client.rmc.PIHSCRMCClientFactory;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIHmcAccessUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspIoSlot;
import com.ibm.hsc.fsp.cmdhelpers.FspLparMemory;
import com.ibm.hsc.fsp.cmdhelpers.FspLparVioSlotStates;
import com.ibm.hsc.fsp.cmdhelpers.FspVioEtherConfig;
import com.ibm.hsc.fsp.cmdhelpers.FspVioScsiConfig;
import com.ibm.hsc.fsp.cmdhelpers.VioSlotState;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.objmgr.cec.OmCecActResourceUpdater;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.objmgr.nvram.PIHMCSaveArea;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import com.ibm.hsc.rep.v50.R50Define;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbemcfg.GlobalConfig;

public abstract class PIDlparFunctions {
    private static final String VARY_ON_OFF_MEMORY = "VARY_ON_OFF_MEMORY";
    private static final String VARY_ON_OFF_IO_SLOT = "VARY_ON_OFF_IO_SLOT";
    private static final String VARY_ON_OFF_PROCESSING = "VARY_ON_OFF_PROCESSING";
    private static final String ERROR_TYPE = "ERROR_TYPE";
    private static final String ERROR_DATA = "ERROR_DATA";
    private static final String MOF_MIN_MEM = "minMem";
    private static final String MOF_AVAIL_MEM = "allocMem";
    private static final String MOF_MAX_MEM = "maxMem";
    private static final String MOF_CURR_MIN_MEM = "currentMinMem";
    private static final String MOF_CURR_ALLOC_MEM = "currentAllocMem";
    private static final String MOF_CURR_MAX_MEM = "currentMaxMem";
    private static final String MOF_PEND_MIN_MEM = "pendingMinMem";
    private static final String MOF_PEND_ALLOC_MEM = "pendingAllocMem";
    private static final String MOF_PEND_MAX_MEM = "pendingMaxMem";
    private static final String MOF_RUNTIME_MEM = "runtimeMem";
    private static final String MOF_RUNTIME_MIN_MEM = "runtimeMinMem";
    private static final UnsignedInt32 MIN_MAX_CONSTANT = new UnsignedInt32(-1L);
    private static final String MOF_ACTUAL_BATCH_SIZE = "actualBatchSize";
    private static final String MOF_DLPAR_RMC_VALUE = "rmcValue";
    private static final String MOF_REMOVE_MEM_RMC_ERROR = "removeMemRMCError";
    private static final String MOF_ADD_MEM_RMC_ERROR = "addMemRMCError";
    private static final int ADD = 1;
    private static final int REMOVE = 2;
    private static final int MOVE = 3;
    private static final int RECOVER = 4;
    private static final short IGNORE_FIELD_BYTE = 255;
    private static final int IGNORE_FIELD_SHORT = 65535;
    private static final long IGNORE_FIELD_INT = -1L;
    private static final byte IGNORE_FIELD_BYTE_TEST = -1;
    private static final short IGNORE_FIELD_SHORT_TEST = -1;
    private static final short NO_PROCS = -1;
    private static final long NO_PROC_UNITS = -1L;
    private static final short NO_SHARING_MODE = -1;
    private static final short NO_UNCAPPED_WEIGHT = -1;
    private static final short NO_INTERACTIVE = -1;
    private static final int MANU_GENESIS_MODE = 0;
    private static final String MOF_IO_RESULTS = "ioResults";
    private static final short IO_SUCCESS = 0;
    private static final short IO_FAILURE = 7;
    private static final UnsignedInt16 UNASSIGNED = new UnsignedInt16(65535);
    private static final UnsignedInt8 IO_PRIORITY_DESIRED = new UnsignedInt8(1);
    private static final UnsignedInt8 IO_PRIORITY_REQUIRED = new UnsignedInt8(2);
    private static final short SLOT_OPERATION_SUCCESS = 0;
    private static final short SLOT_INITIAL_VAL = 1;
    private static final short SLOT_IS_REQUIRED = 2;
    private static final short SLOT_INVALID_STATE = 3;
    private static final short SLOT_ID_NOT_MATCH = 4;
    private static final short SLOT_SAME_GROUP = 5;
    private static final short SLOT_WRONG_SRC_PARTITION = 6;
    private static final short SLOT_OPERATION_FAILED = 7;
    private static final UnsignedInt8 VARY_OFF = new UnsignedInt8(0);
    private static final UnsignedInt8 VARY_ON = new UnsignedInt8(1);
    private static final UnsignedInt8 VARY_OFF_FORCE = new UnsignedInt8(2);
    private static final UnsignedInt8 NO_COMMIT = new UnsignedInt8(0);
    private static final UnsignedInt8 COMMIT = new UnsignedInt8(1);
    private static final String MOF_NAME = "Name";
    private static final String RPA_PARTITION = "RPA_PARTITION";
    private static final String OS400_PARTITION = "OS400_PARTITION";
    private static final int VIRTUAL_OP_SUCCESS = 11;
    private static final int VIRTUAL_OP_FAILURE = 12;
    private static final int VIRTUAL_SLOT_EXISTS = 13;
    private static final int VIRTUAL_SLOT_INVALID_RANGE = 14;
    private static final int VLANID_INVALID_RANGE = 15;
    private static final int INVALID_ADD_VLAN_ID = 16;
    private static final int ADDL_VLAN_IDS_NOT_ALLOWED = 17;
    private static final int TOO_MANY_VLAN_IDS = 18;
    private static final int DUPLICATE_VLAN_IDS = 19;
    private static final int INVALID_IEEE_VALUE = 20;
    private static final int GOT_EXCEPTION_SETTING = 21;
    private static final int INVALID_DEVICE_ATTR_VALUE = 22;
    private static final int INVALID_REQ_DES_FLAG = 23;
    private static final int INVALID_VIRTUAL_SLOT_ID = 24;
    private static final int INVALID_SERV_LPAR_ID = 25;
    private static final int INVALID_HMC_SUPPORT_VALUE = 26;
    private static final int VIRTUAL_DOES_NOT_EXISTS = 27;
    private static final int GOT_EXCEPTION_CLEARING = 28;
    private static final int INVALID_DEV_CLASS = 29;
    private static final int GOT_EXCEPTION_VARYING_ONOFF = 30;
    private static final int EXCEP_DRC_UNABLE_TO_UNSET = 31;
    private static final int GOT_EXCEPTION_GETTING_DRCNAME_INDEX = 32;
    private static final int RMC_OPERATION_FAILED = 33;
    private static final int RMC_RESET_FAILED = 34;
    private static final int VARYONOFF_RESET_FAILED = 35;
    private static final int INVALID_TRUNK_VALUE = 36;
    private static final int SCSI_SERVER_NOT_ALLOWED = 37;
    private static final int SERIAL_CLIENT_NOT_ALLOWED = 38;
    private static final String DUMMY_DRCNAME = "INVALID";
    private static final String VIRTUAL_IO_RESULTS = "Results";
    private static final int MIN_SERVER_LPAR_ID = 1;
    private static final int MAX_SERVER_LPAR_ID = 254;
    private static final int MIN_VIR_SLOT_NUM_SERIAL = 0;
    private static final int MIN_VIR_SLOT_NUM_SCSI = 2;
    private static final int MAX_VIR_SLOT_NUM = 65535;
    private static final short CLASS_SERIAL = 2;
    private static final short CLASS_SCSI = 3;
    private static final short CLASS_ETH = 1;
    private static final String SLOT_ID = "SLOT_ID";
    private static final String DRC_NAME = "DRC_NAME";
    private static final String DRC_INDEX = "DRC_INDEX";
    private static final String VIRT_CLASS = "VIRT_CLASS";
    public static final int DLPAR_ADD = 2;
    public static final int DLPAR_MOVE = 4;
    public static final int DLPAR_REMOVE = 8;
    public static final int DLPAR_CAPPED_TO_UNCAPPED = 16;

    private static void debug(String string) {
        System.out.println("| DLPAR." + string);
    }

    private static String getPartitionType(CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) {
        PIDlparFunctions.debug("getPartitionType()");
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
            PIDlparFunctions.debug("found the lparInst");
        }
        catch (CIMException cIMException) {
            System.out.println("ERROR: cannot find partition instance");
            HSCLogUtils.serverLog(cIMException, HSCLogUtils._PartActClassLogInfo);
        }
        short s = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).shortValue();
        System.out.println("defState = " + s);
        if (130 == s || 129 == s) {
            PIDlparFunctions.debug("getPartitionType() -> OS400 partition");
            return OS400_PARTITION;
        }
        PIDlparFunctions.debug("getPartitionType() -> RPA partition");
        return RPA_PARTITION;
    }

    private static Vector getPartitions(CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws Exception {
        PIDlparFunctions.debug("getPartitions() -> ");
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
        }
        catch (CIMException cIMException) {
            System.out.println("ERROR: cannot find partition instance");
            HSCLogUtils.serverLog(cIMException, HSCLogUtils._PartActClassLogInfo);
        }
        String string = (String)cIMInstance.getProperty(MOF_NAME).getValue().getValue();
        String string2 = string.substring(string.indexOf(42) + 1);
        try {
            cIMObjectPath2 = PIResourcesAllocationUtils.constructCecPath(string2, "root/ibmhscS1_0");
        }
        catch (Exception exception) {
            System.out.println("ERROR: managed system doesn't exist");
            HSCLogUtils.serverLog(exception, HSCLogUtils._PartActClassLogInfo);
        }
        String string3 = "";
        try {
            string3 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CIMValue cIMValue = PIHscUtil.getCIMAttribute(string3, cIMObjectPath2, MOF_NAME);
        String string4 = (String)cIMValue.getValue();
        CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscS1_0");
        Vector vector = CimomWrapper.associators((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, cIMObjectPath2, null, "GroupComponent", "PartComponent", true, true, null);
        PIDlparFunctions.debug("getPartitions() -> " + vector.toString());
        return vector;
    }

    public static int moveMemRMC(int n, int n2, short s, String string, String string2, String string3, String string4, String string5, boolean bl) throws PIHscServerException, HSCRMCException {
        PIDlparFunctions.debug(" Entering moveMemRMC() ");
        int n3 = -1;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addMemRMC(int n, int n2, short s, String string, String string2, Vector vector) throws PIHscServerException, HSCRMCException, HSCException {
        HSCRMCException hSCRMCException = null;
        Object var7_7 = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "-> addMemRMC");
        }
        PIDlparFunctions.debug("Entering addMemRMC()");
        boolean bl = false;
        int n3 = -1;
        PIHSCRMCClient pIHSCRMCClient = null;
        try {
            block17: {
                try {
                    PIHSCRMCClientFactory pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(string);
                    try {
                        PIDlparFunctions.debug("creating a RMC client");
                        pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient(string2);
                    }
                    catch (HSCRMCException hSCRMCException2) {
                        hSCRMCException = hSCRMCException2;
                        PIDlparFunctions.debug("adding HSCRMCException for createRMCClient() : " + hSCRMCException2.toString());
                        vector.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)hSCRMCException2.toString(), new CIMDataType(9))));
                        bl = true;
                        HSCLogUtils.serverLog(hSCRMCException2, HSCLogUtils._PartActClassLogInfo);
                    }
                    catch (HSCException hSCException) {
                        PIDlparFunctions.debug("adding HSCException for createRMCClient() : " + hSCException.toString());
                        vector.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)hSCException.toString(), new CIMDataType(9))));
                        bl = true;
                        HSCLogUtils.serverLog(hSCException, HSCLogUtils._PartActClassLogInfo);
                        throw hSCException;
                    }
                    PIDlparFunctions.debug("calling RMC to add " + n + " lmbs");
                    if (pIHSCRMCClient == null) break block17;
                    n3 = pIHSCRMCClient.rmcDLPAROp(n, n2, s, "mem", null, "a");
                }
                catch (HSCRMCException hSCRMCException3) {
                    hSCRMCException = hSCRMCException3;
                    PIDlparFunctions.debug("adding HSCRMCException for rmcDLPAROp : " + hSCRMCException3.toString());
                    vector.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)hSCRMCException3.toString(), new CIMDataType(9))));
                    bl = true;
                    HSCLogUtils.serverLog(hSCRMCException3, HSCLogUtils._PartActClassLogInfo);
                    Object var14_16 = null;
                    PIDlparFunctions.debug("return val for drmgr add : " + n3);
                    if (!bl) {
                        vector.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
                    }
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("appahscT", "<- addMemRMC");
                    }
                    if (hSCRMCException == null) return;
                    PIDlparFunctions.debug("about to throw exception : " + hSCRMCException.toString());
                    throw hSCRMCException;
                }
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            PIDlparFunctions.debug("return val for drmgr add : " + n3);
            if (!bl) {
                vector.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace("appahscT", "<- addMemRMC");
            }
            if (hSCRMCException == null) throw throwable;
            PIDlparFunctions.debug("about to throw exception : " + hSCRMCException.toString());
            throw hSCRMCException;
        }
        PIDlparFunctions.debug("return val for drmgr add : " + n3);
        if (!bl) {
            vector.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<- addMemRMC");
        }
        if (hSCRMCException == null) return;
        PIDlparFunctions.debug("about to throw exception : " + hSCRMCException.toString());
        throw hSCRMCException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeMemRMC(int n, int n2, short s, String string, String string2, Vector vector) throws PIHscServerException, HSCRMCException, HSCException {
        HSCRMCException hSCRMCException = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "->removeMemRMC");
        }
        PIDlparFunctions.debug("Entering removeMemRMC()");
        int n3 = -1;
        PIHSCRMCClient pIHSCRMCClient = null;
        boolean bl = false;
        try {
            block17: {
                try {
                    PIHSCRMCClientFactory pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(string);
                    try {
                        pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient(string2);
                    }
                    catch (HSCRMCException hSCRMCException2) {
                        hSCRMCException = hSCRMCException2;
                        vector.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)hSCRMCException2.toString(), new CIMDataType(9))));
                        bl = true;
                        HSCLogUtils.serverLog(hSCRMCException2, HSCLogUtils._PartActClassLogInfo);
                    }
                    catch (HSCException hSCException) {
                        PIDlparFunctions.debug("remove HSCException for createRMCClient() : " + hSCException.toString());
                        vector.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)hSCException.toString(), new CIMDataType(9))));
                        bl = true;
                        HSCLogUtils.serverLog(hSCException, HSCLogUtils._PartActClassLogInfo);
                        throw hSCException;
                    }
                    if (pIHSCRMCClient == null) break block17;
                    n3 = pIHSCRMCClient.rmcDLPAROp(n, n2, s, "mem", null, "r");
                }
                catch (HSCRMCException hSCRMCException3) {
                    hSCRMCException = hSCRMCException3;
                    vector.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)hSCRMCException3.toString(), new CIMDataType(9))));
                    bl = true;
                    HSCLogUtils.serverLog(hSCRMCException3, HSCLogUtils._PartActClassLogInfo);
                    Object var13_15 = null;
                    PIDlparFunctions.debug("return val for drmgr remove : " + n3);
                    if (!bl) {
                        vector.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
                    }
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("appahscT", "<- removeMemRMC");
                    }
                    if (hSCRMCException == null) return;
                    throw hSCRMCException;
                }
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            PIDlparFunctions.debug("return val for drmgr remove : " + n3);
            if (!bl) {
                vector.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace("appahscT", "<- removeMemRMC");
            }
            if (hSCRMCException == null) throw throwable;
            throw hSCRMCException;
        }
        PIDlparFunctions.debug("return val for drmgr remove : " + n3);
        if (!bl) {
            vector.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<- removeMemRMC");
        }
        if (hSCRMCException == null) return;
        throw hSCRMCException;
    }

    private static boolean checkForLmbDivisable(int n, int n2) {
        return !(Math.IEEEremainder(n, n2) > 0.0);
    }

    private static boolean isLparInCluster(CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        int[] nArray = PIClusterModifier.getLparClusterInfo((CIMOMHandle)providerCIMOMHandle, cIMObjectPath);
        PIDlparFunctions.debug("isLparInCluster(): wlmInfo[0]=" + nArray[0] + ", wlmInfo[1]=" + nArray[1]);
        if (nArray != null && nArray[0] == 65535 && nArray[1] == -1) {
            PIDlparFunctions.debug("lpar is not in eWLM group");
            return false;
        }
        if (PIClusterModifier.isUserDefinedCluster(nArray[0])) {
            PIDlparFunctions.debug("lpar is in eWLM group");
            return true;
        }
        PIDlparFunctions.debug("lpar is not in eWLM group");
        return false;
    }

    private static void syncInPendingMemToCurrentMem(OmCecMgr omCecMgr, UnsignedInt16 unsignedInt16, CIMInstance cIMInstance, int n) throws PIHscServerException {
        int n2 = ((UnsignedInt32)cIMInstance.getProperty("CurAllocMem").getValue().getValue()).intValue();
        int n3 = ((UnsignedInt32)cIMInstance.getProperty("PendAllocMem").getValue().getValue()).intValue();
        PIDlparFunctions.debug("Check for out of sync: currAllocMem=" + n2 + ", pendAllocMem=" + n3);
        if (n2 != n3 && n2 < n3) {
            PIDlparFunctions.debug("Pending and Current are OUT OF SYNC, calling sync in routine");
            UnsignedInt32 unsignedInt32 = new UnsignedInt32((long)(n2 / n));
            try {
                PIDlparFunctions.debug("calling sync in set pending with value " + unsignedInt32.intValue() + " lmbs");
                omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, unsignedInt32, MIN_MAX_CONSTANT);
                PIDlparFunctions.debug("sync in set pending succeeded");
            }
            catch (PIHscServerException pIHscServerException) {
                PIDlparFunctions.debug("sync in pending/current failed");
                pIHscServerException.printStackTrace();
                throw new PIHscServerException("0637", new String[]{unsignedInt16.toString()}, pIHscServerException);
            }
        } else {
            PIDlparFunctions.debug("Pending and Current are IN SYNC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CIMInstance getCIMInstance(CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
            return cIMInstance;
        }
        catch (CIMException cIMException) {
            HSCLogUtils.serverLog(cIMException, HSCLogUtils._PartActClassLogInfo);
            System.out.println("ERROR: cannot find partition instance");
        }
        finally {
            return cIMInstance;
        }
    }

    /*
     * Loose catch block
     */
    public static CIMValue addMem(CIMInstance cIMInstance, CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2, ProviderCIMOMHandle providerCIMOMHandle, CIMInstance cIMInstance2) throws PIHscServerException {
        block35: {
            if (1 <= Trace.LEVEL) {
                Trace.trace("appahscT", "->PIDlparFunctions.addMem");
            }
            PIDlparFunctions.debug("Entering addMem() ");
            boolean bl = false;
            PIDlparFunctions.debug("inParms  : " + vector.size());
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMProperty.getValue().getValue();
            PIDlparFunctions.debug("lparID : " + unsignedInt16.toString());
            CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(1);
            UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMProperty2.getValue().getValue();
            PIDlparFunctions.debug("allocMem : " + unsignedInt32.intValue());
            CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(2);
            UnsignedInt32 unsignedInt322 = (UnsignedInt32)cIMProperty3.getValue().getValue();
            PIDlparFunctions.debug("num32 : " + unsignedInt322.toString());
            int n = ((UnsignedInt32)cIMProperty3.getValue().getValue()).intValue();
            PIDlparFunctions.debug("num : " + n);
            CIMProperty cIMProperty4 = (CIMProperty)vector.elementAt(3);
            UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMProperty4.getValue().getValue();
            PIDlparFunctions.debug("timeout : " + unsignedInt162.intValue());
            CIMProperty cIMProperty5 = (CIMProperty)vector.elementAt(4);
            short s = ((UnsignedInt16)cIMProperty5.getValue().getValue()).shortValue();
            PIDlparFunctions.debug("deatil : " + s);
            CIMProperty cIMProperty6 = (CIMProperty)vector.elementAt(5);
            String string = (String)cIMProperty6.getValue().getValue();
            PIDlparFunctions.debug("cecIntName : " + string);
            CIMProperty cIMProperty7 = (CIMProperty)vector.elementAt(6);
            boolean bl2 = (Boolean)cIMProperty7.getValue().getValue();
            PIDlparFunctions.debug("noRMCConnection : " + bl2);
            String string2 = unsignedInt16.toString().trim() + "*" + string;
            PIDlparFunctions.debug("lparIntName : " + string2);
            int n2 = PIDlparFunctions.getLMBSize(cIMInstance);
            String string3 = null;
            try {
                string3 = (String)cIMInstance.getProperty(MOF_NAME).getValue().getValue();
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.Name"}, throwable);
            }
            if (!PIDlparFunctions.checkForLmbDivisable(n, n2)) {
                String[] stringArray = new String[]{Integer.toString(n)};
                throw new PIHscServerException("2951", stringArray, null);
            }
            UnsignedInt32 unsignedInt323 = new UnsignedInt32((long)((unsignedInt32.intValue() + n) / n2));
            PIDlparFunctions.debug("mem : " + unsignedInt323);
            PIDlparFunctions.debug("Input values are : \nlparID = " + unsignedInt16.toString() + "\nallocMem = " + unsignedInt32.intValue() + "\nnum = " + n + "\ntimeout = " + unsignedInt162.intValue() + "\ndetail = " + s + "\ncecIntName = " + string + "\nnoRMCConnection = " + bl2 + "\nlparIntName = " + string2 + "\nAmount to add = " + unsignedInt323.intValue());
            FspLockHelper fspLockHelper = null;
            int n3 = 64;
            fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n3);
            fspLockHelper.addMemLock(omCecMgr.getObjectId());
            fspLockHelper.lock();
            if (!PIDlparFunctions.isLparInCluster(cIMObjectPath, providerCIMOMHandle)) {
                PIDlparFunctions.syncInPendingMemToCurrentMem(omCecMgr, unsignedInt16, cIMInstance2, n2);
            }
            String string4 = cIMObjectPath.getNameSpace();
            PIResourcesAllocationUtils.AllocMemAndLparInfo allocMemAndLparInfo = null;
            try {
                UnsignedInt32 unsignedInt324 = new UnsignedInt32(0L);
                allocMemAndLparInfo = PIResourcesAllocationUtils.checkMemForAlloc(unsignedInt322, unsignedInt322, unsignedInt322, unsignedInt324, unsignedInt324, unsignedInt324, unsignedInt324, unsignedInt324, unsignedInt324, cIMObjectPath, string3, providerCIMOMHandle, false);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (null == allocMemAndLparInfo) {
                System.out.println("ERROR: unable to allocate mem for partition");
                throw new PIHscServerException("03F9", null);
            }
            long l = allocMemAndLparInfo.allocatedMem.longValue();
            if (l < unsignedInt322.longValue()) {
                System.out.println("addMem:NOT ENOUGH MEMORY AVAILABLE FOR DLPAR ADD OPERATION.");
                throw new PIHscServerException("2914", null);
            }
            HashSet<UnsignedInt16> hashSet = new HashSet<UnsignedInt16>();
            if (null != allocMemAndLparInfo.lparIDs) {
                for (int i = 0; i < allocMemAndLparInfo.lparIDs.length; ++i) {
                    hashSet.add(allocMemAndLparInfo.lparIDs[i]);
                }
                PILparActivateFunc.setStolenLparsToNotBootable(hashSet, null, omCecMgr, allocMemAndLparInfo, null);
            }
            long l2 = PIResourcesAllocationUtils.getAvailableMem(cIMInstance2, cIMInstance, providerCIMOMHandle, string4);
            System.out.println("DOING AN ADD - availableMem = " + l2);
            PIDlparFunctions.debug("Calling SET Pending");
            omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, unsignedInt323, MIN_MAX_CONSTANT);
            PIDlparFunctions.debug("SET Pending call over");
            if (RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath, providerCIMOMHandle))) {
                if (!bl2) {
                    try {
                        PIDlparFunctions.debug("making a call to RMC add on lpar " + string2 + " with value " + n + " lmbs");
                        PIDlparFunctions.addMemRMC(n / n2, unsignedInt162.intValue(), s, string, string2, vector2);
                        PIDlparFunctions.debug("RMC call over");
                    }
                    catch (HSCRMCException hSCRMCException) {
                        PIDlparFunctions.debug("Error when drmgr executes -a cmd, RECOVERY Started");
                        int n4 = hSCRMCException.getNumberOfSuccesses();
                        PIDlparFunctions.debug("Requested : " + n / n2 + " , Succeeded : " + n4);
                        PIDlparFunctions.debug("RMC VaryOn failed, going to set pending (recover) " + (unsignedInt32.intValue() / n2 + n4) + " lmbs back");
                        omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, new UnsignedInt32((long)(unsignedInt32.intValue() / n2 + n4)), MIN_MAX_CONSTANT);
                        PIDlparFunctions.debug("RPA Recovery is over");
                        HSCLogUtils.serverLog(hSCRMCException, HSCLogUtils._PartActClassLogInfo);
                        throw new PIHscServerException("2931", new String[]{hSCRMCException.toString()}, hSCRMCException);
                    }
                    catch (HSCException hSCException) {
                        PIDlparFunctions.debug("adding HSCException for createRMCClient() : " + hSCException.toString());
                        HSCLogUtils.serverLog(hSCException, HSCLogUtils._PartActClassLogInfo);
                        throw new PIHscServerException("2931", new String[]{hSCException.toString()}, hSCException);
                    }
                } else {
                    vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
                }
            } else {
                try {
                    PIDlparFunctions.debug("OS400 Varying ON started");
                    int n5 = unsignedInt323.intValue();
                    omCecMgr.getCmdHelper().varyOnOffMemory(unsignedInt16, new UnsignedInt16(unsignedInt162.intValue() * 60), n5);
                    vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
                    PIDlparFunctions.debug("Vary On Over");
                    bl = true;
                }
                catch (PIHscServerException pIHscServerException) {
                    PIDlparFunctions.debug("OS400 VaryOn failed, going to set pending(recover) " + unsignedInt32.intValue() / n2 + " lmbs back");
                    omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, new UnsignedInt32((long)(unsignedInt32.intValue() / n2)), MIN_MAX_CONSTANT);
                    PIDlparFunctions.debug("OS400 Recovery is over");
                    throw pIHscServerException;
                }
            }
            Object var39_47 = null;
            try {
                if (fspLockHelper != null) {
                    PIDlparFunctions.debug("Releasing the FSP LOCK");
                    fspLockHelper.unlock();
                }
                Trace.trace("aplphscT", "<- PIDlparFunctions.addMem");
            }
            catch (Throwable throwable) {
                PIDlparFunctions.debug("caught exception when release the FSP lock");
                throwable.printStackTrace();
            }
            break block35;
            {
                catch (PIHscServerException pIHscServerException) {
                    if (!RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath, providerCIMOMHandle)) && !bl) {
                        vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)pIHscServerException.toString(), new CIMDataType(9))));
                    }
                    PIDlparFunctions.debug("addMem error : " + pIHscServerException.toString());
                    HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._PartActClassLogInfo);
                    throw pIHscServerException;
                }
                catch (Throwable throwable) {
                    if (!RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath, providerCIMOMHandle)) && !bl) {
                        vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)throwable.toString(), new CIMDataType(9))));
                    }
                    PIDlparFunctions.debug("addMem error : " + throwable.toString());
                    throw new PIHscServerException("2920", throwable);
                }
            }
            catch (Throwable throwable) {
                Object var39_48 = null;
                try {
                    if (fspLockHelper != null) {
                        PIDlparFunctions.debug("Releasing the FSP LOCK");
                        fspLockHelper.unlock();
                    }
                    Trace.trace("aplphscT", "<- PIDlparFunctions.addMem");
                }
                catch (Throwable throwable3) {
                    PIDlparFunctions.debug("caught exception when release the FSP lock");
                    throwable3.printStackTrace();
                }
                throw throwable;
            }
        }
        PIDlparFunctions.debug("Exiting addMem()");
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<- PIDlparFunctions.addMem");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static CIMValue removeMem(CIMInstance cIMInstance, CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        block35: {
            FspLockHelper fspLockHelper;
            boolean bl;
            block32: {
                int n;
                if (1 <= Trace.LEVEL) {
                    Trace.trace("appahscT", "-> PIDlparFunctions.removeMem");
                }
                PIDlparFunctions.debug("Entering removeMem()");
                bl = false;
                CIMInstance cIMInstance2 = null;
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMProperty.getValue().getValue();
                CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(1);
                UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMProperty2.getValue().getValue();
                CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(2);
                int n2 = ((UnsignedInt32)cIMProperty3.getValue().getValue()).intValue();
                CIMProperty cIMProperty4 = (CIMProperty)vector.elementAt(3);
                UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMProperty4.getValue().getValue();
                CIMProperty cIMProperty5 = (CIMProperty)vector.elementAt(4);
                short s = ((UnsignedInt16)cIMProperty5.getValue().getValue()).shortValue();
                CIMProperty cIMProperty6 = (CIMProperty)vector.elementAt(5);
                String string = (String)cIMProperty6.getValue().getValue();
                CIMProperty cIMProperty7 = (CIMProperty)vector.elementAt(6);
                boolean bl2 = (Boolean)cIMProperty7.getValue().getValue();
                String string2 = unsignedInt16.toString().trim() + "*" + string;
                int n3 = PIDlparFunctions.getLMBSize(cIMInstance);
                if (!PIDlparFunctions.checkForLmbDivisable(n2, n3)) {
                    String[] stringArray = new String[]{Integer.toString(n2)};
                    throw new PIHscServerException("2951", stringArray, null);
                }
                UnsignedInt32 unsignedInt322 = new UnsignedInt32((long)((unsignedInt32.intValue() - n2) / n3));
                UnsignedInt32 unsignedInt323 = new UnsignedInt32((long)(unsignedInt32.intValue() / n3));
                PIDlparFunctions.debug("Input values are : \nlparID = " + unsignedInt16.toString() + "\nallocMem = " + unsignedInt32.intValue() + "\nnum = " + n2 + "\ntimeout = " + unsignedInt162.intValue() + "\ndetail = " + s + "\ncecIntName = " + string + "\nnoRMCConnection = " + bl2 + "\nlparIntName = " + string2 + "\nAmount to add = " + unsignedInt322.intValue());
                fspLockHelper = null;
                int n4 = 64;
                PIDlparFunctions.debug("locking FSP...");
                fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n4);
                fspLockHelper.addMemLock(omCecMgr.getObjectId());
                fspLockHelper.lock();
                cIMInstance2 = PIDlparFunctions.getCIMInstance(cIMObjectPath, providerCIMOMHandle);
                if (!PIDlparFunctions.isLparInCluster(cIMObjectPath, providerCIMOMHandle)) {
                    PIDlparFunctions.syncInPendingMemToCurrentMem(omCecMgr, unsignedInt16, cIMInstance2, n3);
                }
                PIDlparFunctions.debug("Calling SET Pending");
                omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, unsignedInt322, MIN_MAX_CONSTANT);
                PIDlparFunctions.debug("SET Pending Over");
                if (RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath, providerCIMOMHandle))) {
                    if (!bl2) {
                        try {
                            PIDlparFunctions.debug("making a RMC call to remove " + n2 / n3 + " lmbs");
                            PIDlparFunctions.removeMemRMC(n2 / n3, unsignedInt162.intValue(), s, string, string2, vector2);
                            PIDlparFunctions.debug("RMC call is over");
                            break block32;
                        }
                        catch (HSCRMCException hSCRMCException) {
                            PIDlparFunctions.debug("Error when drmgr executes -r cmd, RECOVERY started");
                            int n5 = hSCRMCException.getNumberOfSuccesses();
                            PIDlparFunctions.debug("Requested : " + n2 / n3 + " , Succeeded : " + n5);
                            HSCLogUtils.serverLog(hSCRMCException, HSCLogUtils._PartActClassLogInfo);
                            PIDlparFunctions.debug("VaryOff failed, going to set pending(recover) " + (unsignedInt323.intValue() - n5) + " lmbs back");
                            omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, new UnsignedInt32((long)(unsignedInt323.intValue() - n5)), MIN_MAX_CONSTANT);
                            PIDlparFunctions.debug("Recovery is over");
                            throw new PIHscServerException("2932", new String[]{hSCRMCException.toString()}, hSCRMCException);
                        }
                        catch (HSCException hSCException) {
                            PIDlparFunctions.debug("remove HSCException for createRMCClient() : " + hSCException.toString());
                            HSCLogUtils.serverLog(hSCException, HSCLogUtils._PartActClassLogInfo);
                            throw new PIHscServerException("2932", new String[]{hSCException.toString()}, hSCException);
                        }
                    }
                    vector2.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
                    break block32;
                }
                try {
                    n = unsignedInt322.intValue();
                    PIDlparFunctions.debug("Start Varying Off " + n + " on " + unsignedInt16);
                    omCecMgr.getCmdHelper().varyOnOffMemory(unsignedInt16, new UnsignedInt16(unsignedInt162.intValue() * 60), n);
                    vector2.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
                    bl = true;
                    PIDlparFunctions.debug("Vary Off over");
                }
                catch (PIHscServerException pIHscServerException) {
                    PIDlparFunctions.debug("VaryOff failed, going to set pending(recover) " + unsignedInt323.intValue() + " lmbs back");
                    omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, unsignedInt323, MIN_MAX_CONSTANT);
                    PIDlparFunctions.debug("Recovery is over");
                    throw pIHscServerException;
                }
                PIDlparFunctions.debug("Starting runtime check routine ....");
                if (!RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath, providerCIMOMHandle))) {
                    int n6;
                    block34: {
                        n = 0;
                        n6 = 0;
                        FspLparMemory fspLparMemory = null;
                        try {
                            int n7 = unsignedInt32.intValue() - n2;
                            PIDlparFunctions.debug("afterRemove=" + n7);
                            long l = 0L;
                            long l2 = unsignedInt162.intValue() * 60;
                            do {
                                PIDlparFunctions.debug("sleeping 30 seconds....");
                                Thread.currentThread();
                                Thread.sleep(30000L);
                                fspLparMemory = omCecMgr.getCmdHelper().getRuntimeLparMem(unsignedInt16);
                                n6 = fspLparMemory.getRuntimeMem().intValue();
                                PIDlparFunctions.debug("pending=" + n7 + " mb and current/runtime=" + n6 * n3 + " mb");
                                if ((l += 30L) != l2 && n7 != n6 * n3) continue;
                                PIDlparFunctions.debug("timed out in " + l + " seconds");
                                break;
                            } while (n7 != n6 * n3);
                            Object var37_45 = null;
                        }
                        catch (Throwable throwable) {
                            Object var37_49 = null;
                            n = unsignedInt323.intValue() - n6;
                            PIDlparFunctions.debug("succeededSource=" + n);
                            throw throwable;
                        }
                        n = unsignedInt323.intValue() - n6;
                        PIDlparFunctions.debug("succeededSource=" + n);
                        {
                            break block34;
                            catch (InterruptedException interruptedException) {
                                HSCLogUtils.serverLog(interruptedException, HSCLogUtils._PartActClassLogInfo);
                                PIDlparFunctions.debug("ERROR: cannot find partition instance");
                                vector2.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)interruptedException.toString(), new CIMDataType(9))));
                                Object var37_46 = null;
                                n = unsignedInt323.intValue() - n6;
                                PIDlparFunctions.debug("succeededSource=" + n);
                                break block34;
                            }
                            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._PartActClassLogInfo);
                                PIDlparFunctions.debug("ERROR: command manager exception :" + pIHscCmdMgrException.toString());
                                vector2.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)pIHscCmdMgrException.toString(), new CIMDataType(9))));
                                Object var37_47 = null;
                                n = unsignedInt323.intValue() - n6;
                                PIDlparFunctions.debug("succeededSource=" + n);
                                break block34;
                            }
                            catch (PIHscServerException pIHscServerException) {
                                HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._PartActClassLogInfo);
                                PIDlparFunctions.debug("PIHscServerException:" + pIHscServerException.toString());
                                vector2.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)pIHscServerException.toString(), new CIMDataType(9))));
                                Object var37_48 = null;
                                n = unsignedInt323.intValue() - n6;
                                PIDlparFunctions.debug("succeededSource=" + n);
                            }
                        }
                    }
                    if (n != n2 / n3 && n6 != 0) {
                        PIDlparFunctions.debug("Internal Cleanup for OS400: requested=" + unsignedInt323 + ",succeeded=" + n + ",set pending=" + n6 + " lmbs");
                        omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, new UnsignedInt32((long)n6), MIN_MAX_CONSTANT);
                        PIDlparFunctions.debug("Internal Cleanup for OS400 is over");
                        String[] stringArray = new String[]{HSCResourceBundleUtil.getMessage("PIDLPARBundle", "REMOVE", "Remove"), HSCResourceBundleUtil.getMessage("CECBundle", "COD_MEMORY", "Memory"), Integer.toString(n2) + " MB", Integer.toString(n * n3) + " MB"};
                        throw new PIHscServerException("2935", stringArray, null);
                    }
                }
                PIDlparFunctions.debug("Stopping runtime check routine");
            }
            Object var39_51 = null;
            try {
                if (fspLockHelper != null) {
                    PIDlparFunctions.debug("Releasing the FSP LOCK");
                    fspLockHelper.unlock();
                }
                Trace.trace("aplphscT", "<- PIDlparFunctions.removeMem()");
            }
            catch (Throwable throwable) {
                PIDlparFunctions.debug("caught exception when release the FSP lock in removeMem()");
                throwable.printStackTrace();
            }
            break block35;
            {
                catch (PIHscServerException pIHscServerException) {
                    HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._PartActClassLogInfo);
                    if (!RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath, providerCIMOMHandle)) && !bl) {
                        vector2.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)pIHscServerException.toString(), new CIMDataType(9))));
                    }
                    throw pIHscServerException;
                }
                catch (Throwable throwable) {
                    if (!RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath, providerCIMOMHandle)) && !bl) {
                        vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)throwable.toString(), new CIMDataType(9))));
                    }
                    PIDlparFunctions.debug("addMem error : " + throwable.toString());
                    throw new PIHscServerException("2922", throwable);
                }
            }
            catch (Throwable throwable) {
                Object var39_52 = null;
                try {
                    if (fspLockHelper != null) {
                        PIDlparFunctions.debug("Releasing the FSP LOCK");
                        fspLockHelper.unlock();
                    }
                    Trace.trace("aplphscT", "<- PIDlparFunctions.removeMem()");
                }
                catch (Throwable throwable2) {
                    PIDlparFunctions.debug("caught exception when release the FSP lock in removeMem()");
                    throwable2.printStackTrace();
                }
                throw throwable;
            }
        }
        PIDlparFunctions.debug("Exiting removeMem()");
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<- PIDlparFunctions.removeMem");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static CIMValue moveMem(CIMInstance cIMInstance, CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        block62: {
            FspLockHelper fspLockHelper;
            CIMObjectPath cIMObjectPath2;
            boolean bl;
            block61: {
                int n;
                int n2;
                int n3;
                UnsignedInt32 unsignedInt32;
                UnsignedInt32 unsignedInt322;
                int n4;
                UnsignedInt32 unsignedInt323;
                String string;
                UnsignedInt16 unsignedInt16;
                boolean bl2;
                String string2;
                short s;
                UnsignedInt16 unsignedInt162;
                int n5;
                UnsignedInt32 unsignedInt324;
                UnsignedInt16 unsignedInt163;
                block60: {
                    String string3;
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("appahscT", "-> PIDlparFunction.moveMem");
                    }
                    PIDlparFunctions.debug("Entering moveMem()");
                    PIDlparFunctions.debug("inParms for moveMem() = " + vector.toString());
                    boolean bl3 = false;
                    bl = false;
                    CIMInstance cIMInstance2 = null;
                    CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
                    unsignedInt163 = (UnsignedInt16)cIMProperty.getValue().getValue();
                    PIDlparFunctions.debug("lparID = " + unsignedInt163);
                    CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(1);
                    unsignedInt324 = (UnsignedInt32)cIMProperty2.getValue().getValue();
                    PIDlparFunctions.debug("allocMem = " + unsignedInt324);
                    CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(2);
                    n5 = ((UnsignedInt32)cIMProperty3.getValue().getValue()).intValue();
                    PIDlparFunctions.debug("num = " + n5);
                    CIMProperty cIMProperty4 = (CIMProperty)vector.elementAt(3);
                    unsignedInt162 = (UnsignedInt16)cIMProperty4.getValue().getValue();
                    PIDlparFunctions.debug("timeout = " + unsignedInt162);
                    CIMProperty cIMProperty5 = (CIMProperty)vector.elementAt(4);
                    s = ((UnsignedInt16)cIMProperty5.getValue().getValue()).shortValue();
                    PIDlparFunctions.debug("detail = " + s);
                    CIMProperty cIMProperty6 = (CIMProperty)vector.elementAt(5);
                    string2 = (String)cIMProperty6.getValue().getValue();
                    PIDlparFunctions.debug("cecIntName = " + string2);
                    String string4 = unsignedInt163.toString().trim() + "*" + string2;
                    CIMProperty cIMProperty7 = (CIMProperty)vector.elementAt(6);
                    bl2 = (Boolean)cIMProperty7.getValue().getValue();
                    PIDlparFunctions.debug("noRMCConnection = " + bl2);
                    int n6 = -1;
                    CIMProperty cIMProperty8 = (CIMProperty)vector.elementAt(7);
                    String string5 = (String)cIMProperty8.getValue().getValue();
                    PIDlparFunctions.debug("destination = " + string5);
                    CIMProperty cIMProperty9 = (CIMProperty)vector.elementAt(8);
                    unsignedInt16 = (UnsignedInt16)cIMProperty9.getValue().getValue();
                    PIDlparFunctions.debug("destLparID = " + unsignedInt16);
                    string = unsignedInt16.toString().trim() + "*" + string2;
                    CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_Partition", cIMObjectPath.getNameSpace());
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                    cIMObjectPath3.addKey(MOF_NAME, new CIMValue((Object)string));
                    int[] nArray = PIClusterModifier.checkWlmPolicy(7, (CIMOMHandle)providerCIMOMHandle, cIMObjectPath, cIMObjectPath3, -1);
                    if (nArray[0] != 0) {
                        System.err.println("WLM: do not allow to MOVE MEM among \n  " + cIMObjectPath + "\n  " + cIMObjectPath3);
                        throw new PIHscServerException("0500");
                    }
                    boolean bl4 = false;
                    try {
                        string3 = PIHmcAccessUtils.getInternalResInstId(cIMObjectPath3);
                        unsignedInt323 = new Vector();
                        unsignedInt323.addElement(string3);
                        bl4 = PIHscProviderUtils.checkPermission(unsignedInt323, "dlparOperation");
                    }
                    catch (Throwable throwable) {
                        throw new PIHscServerException("1584");
                    }
                    if (!bl4) {
                        throw new PIHscServerException("1584");
                    }
                    string3 = (CIMProperty)vector.elementAt(9);
                    unsignedInt323 = (UnsignedInt32)string3.getValue().getValue();
                    PIDlparFunctions.debug("destAllocMem = " + unsignedInt323);
                    UnsignedInt16 unsignedInt164 = new UnsignedInt16(2);
                    n4 = PIDlparFunctions.getLMBSize(cIMInstance);
                    PIDlparFunctions.debug("check for lmb");
                    cIMObjectPath2 = null;
                    cIMObjectPath2 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscS1_0");
                    cIMObjectPath2.addKey(MOF_NAME, new CIMValue((Object)new String(unsignedInt16 + "*" + string2)));
                    cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                    if (!PIDlparFunctions.checkForLmbDivisable(n5, n4)) {
                        String[] stringArray = new String[]{Integer.toString(n5)};
                        throw new PIHscServerException("2951", stringArray, null);
                    }
                    UnsignedInt32 unsignedInt325 = new UnsignedInt32((long)((unsignedInt324.intValue() - n5) / n4));
                    unsignedInt322 = new UnsignedInt32((long)((unsignedInt323.intValue() + n5) / n4));
                    unsignedInt32 = new UnsignedInt32((long)(unsignedInt324.intValue() / n4));
                    PIDlparFunctions.debug("Input values are : \nlparID = " + unsignedInt163.toString() + "\nallocMem = " + unsignedInt324.intValue() + "\nnum = " + n5 + "\ntimeout = " + unsignedInt162.intValue() + "\ndetail = " + s + "\ncecIntName = " + string2 + "\nnoRMCConnection = " + bl2 + "\nlparIntName = " + string4 + "\ndestination = " + string5 + "\ndestLparID = " + unsignedInt16.toString() + "\ndestIntName = " + string + "\ndestAllocMem = " + unsignedInt323.intValue() + "\nmemToRemove = " + unsignedInt325.intValue() + "\nmemToAdd = " + unsignedInt322.intValue());
                    fspLockHelper = null;
                    int n7 = 64;
                    PIDlparFunctions.debug("locking FSP...");
                    fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n7);
                    fspLockHelper.addMemLock(omCecMgr.getObjectId());
                    cIMInstance2 = PIDlparFunctions.getCIMInstance(cIMObjectPath, providerCIMOMHandle);
                    PIDlparFunctions.debug("check for a source isLparInCluster()");
                    if (!PIDlparFunctions.isLparInCluster(cIMObjectPath, providerCIMOMHandle)) {
                        PIDlparFunctions.syncInPendingMemToCurrentMem(omCecMgr, unsignedInt163, cIMInstance2, n4);
                    }
                    PIDlparFunctions.debug("getting destLparInst");
                    CIMInstance cIMInstance3 = PIDlparFunctions.getCIMInstance(cIMObjectPath3, providerCIMOMHandle);
                    PIDlparFunctions.debug("check for a dest isLparInCluster()");
                    if (!PIDlparFunctions.isLparInCluster(cIMObjectPath3, providerCIMOMHandle)) {
                        PIDlparFunctions.syncInPendingMemToCurrentMem(omCecMgr, unsignedInt16, cIMInstance3, n4);
                    }
                    PIDlparFunctions.debug("Start the Batch command");
                    omCecMgr.getCmdHelper().startLparBatchMode(unsignedInt164);
                    PIDlparFunctions.debug("StartBatch command over");
                    try {
                        PIDlparFunctions.debug("First SET PENDING on lparID : " + unsignedInt163 + " with value : " + unsignedInt325.intValue());
                        omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt163, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, unsignedInt325, MIN_MAX_CONSTANT);
                        PIDlparFunctions.debug("First SET Pending Over");
                        PIDlparFunctions.debug("Second SET PENDING on destLparID : " + unsignedInt16 + " with destAllocMem : " + unsignedInt322.intValue());
                        omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, unsignedInt322, MIN_MAX_CONSTANT);
                        PIDlparFunctions.debug("Second SET Pending Over");
                    }
                    catch (Throwable throwable) {
                        System.out.println("Caught exception issuing commands to batch stream");
                        System.out.println("Exception = " + throwable);
                        omCecMgr.getCmdHelper().commitLparBatch(NO_COMMIT);
                        if (!(throwable instanceof PIHscServerException)) {
                            throw new PIHscServerException("2933", throwable);
                        }
                        throw (PIHscServerException)throwable;
                    }
                    PIDlparFunctions.debug("Start the Commit Batch command");
                    omCecMgr.getCmdHelper().commitLparBatch(COMMIT);
                    PIDlparFunctions.debug("CommitBatch Over");
                    n3 = 0;
                    try {
                        if (RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath, providerCIMOMHandle))) {
                            if (!bl2) {
                                try {
                                    PIDlparFunctions.debug("making a RMC call to remove " + n5 + " lmbs on source lpar " + string4);
                                    PIDlparFunctions.removeMemRMC(n5 / n4, unsignedInt162.intValue(), s, string2, string4, vector2);
                                    PIDlparFunctions.debug("RMC call over");
                                    break block60;
                                }
                                catch (HSCRMCException hSCRMCException) {
                                    PIDlparFunctions.debug("Error when drmgr excecutes -r cmd on source");
                                    n3 = hSCRMCException.getNumberOfSuccesses();
                                    PIDlparFunctions.debug("Requested : " + n5 / n4 + " , Succeeded : " + n3);
                                    HSCLogUtils.serverLog(hSCRMCException, HSCLogUtils._PartActClassLogInfo);
                                    PIDlparFunctions.debug("Recovery on dest lpar : calling SET PENDING with value " + unsignedInt323.intValue() / n4);
                                    omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, new UnsignedInt32((long)(unsignedInt323.intValue() / n4)), MIN_MAX_CONSTANT);
                                    PIDlparFunctions.debug("Recovery on dest lpar : SET Pending Over");
                                    PIDlparFunctions.debug("Recovery on source lpar : calling SET PENDING with value : " + (unsignedInt32.intValue() - n3));
                                    omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt163, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, new UnsignedInt32((long)(unsignedInt32.intValue() - n3)), MIN_MAX_CONSTANT);
                                    PIDlparFunctions.debug("Recovery on source lpar : SET Pending Over");
                                    throw new PIHscServerException("2933", new String[]{hSCRMCException.toString()}, hSCRMCException);
                                }
                                catch (HSCException hSCException) {
                                    PIDlparFunctions.debug("move HSCException for createRMCClient() : " + hSCException.toString());
                                    HSCLogUtils.serverLog(hSCException, HSCLogUtils._PartActClassLogInfo);
                                    throw new PIHscServerException("2933", new String[]{hSCException.toString()}, hSCException);
                                }
                            }
                            vector2.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
                            break block60;
                        }
                        try {
                            n2 = unsignedInt325.intValue();
                            PIDlparFunctions.debug("Source VaryOff started with value " + n2);
                            omCecMgr.getCmdHelper().varyOnOffMemory(unsignedInt163, new UnsignedInt16(unsignedInt162.intValue() * 60), n2);
                            vector2.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
                            PIDlparFunctions.debug("Source VaryOff Over");
                            bl3 = true;
                        }
                        catch (PIHscServerException pIHscServerException) {
                            PIDlparFunctions.debug("Recovery on source lpar : calling SET PENDING with value : " + unsignedInt32.intValue());
                            omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt163, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, unsignedInt32, MIN_MAX_CONSTANT);
                            PIDlparFunctions.debug("Recovery on source lpar : SET Pending Over");
                            PIDlparFunctions.debug("Recovery on dest lpar : calling SET PENDING with value " + unsignedInt323.intValue() / n4);
                            omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, new UnsignedInt32((long)(unsignedInt323.intValue() / n4)), MIN_MAX_CONSTANT);
                            PIDlparFunctions.debug("Recovery on dest lpar : SET Pending Over");
                            throw pIHscServerException;
                        }
                    }
                    catch (PIHscServerException pIHscServerException) {
                        HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._PartActClassLogInfo);
                        if (!RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath, providerCIMOMHandle)) && !bl3) {
                            vector2.addElement(new CIMProperty(MOF_REMOVE_MEM_RMC_ERROR, new CIMValue((Object)pIHscServerException.toString(), new CIMDataType(9))));
                        }
                        throw pIHscServerException;
                    }
                }
                PIDlparFunctions.debug("Starting runtime check routine ....");
                n2 = 0;
                int n8 = 0;
                FspLparMemory fspLparMemory = null;
                if (!RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath, providerCIMOMHandle))) {
                    try {
                        n = unsignedInt324.intValue() - n5;
                        PIDlparFunctions.debug("afterRemove=" + n);
                        long l = 0L;
                        long l2 = unsignedInt162.intValue() * 60;
                        do {
                            PIDlparFunctions.debug("waited " + l + "seconds, sleeping 30 more seconds....");
                            Thread.currentThread();
                            Thread.sleep(30000L);
                            fspLparMemory = omCecMgr.getCmdHelper().getRuntimeLparMem(unsignedInt163);
                            n8 = fspLparMemory.getRuntimeMem().intValue();
                            PIDlparFunctions.debug("source values are: pending=" + n + " mb and current/runtime=" + n8 * n4 + " mb");
                            if ((l += 30L) != l2 && n != n8 * n4) continue;
                            PIDlparFunctions.debug("timed out in " + l + " seconds");
                        } while (n != n8 * n4);
                    }
                    catch (InterruptedException interruptedException) {
                        HSCLogUtils.serverLog(interruptedException, HSCLogUtils._PartActClassLogInfo);
                        PIDlparFunctions.debug("ERROR: cannot find partition instance");
                        vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)interruptedException.toString(), new CIMDataType(9))));
                    }
                    catch (PIHscCmdMgrException pIHscCmdMgrException) {
                        HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._PartActClassLogInfo);
                        PIDlparFunctions.debug("ERROR: cannot find partition instance");
                        vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)pIHscCmdMgrException.toString(), new CIMDataType(9))));
                    }
                    catch (PIHscServerException pIHscServerException) {
                        HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._PartActClassLogInfo);
                        PIDlparFunctions.debug("ERROR: cannot find partition instance");
                        vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)pIHscServerException.toString(), new CIMDataType(9))));
                    }
                    finally {
                        n2 = unsignedInt32.intValue() - n8;
                    }
                } else {
                    n2 = n3 == 0 ? n5 / n4 : n3;
                }
                PIDlparFunctions.debug("Stopping runtime check routine ....");
                n = 0;
                cIMObjectPath2 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscS1_0");
                cIMObjectPath2.addKey(MOF_NAME, new CIMValue((Object)new String(unsignedInt16 + "*" + string2)));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                if (RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath2, providerCIMOMHandle))) {
                    if (!bl2) {
                        boolean bl5 = false;
                        try {
                            try {
                                PIDlparFunctions.debug("making a call to RMC to Vary On destination lpar");
                                PIDlparFunctions.addMemRMC(n2, unsignedInt162.intValue(), s, string2, string, vector2);
                                PIDlparFunctions.debug("RMC call over");
                            }
                            catch (HSCRMCException hSCRMCException) {
                                PIDlparFunctions.debug("Error when drmgr executes -a on dest lpar");
                                n = n3 = hSCRMCException.getNumberOfSuccesses();
                                bl5 = true;
                                PIDlparFunctions.debug("Requested : " + n2 + " , Succeeded : " + n3);
                                if (n2 != n) {
                                    unsignedInt322 = new UnsignedInt32((long)(unsignedInt323.intValue() / n4 + n));
                                    PIDlparFunctions.debug("Recovery on dest lpar : calling SET PENDING with value : " + unsignedInt322.intValue());
                                    omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, unsignedInt322, MIN_MAX_CONSTANT);
                                    PIDlparFunctions.debug("Recovery on dest lpar : SET Pending Over");
                                }
                                HSCLogUtils.serverLog(hSCRMCException, HSCLogUtils._PartActClassLogInfo);
                                throw new PIHscServerException("2933", new String[]{hSCRMCException.toString()}, hSCRMCException);
                            }
                            catch (HSCException hSCException) {
                                n = 0;
                                bl5 = true;
                                PIDlparFunctions.debug("adding HSCException for createRMCClient() : " + hSCException.toString());
                                HSCLogUtils.serverLog(hSCException, HSCLogUtils._PartActClassLogInfo);
                                throw new PIHscServerException("2931", new String[]{hSCException.toString()}, hSCException);
                            }
                            Object var55_68 = null;
                            if (!bl5 && n == 0) {
                                n = n2;
                            }
                            break block61;
                        }
                        catch (Throwable throwable) {
                            Object var55_69 = null;
                            if (!bl5 && n == 0) {
                                n = n2;
                            }
                            throw throwable;
                        }
                    }
                    vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
                } else {
                    try {
                        int n9 = unsignedInt323.intValue() / n4 + n2;
                        PIDlparFunctions.debug("Dest VaryON started with value " + n9);
                        omCecMgr.getCmdHelper().varyOnOffMemory(unsignedInt16, new UnsignedInt16(unsignedInt162.intValue() * 60), n9);
                        n = n2;
                        vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)"0", new CIMDataType(9))));
                        PIDlparFunctions.debug("Dest VaryON Over");
                        bl = true;
                    }
                    catch (PIHscServerException pIHscServerException) {
                        PIDlparFunctions.debug("Recovery on dest lpar : calling  SET PENDING with value : " + unsignedInt323.intValue() / n4);
                        omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), MIN_MAX_CONSTANT, new UnsignedInt32((long)(unsignedInt323.intValue() / n4)), MIN_MAX_CONSTANT);
                        PIDlparFunctions.debug("Recovery on dest lpar : SET Pending Over");
                        n = 0;
                        throw pIHscServerException;
                    }
                    if (n != n5 / n4) {
                        String[] stringArray = new String[]{HSCResourceBundleUtil.getMessage("PIDLPARBundle", "REMOVE", "Remove"), HSCResourceBundleUtil.getMessage("CECBundle", "COD_MEMORY", "Memory"), Integer.toString(n5) + " MB", Integer.toString(n * n4) + " MB"};
                        throw new PIHscServerException("2935", stringArray, null);
                    }
                }
            }
            Object var57_73 = null;
            try {
                if (fspLockHelper != null) {
                    PIDlparFunctions.debug("Releasing the FSP LOCK");
                    fspLockHelper.unlock();
                }
                Trace.trace("aplphscT", "<- PIDlparFunctions.moveMem()");
            }
            catch (Throwable throwable) {
                PIDlparFunctions.debug("caught exception when release the FSP lock in moveMem()");
                throwable.printStackTrace();
            }
            break block62;
            {
                catch (PIHscServerException pIHscServerException) {
                    HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._PartActClassLogInfo);
                    if (!RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath2, providerCIMOMHandle)) && !bl) {
                        vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)pIHscServerException.toString(), new CIMDataType(9))));
                    }
                    throw pIHscServerException;
                }
                catch (Throwable throwable) {
                    if (!RPA_PARTITION.equals(PIDlparFunctions.getPartitionType(cIMObjectPath, providerCIMOMHandle)) && !bl) {
                        vector2.addElement(new CIMProperty(MOF_ADD_MEM_RMC_ERROR, new CIMValue((Object)throwable.toString(), new CIMDataType(9))));
                    }
                    PIDlparFunctions.debug("addMem error : " + throwable.toString());
                    throw new PIHscServerException("2921", throwable);
                }
            }
            catch (Throwable throwable) {
                Object var57_74 = null;
                try {
                    if (fspLockHelper != null) {
                        PIDlparFunctions.debug("Releasing the FSP LOCK");
                        fspLockHelper.unlock();
                    }
                    Trace.trace("aplphscT", "<- PIDlparFunctions.moveMem()");
                }
                catch (Throwable throwable2) {
                    PIDlparFunctions.debug("caught exception when release the FSP lock in moveMem()");
                    throwable2.printStackTrace();
                }
                throw throwable;
            }
        }
        PIDlparFunctions.debug("Exiting moveMem()");
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<- PIDlparFunction.moveMem");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static void varyOnMemory(OmCecMgr omCecMgr, Vector vector) throws PIHscServerException {
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "-> PIDlparFunction.varyOnMemory");
        }
        System.out.println("in<- PIDlparFunctions : varyOnMemory");
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMProperty.getValue().getValue();
        CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(1);
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMProperty2.getValue().getValue();
        int n = unsignedInt32.intValue();
        CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(2);
        UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMProperty3.getValue().getValue();
        omCecMgr.getCmdHelper().varyOnOffMemory(unsignedInt16, unsignedInt162, n);
        System.out.println("out-> PIDlparFunctions : varyOnMemory");
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<- PIDlparFunction.varyOnMemory");
        }
    }

    public static void varyOffMemory(OmCecMgr omCecMgr, Vector vector) throws PIHscServerException {
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "-> PIDlparFunction.varyOffMemory");
        }
        System.out.println("in<- PIDlparFunctions : varyOffMemory");
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMProperty.getValue().getValue();
        CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(1);
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMProperty2.getValue().getValue();
        int n = unsignedInt32.intValue();
        CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(2);
        UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMProperty3.getValue().getValue();
        omCecMgr.getCmdHelper().varyOnOffMemory(unsignedInt16, unsignedInt162, n);
        System.out.println("out-> PIDlparFunctions : varyOffmemory");
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<- PIDlparFunction.varyOffMemory");
        }
    }

    public static void startLparBatchMode(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "-> PIDlparFunction.startLparBatchMode");
        }
        System.out.println("in<- PIDlparFunctions : startLparBatchMode()");
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMProperty.getValue().getValue();
        UnsignedInt16 unsignedInt162 = omCecMgr.getCmdHelper().startLparBatchMode(unsignedInt16);
        vector2.addElement(new CIMProperty(MOF_ACTUAL_BATCH_SIZE, new CIMValue((Object)unsignedInt162, new CIMDataType(3))));
        System.out.println("out-> PIDlparFunctions : startLparBatchMode()");
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<- PIDlparFunction.startLparBatchMode");
        }
    }

    public static void commitLparBatch(OmCecMgr omCecMgr) throws PIHscServerException {
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "-> PIDlparFunction.commitLparBatchMode");
        }
        System.out.println("in<- PIDlparFunctions : commitLparBatch()");
        omCecMgr.getCmdHelper().commitLparBatch(COMMIT);
        System.out.println("out-> PIDlparFunctions : commitLparBatchMode()");
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<-  PIDlparFunction.commitLparBatchMode");
        }
    }

    private static int getLMBSize(CIMInstance cIMInstance) {
        int n = ((UnsignedInt16)cIMInstance.getProperty("LMBSize").getValue().getValue()).intValue();
        return n;
    }

    public static void getMemInfo(CIMInstance cIMInstance, CIMInstance cIMInstance2, Vector vector, OmCecMgr omCecMgr, CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "-> PIDlparFunction.getMemInfo");
        }
        int n = 0;
        long l = 0L;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        String string = cIMObjectPath.getNameSpace();
        n = PIDlparFunctions.getLMBSize(cIMInstance);
        System.out.println("PIDlparFunctions.java -> getMemInfo() -> lmbSize = " + n);
        if (n == 0) {
            String[] stringArray = null;
            stringArray[0] = Integer.toString(n);
            throw new PIHscServerException("2924", stringArray, null);
        }
        l = PIResourcesAllocationUtils.getAvailableMem(cIMInstance2, cIMInstance, providerCIMOMHandle, string);
        System.out.println("PIDlparFunctions -> getMemInfo -> Available Memory : " + l);
        n2 = ((UnsignedInt32)cIMInstance2.getProperty("PendMinMem").getValue().getValue()).intValue();
        n3 = ((UnsignedInt32)cIMInstance2.getProperty("PendMaxMem").getValue().getValue()).intValue();
        n4 = ((UnsignedInt32)cIMInstance2.getProperty("CurMinMem").getValue().getValue()).intValue();
        n5 = ((UnsignedInt32)cIMInstance2.getProperty("CurAllocMem").getValue().getValue()).intValue();
        n6 = ((UnsignedInt32)cIMInstance2.getProperty("CurMaxMem").getValue().getValue()).intValue();
        n7 = ((UnsignedInt32)cIMInstance2.getProperty("PendMinMem").getValue().getValue()).intValue();
        n8 = ((UnsignedInt32)cIMInstance2.getProperty("PendAllocMem").getValue().getValue()).intValue();
        n9 = ((UnsignedInt32)cIMInstance2.getProperty("PendMaxMem").getValue().getValue()).intValue();
        n10 = ((UnsignedInt32)cIMInstance2.getProperty("RuntimeMem").getValue().getValue()).intValue();
        n11 = ((UnsignedInt32)cIMInstance2.getProperty("RuntimeMinMem").getValue().getValue()).intValue();
        vector.addElement(new CIMProperty(MOF_AVAIL_MEM, PIDlparFunctions.getCIMValueFromLong(l)));
        vector.addElement(new CIMProperty(MOF_MIN_MEM, PIDlparFunctions.getCIMValueFromInt(n2)));
        vector.addElement(new CIMProperty(MOF_MAX_MEM, PIDlparFunctions.getCIMValueFromInt(n3)));
        vector.addElement(new CIMProperty(MOF_CURR_MIN_MEM, PIDlparFunctions.getCIMValueFromInt(n4)));
        vector.addElement(new CIMProperty(MOF_CURR_ALLOC_MEM, PIDlparFunctions.getCIMValueFromInt(n5)));
        vector.addElement(new CIMProperty(MOF_CURR_MAX_MEM, PIDlparFunctions.getCIMValueFromInt(n6)));
        vector.addElement(new CIMProperty(MOF_PEND_MIN_MEM, PIDlparFunctions.getCIMValueFromInt(n7)));
        vector.addElement(new CIMProperty(MOF_PEND_ALLOC_MEM, PIDlparFunctions.getCIMValueFromInt(n8)));
        vector.addElement(new CIMProperty(MOF_PEND_MAX_MEM, PIDlparFunctions.getCIMValueFromInt(n9)));
        vector.addElement(new CIMProperty(MOF_RUNTIME_MEM, PIDlparFunctions.getCIMValueFromInt(n10)));
        vector.addElement(new CIMProperty(MOF_RUNTIME_MIN_MEM, PIDlparFunctions.getCIMValueFromInt(n11)));
        if (1 <= Trace.LEVEL) {
            Trace.trace("appahscT", "<- PIDlparFunction.getMemInfo");
        }
    }

    private static CIMValue getCIMValueFromInt(int n) {
        return new CIMValue((Object)new UnsignedInt32((long)n));
    }

    private static CIMValue getCIMValueFromLong(long l) {
        return new CIMValue((Object)new UnsignedInt32(l));
    }

    /*
     * Loose catch block
     */
    protected static CIMValue cpuDlparTask(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, OmCecMgr omCecMgr, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        block207: {
            UnsignedInt16 unsignedInt16;
            UnsignedInt16 unsignedInt162;
            UnsignedInt16 unsignedInt163;
            UnsignedInt8 unsignedInt8;
            int n;
            Object object;
            int n2;
            FspLockHelper fspLockHelper;
            long l;
            int n3;
            short s;
            int n4;
            block206: {
                Object object2;
                CIMValue cIMValue;
                short s2;
                short s3;
                int n5;
                short s4;
                String string;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                CIMValue cIMValue2;
                CIMValue cIMValue3;
                CIMValue cIMValue4;
                short s5;
                int n6;
                short s6;
                long l2;
                UnsignedInt16 unsignedInt164;
                UnsignedInt16 unsignedInt165;
                UnsignedInt16 unsignedInt166;
                UnsignedInt16 unsignedInt167;
                long l3;
                long l4;
                int n7;
                int n8;
                long l5;
                int n9;
                long l6;
                int n10;
                long l7;
                int n11;
                long l8;
                int n12;
                long l9;
                int n13;
                UnsignedInt16 unsignedInt168;
                UnsignedInt16 unsignedInt169;
                UnsignedInt16 unsignedInt1610;
                CIMInstance cIMInstance;
                CIMInstance cIMInstance2;
                CIMInstance cIMInstance3;
                block204: {
                    boolean bl6;
                    CIMValue cIMValue5;
                    int n14;
                    block202: {
                        String string2;
                        CIMObjectPath cIMObjectPath2;
                        CIMObjectPath cIMObjectPath3;
                        block198: {
                            String string3;
                            block196: {
                                if (3 <= Trace.LEVEL) {
                                    Trace.trace("apcshscD", "in PIDLPARUtils.cpuDlparTask method");
                                }
                                System.out.println("In cpuDlparTask!");
                                String[] stringArray = new String[2];
                                boolean bl7 = false;
                                cIMInstance3 = null;
                                cIMInstance2 = null;
                                cIMObjectPath3 = null;
                                cIMInstance = null;
                                unsignedInt1610 = null;
                                unsignedInt169 = null;
                                Object var15_13 = null;
                                unsignedInt168 = null;
                                boolean bl8 = false;
                                n14 = 0;
                                n13 = 0;
                                l9 = 0L;
                                n12 = 0;
                                l8 = 0L;
                                n11 = 0;
                                l7 = 0L;
                                n10 = 0;
                                l6 = 0L;
                                n9 = 0;
                                l5 = 0L;
                                n8 = 0;
                                n7 = 0;
                                l4 = 0L;
                                l3 = 0L;
                                n4 = 0;
                                unsignedInt167 = null;
                                unsignedInt166 = null;
                                unsignedInt165 = null;
                                unsignedInt164 = null;
                                l2 = 0L;
                                s = 0;
                                s6 = 0;
                                n6 = 0;
                                s5 = 0;
                                cIMValue4 = null;
                                cIMValue5 = null;
                                cIMValue3 = null;
                                cIMValue2 = null;
                                n3 = 0;
                                l = 0L;
                                bl6 = false;
                                bl5 = false;
                                bl4 = false;
                                bl3 = false;
                                bl2 = false;
                                bl = false;
                                Object var67_53 = null;
                                string = cIMObjectPath.getNameSpace();
                                fspLockHelper = null;
                                int n15 = 64;
                                fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n15);
                                fspLockHelper.addProcLock(omCecMgr.getObjectId());
                                fspLockHelper.lock();
                                if (GlobalConfig.callMethodsWithValues) {
                                    n2 = ((UnsignedInt16)((CIMValue)vector.elementAt(0)).getValue()).intValue();
                                    n13 = ((UnsignedInt16)((CIMValue)vector.elementAt(1)).getValue()).intValue();
                                    l9 = ((UnsignedInt32)((CIMValue)vector.elementAt(2)).getValue()).intValue();
                                    s4 = ((UnsignedInt8)((CIMValue)vector.elementAt(3)).getValue()).shortValue();
                                    s = ((UnsignedInt16)((CIMValue)vector.elementAt(4)).getValue()).shortValue();
                                    n4 = ((UnsignedInt16)((CIMValue)vector.elementAt(5)).getValue()).intValue();
                                } else {
                                    n2 = ((UnsignedInt16)((CIMProperty)vector.elementAt(0)).getValue().getValue()).intValue();
                                    n13 = ((UnsignedInt16)((CIMProperty)vector.elementAt(1)).getValue().getValue()).intValue();
                                    l9 = ((UnsignedInt32)((CIMProperty)vector.elementAt(2)).getValue().getValue()).intValue();
                                    s4 = ((UnsignedInt8)((CIMProperty)vector.elementAt(3)).getValue().getValue()).shortValue();
                                    s = ((UnsignedInt16)((CIMProperty)vector.elementAt(4)).getValue().getValue()).shortValue();
                                    n4 = ((UnsignedInt16)((CIMProperty)vector.elementAt(5)).getValue().getValue()).intValue();
                                }
                                String string4 = n2 + "*" + omCecMgr.getCecName();
                                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_Partition", cIMObjectPath.getNameSpace());
                                cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                                cIMObjectPath4.addKey(MOF_NAME, new CIMValue((Object)string4));
                                int[] nArray = PIClusterModifier.checkWlmPolicy(7, (CIMOMHandle)providerCIMOMHandle, cIMObjectPath, cIMObjectPath4, -1);
                                if (nArray[0] != 0) {
                                    System.err.println("WLM: do not allow to MOVE CPU among \n  " + cIMObjectPath + "\n  " + cIMObjectPath4);
                                    throw new PIHscServerException("0500");
                                }
                                boolean bl9 = false;
                                try {
                                    string3 = PIHmcAccessUtils.getInternalResInstId(cIMObjectPath4);
                                    object = new Vector();
                                    object.addElement(string3);
                                    bl9 = PIHscProviderUtils.checkPermission(object, "dlparOperation");
                                }
                                catch (Throwable throwable) {
                                    throw new PIHscServerException("1584");
                                }
                                if (!bl9) {
                                    throw new PIHscServerException("1584");
                                }
                                System.out.println("destination part. ID: " + n2);
                                System.out.println("numProcs: " + n13);
                                System.out.println("numProcUnits: " + l9);
                                System.out.println("sharingMode: " + s4);
                                System.out.println("uncappedWeight: " + s);
                                System.out.println("interactive: " + n4);
                                try {
                                    cIMInstance3 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
                                }
                                catch (CIMException cIMException) {
                                    HSCLogUtils.serverLog(cIMException, HSCLogUtils._PartActClassLogInfo);
                                    System.out.println("ERROR: cannot find partition instance");
                                    object = new CIMValue((Object)new UnsignedInt8(0));
                                    Object var112_68 = null;
                                    try {
                                        if (fspLockHelper != null) {
                                            System.out.println("leaving cpuDlparTask: Releasing the FSP LOCK");
                                            fspLockHelper.unlock();
                                        }
                                        Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
                                    }
                                    catch (Throwable throwable) {
                                        throwable.printStackTrace();
                                    }
                                    return object;
                                }
                                if (cIMInstance3 != null) break block196;
                                System.out.println("ERROR: cannot find partition instance");
                                string3 = new CIMValue((Object)new UnsignedInt8(0));
                                Object var112_69 = null;
                                try {
                                    if (fspLockHelper != null) {
                                        System.out.println("leaving cpuDlparTask: Releasing the FSP LOCK");
                                        fspLockHelper.unlock();
                                    }
                                    Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                                return string3;
                            }
                            string3 = (String)cIMInstance3.getProperty(MOF_NAME).getValue().getValue();
                            object = string3.substring(string3.indexOf(42) + 1);
                            n = Integer.parseInt(string3.substring(0, string3.indexOf("*")));
                            unsignedInt1610 = new UnsignedInt16(n);
                            bl2 = PIDlparFunctions.isLparInCluster(cIMObjectPath, providerCIMOMHandle);
                            if (bl2) {
                                System.out.println("cpuDlparTask: partition is in an eWLM group");
                            } else {
                                System.out.println("cpuDlparTask: partition is NOT in an eWLM group");
                            }
                            n5 = PIDlparFunctions.getOperType(n, n2);
                            if (n13 == 65535 && l9 == -1L) {
                                System.out.println("THIS IS A SET: not adding procs/proc units---------------");
                                bl4 = true;
                            }
                            if (n5 != 3) break block198;
                            cIMObjectPath2 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscS1_0");
                            string2 = String.valueOf(n2);
                            string2 = string2 + "*" + (String)object;
                            System.out.println("destPartName = " + string2);
                            cIMObjectPath2.addKey(MOF_NAME, new CIMValue((Object)string2));
                            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                            bl = PIDlparFunctions.isLparInCluster(cIMObjectPath2, providerCIMOMHandle);
                            if (bl) {
                                System.out.println("cpuDlparTask: target partition is in an eWLM group");
                            } else {
                                System.out.println("cpuDlparTask: target partition is NOT in an eWLM group");
                            }
                            try {
                                cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, providerCIMOMHandle.getClass(cIMObjectPath2, false), false);
                            }
                            catch (CIMException cIMException) {
                                HSCLogUtils.serverLog(cIMException, HSCLogUtils._PartActClassLogInfo);
                                System.out.println("ERROR: cannot find destination partition instance");
                                CIMValue cIMValue6 = new CIMValue((Object)new UnsignedInt8(0));
                                Object var112_70 = null;
                                try {
                                    if (fspLockHelper != null) {
                                        System.out.println("leaving cpuDlparTask: Releasing the FSP LOCK");
                                        fspLockHelper.unlock();
                                    }
                                    Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                                return cIMValue6;
                            }
                            if (cIMInstance2 != null) break block198;
                            System.out.println("ERROR: cannot find destination partition instance");
                            CIMValue cIMValue7 = new CIMValue((Object)new UnsignedInt8(0));
                            Object var112_71 = null;
                            try {
                                if (fspLockHelper != null) {
                                    System.out.println("leaving cpuDlparTask: Releasing the FSP LOCK");
                                    fspLockHelper.unlock();
                                }
                                Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                            return cIMValue7;
                        }
                        cIMObjectPath3 = PIResourcesAllocationUtils.constructCecPath((String)object, "root/ibmhscS1_0");
                        try {
                            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, providerCIMOMHandle.getClass(cIMObjectPath3, false), false);
                        }
                        catch (CIMException cIMException) {
                            HSCLogUtils.serverLog(cIMException, HSCLogUtils._PartActClassLogInfo);
                            System.out.println("ERROR: managed system doesn't exist");
                            string2 = new CIMValue((Object)new UnsignedInt8(0));
                            Object var112_72 = null;
                            try {
                                if (fspLockHelper != null) {
                                    System.out.println("leaving cpuDlparTask: Releasing the FSP LOCK");
                                    fspLockHelper.unlock();
                                }
                                Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                            return string2;
                        }
                        if (cIMInstance != null) break block202;
                        System.out.println("ERROR: managed system doesn't exist");
                        cIMObjectPath2 = new CIMValue((Object)new UnsignedInt8(0));
                        Object var112_73 = null;
                        try {
                            if (fspLockHelper != null) {
                                System.out.println("leaving cpuDlparTask: Releasing the FSP LOCK");
                                fspLockHelper.unlock();
                            }
                            Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        return cIMObjectPath2;
                    }
                    int n16 = ((UnsignedInt8)cIMInstance.getProperty("Mode").getValue().getValue()).intValue();
                    System.out.println("mode = " + n16);
                    int n17 = ((UnsignedInt8)cIMInstance.getProperty("State").getValue().getValue()).intValue();
                    if (n17 == 3) {
                        System.out.println("CEC is powered off - can't do DLPAR op!");
                        throw new PIHscServerException("2912", null);
                    }
                    System.out.println("cecState = " + n17);
                    cIMValue4 = cIMInstance3.getProperty("CurProcMode").getValue();
                    System.out.println("procModeVal = " + cIMValue4);
                    bl6 = false;
                    if (cIMValue4 != null) {
                        s3 = ((UnsignedInt8)cIMValue4.getValue()).shortValue();
                    } else {
                        bl6 = true;
                        s3 = 255;
                    }
                    cIMValue5 = cIMInstance3.getProperty("CurSharingMode").getValue();
                    System.out.println("lparSharingModeVal = " + cIMValue5);
                    s2 = ((UnsignedInt8)cIMValue5.getValue()).shortValue();
                    n14 = ((UnsignedInt8)cIMInstance3.getProperty("DefinitionState").getValue().getValue()).intValue();
                    if (n14 == 130) {
                        bl3 = true;
                    }
                    if (n5 != 1) break block204;
                    System.out.println("removeCpu: RECOVERY RECOVERY RECOVERY RECOVERY RECOVERY RECOVERY");
                    UnsignedInt8 unsignedInt82 = (UnsignedInt8)cIMValue4.getValue();
                    unsignedInt169 = new UnsignedInt16(n2);
                    UnsignedInt16 unsignedInt1611 = new UnsignedInt16(65535);
                    UnsignedInt16 unsignedInt1612 = new UnsignedInt16(65535);
                    UnsignedInt16 unsignedInt1613 = new UnsignedInt16(65535);
                    UnsignedInt32 unsignedInt32 = new UnsignedInt32(-1L);
                    UnsignedInt32 unsignedInt322 = new UnsignedInt32(-1L);
                    UnsignedInt32 unsignedInt323 = new UnsignedInt32(-1L);
                    UnsignedInt8 unsignedInt83 = new UnsignedInt8(s);
                    UnsignedInt8 unsignedInt84 = new UnsignedInt8(s4);
                    UnsignedInt16 unsignedInt1614 = new UnsignedInt16(n4);
                    unsignedInt1612 = new UnsignedInt16(n13);
                    unsignedInt322 = new UnsignedInt32(l9);
                    try {
                        if (unsignedInt82.intValue() == 255) {
                            omCecMgr.getCmdHelper().setLparPendingDedicatedProcessors(unsignedInt1610, unsignedInt1611, unsignedInt1612, unsignedInt1613);
                        } else {
                            omCecMgr.getCmdHelper().setLparPendingSharedProcessors(unsignedInt1610, unsignedInt82, unsignedInt1611, unsignedInt1612, unsignedInt1613, unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt83);
                        }
                    }
                    catch (Throwable throwable) {
                        System.out.println("DLPAR removeCpu: failure in recovery.");
                        throw new PIHscServerException("294F", null);
                    }
                    vector2.setSize(4);
                    if (GlobalConfig.callMethodsWithValues) {
                        vector2.setElementAt(new CIMValue((Object)unsignedInt1612), 0);
                        vector2.setElementAt(new CIMValue((Object)unsignedInt322), 1);
                        vector2.setElementAt(new CIMValue((Object)unsignedInt83), 2);
                        vector2.setElementAt(new CIMValue((Object)unsignedInt1614), 3);
                    } else {
                        vector2.setElementAt(new CIMProperty("CPUSuccesses", new CIMValue((Object)unsignedInt1612)), 0);
                        vector2.setElementAt(new CIMProperty("ProcUnitSuccesses", new CIMValue((Object)unsignedInt322)), 1);
                        vector2.setElementAt(new CIMProperty("UncappedWeightOut", new CIMValue((Object)unsignedInt83)), 2);
                        vector2.setElementAt(new CIMProperty("InteractiveOut", new CIMValue((Object)unsignedInt1614)), 3);
                    }
                    System.out.println("in cpuDlparTask -  size of results = " + vector2.size());
                    CIMValue cIMValue8 = new CIMValue((Object)new UnsignedInt8(0));
                    Object var112_74 = null;
                    try {
                        if (fspLockHelper != null) {
                            System.out.println("leaving cpuDlparTask: Releasing the FSP LOCK");
                            fspLockHelper.unlock();
                        }
                        Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    return cIMValue8;
                }
                if (s != -1) {
                    if (s3 == 255) {
                        System.out.println("ERROR - uncapped and dedicated");
                        throw new PIHscServerException("294F", null);
                    }
                    if (s4 != 255 && s4 == 0 && s != 0) {
                        throw new PIHscServerException("294F", null);
                    }
                    if (s4 == 255 && s2 == 0 && s != 0) {
                        throw new PIHscServerException("294F", null);
                    }
                } else if (s3 != 255 && s2 == 0) {
                    System.out.println("Setting uncapped weight to 0 for capped mode");
                    s = 0;
                } else if (s3 != 255) {
                    cIMValue = cIMInstance3.getProperty("CurUncappedWeight").getValue();
                    System.out.println("uncappedWeightVal = " + cIMValue);
                    if (cIMValue != null) {
                        s = ((UnsignedInt8)cIMValue.getValue()).shortValue();
                        System.out.println("uncappedWeightVal = " + cIMValue);
                    }
                }
                if (s3 == 255) {
                    n12 = ((UnsignedInt16)cIMInstance3.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                    n10 = ((UnsignedInt16)cIMInstance3.getProperty("PendAllocProcs").getValue().getValue()).intValue();
                    System.out.println("addCpu: currentCPU = " + n12);
                    System.out.println("addCpu: pendingCPU = " + n10);
                    if (!bl4 && n12 != n10 && !bl2) {
                        PIDlparFunctions.syncPendingProcstoCurrentProcsDedicated(omCecMgr, unsignedInt1610, n12);
                    }
                } else {
                    n12 = ((UnsignedInt16)cIMInstance3.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                    n10 = ((UnsignedInt16)cIMInstance3.getProperty("PendAllocProcs").getValue().getValue()).intValue();
                    System.out.println("addCpu: current virtual CPU = " + n12);
                    System.out.println("addCpu: pending virtual CPU = " + n10);
                    l8 = ((UnsignedInt32)cIMInstance3.getProperty("CurAllocProcUnits").getValue().getValue()).longValue();
                    l6 = ((UnsignedInt32)cIMInstance3.getProperty("PendAllocProcUnits").getValue().getValue()).longValue();
                    System.out.println("addCpu: currentProcUnits = " + l8);
                    System.out.println("addCpu: pendingProcUnits = " + l6);
                    if (!(bl4 || n12 == n10 && l8 == l6 || bl2)) {
                        PIDlparFunctions.syncPendingProcstoCurrentProcsShared(omCecMgr, unsignedInt1610, s2, n12, l8, s);
                    }
                }
                n8 = ((UnsignedInt16)cIMInstance3.getProperty("CurMinProcs").getValue().getValue()).intValue();
                System.out.println("min. CPU: " + n8);
                n7 = ((UnsignedInt16)cIMInstance3.getProperty("CurMaxProcs").getValue().getValue()).intValue();
                System.out.println("max. CPU: " + n7);
                if (255 != s3) {
                    l4 = ((UnsignedInt32)cIMInstance3.getProperty("CurMinProcUnits").getValue().getValue()).intValue();
                    System.out.println("minProcUnits: " + l4);
                    l3 = ((UnsignedInt32)cIMInstance3.getProperty("CurMaxProcUnits").getValue().getValue()).intValue();
                    System.out.println("maxProcUnits: " + l3);
                }
                if (n5 == 3) {
                    cIMValue2 = cIMInstance2.getProperty("CurProcMode").getValue();
                    System.out.println("destProcModeVal = " + cIMValue2);
                    bl5 = false;
                    if (cIMValue2 != null) {
                        n6 = ((UnsignedInt8)cIMValue2.getValue()).shortValue();
                    } else {
                        bl5 = true;
                        n6 = 255;
                    }
                    if (n6 == 255) {
                        n7 = ((UnsignedInt16)cIMInstance2.getProperty("CurMaxProcs").getValue().getValue()).intValue();
                        System.out.println("dest. max CPU: " + n7);
                        n11 = ((UnsignedInt16)cIMInstance2.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                        n9 = ((UnsignedInt16)cIMInstance2.getProperty("PendAllocProcs").getValue().getValue()).intValue();
                        System.out.println("destCurrentCPU = " + n11);
                        System.out.println("destPendingCPU = " + n9);
                    } else {
                        n7 = ((UnsignedInt16)cIMInstance2.getProperty("CurMaxProcs").getValue().getValue()).intValue();
                        l3 = ((UnsignedInt32)cIMInstance2.getProperty("CurMaxProcUnits").getValue().getValue()).intValue();
                        System.out.println("dest. maxProcUnits: " + l3);
                        n11 = ((UnsignedInt16)cIMInstance2.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                        n9 = ((UnsignedInt16)cIMInstance2.getProperty("PendAllocProcs").getValue().getValue()).intValue();
                        System.out.println("destCurrentCPU = " + n11);
                        System.out.println("destPendingCPU = " + n9);
                        l7 = ((UnsignedInt32)cIMInstance2.getProperty("CurAllocProcUnits").getValue().getValue()).longValue();
                        l5 = ((UnsignedInt32)cIMInstance2.getProperty("PendAllocProcUnits").getValue().getValue()).longValue();
                        System.out.println("destCurrentProcUnits = " + l7);
                        System.out.println("destPendingProcUnits = " + l5);
                    }
                    cIMValue3 = cIMInstance2.getProperty("CurSharingMode").getValue();
                    System.out.println("destLparSharingModeVal = " + cIMValue3);
                    s5 = ((UnsignedInt8)cIMValue3.getValue()).shortValue();
                    if (n6 != 255 && s5 == 0) {
                        System.out.println("Setting dest uncapped weight to 0 for capped mode");
                        s6 = 0;
                    } else if (n6 != 255) {
                        cIMValue = cIMInstance2.getProperty("CurUncappedWeight").getValue();
                        System.out.println("destUncappedWeightVal = " + cIMValue);
                        if (cIMValue != null) {
                            s6 = ((UnsignedInt8)cIMValue.getValue()).shortValue();
                            System.out.println("destUncappedWeight = " + s6);
                        }
                    }
                    unsignedInt169 = new UnsignedInt16(n2);
                    if (n6 == 255) {
                        if (!bl4 && n11 != n9 && !bl) {
                            PIDlparFunctions.syncPendingProcstoCurrentProcsDedicated(omCecMgr, unsignedInt169, n11);
                        }
                    } else if (!(bl4 || n11 == n9 && l7 == l5 || bl)) {
                        PIDlparFunctions.syncPendingProcstoCurrentProcsShared(omCecMgr, unsignedInt169, s5, n11, l7, s6);
                    }
                }
                if (!(n5 != 2 && n5 != 3 || bl4)) {
                    if (s3 == 255) {
                        if (n12 - n13 < n8) {
                            System.out.println("Below minimum!!");
                            System.out.println("minimum CPU: " + n8);
                            System.out.println("number assigned: " + n12);
                            int n18 = n12 - n8;
                            String string5 = Integer.toString(n18);
                            System.out.println("most that can be removed: " + string5);
                            throw new PIHscServerException("2903", new String[]{string5}, null);
                        }
                    } else if (l8 - l9 < l4) {
                        System.out.println("Below minimum!!");
                        System.out.println("minimum Proc Units: " + l4);
                        System.out.println("number assigned: " + l8);
                        long l10 = l8 - l4;
                        String string6 = Long.toString(l10);
                        System.out.println("most that can be removed: " + string6);
                        throw new PIHscServerException("2903", new String[]{string6}, null);
                    }
                }
                if (!bl4 && n5 == 3) {
                    int n19;
                    if (s3 == 255) {
                        if (n6 == 255) {
                            System.out.println("src is DEDICATED and destination is DEDICATED ---- check ----");
                            if (n11 + n13 > n7) {
                                System.out.println("Above maximum!");
                                System.out.println("maximum CPU: " + n7);
                                System.out.println("number assigned: " + n11);
                                int n20 = n7 - n11;
                                String string7 = Integer.toString(n20);
                                System.out.println("most that can be added: " + string7);
                                throw new PIHscServerException("2904", new String[]{string7}, null);
                            }
                        } else {
                            System.out.println("src is DEDICATED and destination is SHARED ---- check ----");
                            if (l7 + (long)(n13 * 100) > l3) {
                                System.out.println("Above maximum!");
                                System.out.println("maxProcUnits: " + l3);
                                System.out.println("number assigned: " + l7);
                                long l11 = l3 - l7;
                                String string8 = Long.toString(l11);
                                System.out.println("most that can be added: " + string8);
                                throw new PIHscServerException("2904", new String[]{string8}, null);
                            }
                        }
                    } else if (l9 != -1L) {
                        if (n6 == 255) {
                            System.out.println("src is SHARED and destination is DEDICATED ---- check ----");
                            if (n11 + (int)(l9 / 100L) > n7) {
                                System.out.println("Above maximum!");
                                System.out.println("maximum CPU: " + n7);
                                System.out.println("number assigned: " + n11);
                                int n21 = n7 - n11;
                                String string9 = Integer.toString(n21);
                                System.out.println("most that can be added: " + string9);
                                throw new PIHscServerException("2904", new String[]{string9}, null);
                            }
                        } else {
                            System.out.println("src is SHARED and destination is SHARED ---- check ----");
                            if (n13 != 65535 && n11 + n13 > n7) {
                                System.out.println("Above maximum!");
                                System.out.println("maximum CPU: " + n7);
                                System.out.println("number assigned: " + n11);
                                int n22 = n7 - n11;
                                String string10 = Integer.toString(n22);
                                System.out.println("most that can be added: " + string10);
                                throw new PIHscServerException("2904", new String[]{string10}, null);
                            }
                            if (l7 + l9 > l3) {
                                System.out.println("Above maximum!");
                                System.out.println("maximum Proc Units: " + l3);
                                System.out.println("number assigned: " + l7);
                                long l12 = l3 - l7;
                                String string11 = Long.toString(l12);
                                System.out.println("most that can be added: " + string11);
                                throw new PIHscServerException("2904", new String[]{string11}, null);
                            }
                        }
                    } else if (n13 != 65535 && n11 + n13 > n7) {
                        System.out.println("Above maximum!");
                        System.out.println("maximum CPU: " + n7);
                        System.out.println("number assigned: " + n11);
                        int n23 = n7 - n11;
                        String string12 = Integer.toString(n23);
                        System.out.println("most that can be added: " + string12);
                        throw new PIHscServerException("2904", new String[]{string12}, null);
                    }
                    if ((n19 = ((UnsignedInt16)cIMInstance.getProperty("MaxI5OSProcUnits").getValue().getValue()).intValue()) > 0) {
                        boolean bl10 = bl3;
                        boolean bl11 = false;
                        boolean bl12 = false;
                        boolean bl13 = false;
                        boolean bl14 = false;
                        boolean bl15 = false;
                        boolean bl16 = false;
                        object2 = null;
                        int n24 = ((UnsignedInt8)cIMInstance2.getProperty("DefinitionState").getValue().getValue()).intValue();
                        if (n24 == 130) {
                            bl11 = true;
                        }
                        if (bl11 && n6 != 255 && s5 == 1) {
                            bl13 = true;
                        }
                        if (bl11 && n6 != 255 && s5 == 0) {
                            bl14 = true;
                        }
                        if (bl11 && n6 == 255) {
                            bl16 = true;
                        }
                        if (bl10 && s3 != 255 && s2 == 0) {
                            bl15 = true;
                        }
                        boolean bl17 = false;
                        boolean bl18 = false;
                        boolean bl19 = false;
                        boolean bl20 = false;
                        boolean bl21 = false;
                        if (s3 == 255) {
                            if (n6 == 255) {
                                bl17 = true;
                            } else {
                                bl18 = true;
                            }
                        } else if (n6 == 255) {
                            bl19 = true;
                        } else {
                            bl20 = true;
                        }
                        if (bl18 && bl13) {
                            bl21 = true;
                        }
                        if (!bl10 && bl11 && !bl21) {
                            bl12 = true;
                        }
                        if (bl15 && bl13) {
                            bl12 = true;
                        }
                        int n25 = 0;
                        int n26 = 0;
                        long l13 = 0L;
                        long l14 = 0L;
                        int n27 = 0;
                        long l15 = 0L;
                        if (l9 != -1L) {
                            l15 = l9;
                        }
                        if (n13 != 65535) {
                            n27 = n13;
                        }
                        if (bl12) {
                            boolean bl22 = true;
                            int n28 = 4;
                            try {
                                if (bl17 || bl19) {
                                    if (bl17) {
                                        n25 = n11 + n27;
                                    } else if (bl19) {
                                        n25 = n11 + (int)(l15 / 100L);
                                    }
                                    n26 = n25;
                                    object2 = PIResourcesAllocationUtils.checkProcsForAlloc(cIMInstance2, n6, cIMInstance, 0, (long)n25 * 100L, providerCIMOMHandle, string, s5, (long)n26 * 100L, n25, n26, n28, bl22);
                                } else {
                                    if (bl18) {
                                        l13 = l7 + (long)(n27 * 100);
                                        n25 = n11;
                                    } else if (bl20) {
                                        l13 = l7 + l15;
                                        n25 = n11 + n27;
                                    }
                                    n26 = n25;
                                    l14 = l13;
                                    object2 = PIResourcesAllocationUtils.checkProcsForAlloc(cIMInstance2, n6, cIMInstance, 0, l13, providerCIMOMHandle, string, s5, l14, n25, n26, n28, bl22);
                                }
                                if (object2.i5OSCapacityCheckingFailed) {
                                    String string13 = object2.allocatedProc.toString();
                                    long l16 = object2.allocatedProcUnits.longValue() - l7;
                                    String string14 = Double.toString((double)l16 / 100.0);
                                    String string15 = (String)cIMInstance2.getProperty(MOF_NAME).getValue().getValue();
                                    if (bl14) {
                                        throw new PIHscServerException("2969", new String[]{String.valueOf(n2), Integer.toString(n19 / 100), string14, String.valueOf(n), String.valueOf(n2)}, null);
                                    }
                                    if (bl13) {
                                        throw new PIHscServerException("296A", new String[]{String.valueOf(n2), Integer.toString(n19 / 100)}, null);
                                    }
                                    throw new PIHscServerException("2968", new String[]{String.valueOf(n2), Integer.toString(n19 / 100)}, null);
                                }
                                HashSet<UnsignedInt16> hashSet = new HashSet<UnsignedInt16>();
                                Hashtable hashtable = new Hashtable();
                                if (null != object2.lparIDs) {
                                    for (int i = 0; i < object2.lparIDs.length; ++i) {
                                        hashSet.add(object2.lparIDs[i]);
                                        hashtable.put(object2.lparIDs[i], object2.lparProcTypes.get(object2.lparIDs[i]));
                                    }
                                    PILparActivateFunc.setStolenLparsToNotBootable(hashSet, hashtable, omCecMgr, null, (PIResourcesAllocationUtils.AllocProcAndLparInfo)object2);
                                }
                            }
                            catch (Throwable throwable) {
                                System.out.println("cpuDlparTask: caught something while checking I5OS Capacity ----- " + throwable);
                                throwable.printStackTrace();
                                if (!(throwable instanceof PIHscServerException)) {
                                    throw new PIHscServerException("2927", throwable);
                                }
                                throw (PIHscServerException)throwable;
                            }
                        }
                    }
                }
                if (n4 != 65535) {
                    if (!bl3) {
                        System.out.println("ERROR: trying to set interactive performance on an RPA partition");
                    }
                    unsignedInt167 = (UnsignedInt16)cIMInstance3.getProperty("CurMinInteractivePerf").getValue().getValue();
                    unsignedInt164 = (UnsignedInt16)cIMInstance3.getProperty("CurAllocInteractivePerf").getValue().getValue();
                    unsignedInt165 = new UnsignedInt16(n4);
                    unsignedInt166 = (UnsignedInt16)cIMInstance3.getProperty("CurMaxInteractivePerf").getValue().getValue();
                    UnsignedInt32 unsignedInt32 = null;
                    if (bl4) {
                        unsignedInt32 = new UnsignedInt32(l8);
                    } else {
                        long l17 = 0L;
                        if (n5 == 1) {
                            if (l2 == 0L) {
                                l2 = PIResourcesAllocationUtils.getAvailProcessing(cIMInstance3, cIMInstance, s3, providerCIMOMHandle, string);
                            }
                            l17 = l8 + l2;
                        } else {
                            l17 = l8 - l9;
                        }
                        unsignedInt32 = new UnsignedInt32(l17);
                    }
                    UnsignedInt16 unsignedInt1615 = new UnsignedInt16(unsignedInt164.intValue() - n4);
                    unsignedInt168 = PIResourcesAllocationUtils.checkInterPerfForAlloc(unsignedInt167, unsignedInt1615, unsignedInt166, unsignedInt32, cIMObjectPath, (String)object, providerCIMOMHandle);
                    System.out.println("activatePartition -> allocatedInteractPerf = " + unsignedInt168);
                }
                try {
                    unsignedInt8 = (UnsignedInt8)cIMValue4.getValue();
                    unsignedInt169 = new UnsignedInt16(n2);
                    unsignedInt163 = new UnsignedInt16(65535);
                    unsignedInt162 = new UnsignedInt16(65535);
                    unsignedInt16 = new UnsignedInt16(65535);
                    UnsignedInt32 unsignedInt32 = new UnsignedInt32(-1L);
                    UnsignedInt32 unsignedInt324 = new UnsignedInt32(-1L);
                    UnsignedInt32 unsignedInt325 = new UnsignedInt32(-1L);
                    UnsignedInt8 unsignedInt85 = new UnsignedInt8(s);
                    object2 = new UnsignedInt8(s6);
                    UnsignedInt8 unsignedInt86 = new UnsignedInt8(s4);
                    if (n5 == 1) {
                        if (s4 != 255 && s4 != s2) {
                            omCecMgr.getCmdHelper().setLparPendingProcessoringMode(unsignedInt1610, unsignedInt8, unsignedInt86);
                        }
                        if (!bl4) {
                            if (s3 == 255) {
                                unsignedInt162 = new UnsignedInt16(n12 + n13);
                            } else {
                                if (n13 != 65535) {
                                    unsignedInt162 = new UnsignedInt16(n12 + n13);
                                }
                                if (l9 != -1L) {
                                    unsignedInt324 = new UnsignedInt32(l8 + l9);
                                }
                            }
                        }
                        if (unsignedInt8.intValue() == 255) {
                            omCecMgr.getCmdHelper().setLparPendingDedicatedProcessors(unsignedInt1610, unsignedInt163, unsignedInt162, unsignedInt16);
                        } else {
                            omCecMgr.getCmdHelper().setLparPendingSharedProcessors(unsignedInt1610, unsignedInt8, unsignedInt163, unsignedInt162, unsignedInt16, unsignedInt32, unsignedInt324, unsignedInt325, unsignedInt85);
                        }
                        if (!bl4) {
                            if (s3 == 255) {
                                n3 = n13;
                                l = l9;
                            } else {
                                l = l9;
                                n3 = n13;
                            }
                        } else {
                            n3 = n13;
                            l = l9;
                        }
                        if (n4 != 65535) {
                            if (!bl3) {
                                System.out.println("ERROR: trying to set interactive performance on an RPA partition");
                            }
                            omCecMgr.getCmdHelper().setLparPendingPerformance(unsignedInt1610, unsignedInt167, unsignedInt168, unsignedInt166);
                        }
                        break block206;
                    }
                    if (n5 == 2) {
                        if (!bl4) {
                            if (s3 == 255) {
                                unsignedInt162 = new UnsignedInt16(n12 - n13);
                            } else {
                                if (n13 != 65535) {
                                    unsignedInt162 = new UnsignedInt16(n12 - n13);
                                }
                                if (l9 != -1L) {
                                    unsignedInt324 = new UnsignedInt32(l8 - l9);
                                }
                            }
                            if (unsignedInt8.intValue() == 255) {
                                omCecMgr.getCmdHelper().setLparPendingDedicatedProcessors(unsignedInt1610, unsignedInt163, unsignedInt162, unsignedInt16);
                            } else {
                                omCecMgr.getCmdHelper().setLparPendingSharedProcessors(unsignedInt1610, unsignedInt8, unsignedInt163, unsignedInt162, unsignedInt16, unsignedInt32, unsignedInt324, unsignedInt325, unsignedInt85);
                            }
                            if (s3 == 255) {
                                n3 = n13;
                                l = l9;
                            } else {
                                l = l9;
                                n3 = n13;
                            }
                        }
                        System.out.println(" setting UNCAPPED_WEIGHT - to " + unsignedInt85);
                        if (s != -1) {
                            omCecMgr.getCmdHelper().setLparPendingSharedProcessors(unsignedInt1610, unsignedInt8, unsignedInt163, unsignedInt162, unsignedInt16, unsignedInt32, unsignedInt324, unsignedInt325, unsignedInt85);
                        }
                        if (n4 != 65535) {
                            if (!bl3) {
                                System.out.println("ERROR: trying to set interactive performance on an RPA partition");
                            }
                            omCecMgr.getCmdHelper().setLparPendingPerformance(unsignedInt1610, unsignedInt167, unsignedInt168, unsignedInt166);
                        }
                        break block206;
                    }
                    if (n5 != 3) break block206;
                    UnsignedInt8 unsignedInt87 = (UnsignedInt8)cIMValue2.getValue();
                    UnsignedInt16 unsignedInt1616 = new UnsignedInt16(65535);
                    UnsignedInt32 unsignedInt326 = new UnsignedInt32(-1L);
                    if (s3 == 255) {
                        unsignedInt162 = new UnsignedInt16(n12 - n13);
                        if (n6 == 255) {
                            unsignedInt1616 = new UnsignedInt16(n11 + n13);
                        } else {
                            unsignedInt326 = new UnsignedInt32(l7 + (long)(n13 * 100));
                        }
                    } else {
                        if (n13 != 65535 && n6 != 255) {
                            unsignedInt162 = new UnsignedInt16(n12 - n13);
                            unsignedInt1616 = new UnsignedInt16(n11 + n13);
                        }
                        if (l9 != -1L) {
                            unsignedInt324 = new UnsignedInt32(l8 - l9);
                            if (n6 == 255) {
                                unsignedInt1616 = new UnsignedInt16(n11 + (int)(l9 / 100L));
                            } else {
                                unsignedInt326 = new UnsignedInt32(l7 + l9);
                            }
                        }
                    }
                    System.out.println("STARTING up BATCH job........");
                    UnsignedInt16 unsignedInt1617 = new UnsignedInt16(2);
                    UnsignedInt16 unsignedInt1618 = omCecMgr.getCmdHelper().startLparBatchMode(unsignedInt1617);
                    try {
                        System.out.println("FIRST SET PENDING.......");
                        if (unsignedInt8.intValue() == 255) {
                            omCecMgr.getCmdHelper().setLparPendingDedicatedProcessors(unsignedInt1610, unsignedInt163, unsignedInt162, unsignedInt16);
                        } else {
                            omCecMgr.getCmdHelper().setLparPendingSharedProcessors(unsignedInt1610, unsignedInt8, unsignedInt163, unsignedInt162, unsignedInt16, unsignedInt32, unsignedInt324, unsignedInt325, unsignedInt85);
                        }
                        System.out.println("SECOND SET PENDING.......");
                        if (unsignedInt87.intValue() == 255) {
                            omCecMgr.getCmdHelper().setLparPendingDedicatedProcessors(unsignedInt169, unsignedInt163, unsignedInt1616, unsignedInt16);
                        } else {
                            omCecMgr.getCmdHelper().setLparPendingSharedProcessors(unsignedInt169, unsignedInt87, unsignedInt163, unsignedInt1616, unsignedInt16, unsignedInt32, unsignedInt326, unsignedInt325, (UnsignedInt8)object2);
                        }
                    }
                    catch (Throwable throwable) {
                        System.out.println("Caught exception issuing commands to batch stream");
                        System.out.println("Exception = " + throwable);
                        omCecMgr.getCmdHelper().commitLparBatch(NO_COMMIT);
                        if (!(throwable instanceof PIHscServerException)) {
                            throw new PIHscServerException("061F", throwable);
                        }
                        throw (PIHscServerException)throwable;
                    }
                    System.out.println("COMMITTING BATCH job........");
                    omCecMgr.getCmdHelper().commitLparBatch(COMMIT);
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof PIHscServerException)) {
                        throwable.printStackTrace();
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                        throw new PIHscServerException("061F", null);
                    }
                    throw (PIHscServerException)throwable;
                }
            }
            PIDlparFunctions.deFastActivate(new Integer(n), new Integer(n2), (String)object, omCecMgr);
            System.out.println("Successful ---- ");
            unsignedInt8 = new UnsignedInt16(n3);
            unsignedInt163 = new UnsignedInt32(l);
            unsignedInt162 = new UnsignedInt8(s);
            unsignedInt16 = new UnsignedInt16(n4);
            vector2.setSize(4);
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue((Object)unsignedInt8), 0);
                vector2.setElementAt(new CIMValue((Object)unsignedInt163), 1);
                vector2.setElementAt(new CIMValue((Object)unsignedInt162), 2);
                vector2.setElementAt(new CIMValue((Object)unsignedInt16), 3);
            } else {
                vector2.setElementAt(new CIMProperty("CPUSuccesses", new CIMValue((Object)unsignedInt8)), 0);
                vector2.setElementAt(new CIMProperty("ProcUnitSuccesses", new CIMValue((Object)unsignedInt163)), 1);
                vector2.setElementAt(new CIMProperty("UncappedWeightOut", new CIMValue((Object)unsignedInt162)), 2);
                vector2.setElementAt(new CIMProperty("InteractiveOut", new CIMValue((Object)unsignedInt16)), 3);
            }
            System.out.println("in the PROVIDER size of results = " + vector2.size());
            Object var112_75 = null;
            try {
                if (fspLockHelper != null) {
                    System.out.println("leaving cpuDlparTask: Releasing the FSP LOCK");
                    fspLockHelper.unlock();
                }
                Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            break block207;
            {
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) {
                        throw new PIHscServerException("061F", throwable);
                    }
                    throw (PIHscServerException)throwable;
                }
            }
            catch (Throwable throwable) {
                Object var112_76 = null;
                try {
                    if (fspLockHelper != null) {
                        System.out.println("leaving cpuDlparTask: Releasing the FSP LOCK");
                        fspLockHelper.unlock();
                    }
                    Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
                }
                catch (Throwable throwable2) {
                    throwable2.printStackTrace();
                }
                throw throwable;
            }
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static CIMValue addCpu(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, OmCecMgr omCecMgr, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        if (3 <= Trace.LEVEL) {
            Trace.trace("apcshscD", "in PIDLPARUtils.addCpu method");
        }
        System.out.println("entering addCpu: ");
        String[] stringArray = new String[2];
        boolean bl6 = false;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMInstance cIMInstance2 = null;
        UnsignedInt16 unsignedInt168 = null;
        int n6 = 0;
        int n5 = 0;
        int n7 = 0;
        String string = null;
        String string2 = null;
        boolean bl7 = false;
        PIHSCRMCClientFactory pIHSCRMCClientFactory = null;
        PIHSCRMCClient pIHSCRMCClient = null;
        PIResourcesAllocationUtils.AllocProcAndLparInfo allocProcAndLparInfo = null;
        UnsignedInt16 unsignedInt169 = null;
        boolean bl8 = false;
        String string3 = cIMObjectPath.getNameSpace();
        short s5 = 0;
        UnsignedInt16 unsignedInt167 = null;
        short s4 = 0;
        UnsignedInt32 unsignedInt324 = null;
        long l3 = 0L;
        UnsignedInt8 unsignedInt82 = null;
        short s6 = 0;
        UnsignedInt16 unsignedInt166 = null;
        short s3 = 0;
        boolean bl5 = false;
        CIMValue cIMValue2 = null;
        UnsignedInt16 unsignedInt165 = null;
        int n4 = 0;
        UnsignedInt16 unsignedInt164 = null;
        UnsignedInt8 unsignedInt8 = null;
        boolean bl4 = false;
        int n3 = 0;
        int n8 = 0;
        long l2 = 0L;
        long l4 = 0L;
        short s2 = 0;
        boolean bl9 = false;
        boolean bl10 = false;
        int n9 = 0;
        long l5 = 0L;
        long l6 = 0L;
        UnsignedInt16 unsignedInt1610 = null;
        UnsignedInt16 unsignedInt1611 = null;
        UnsignedInt16 unsignedInt1612 = null;
        long l7 = 0L;
        CIMValue cIMValue3 = null;
        CIMValue cIMValue4 = null;
        int n2 = 0;
        long l = 0L;
        boolean bl11 = false;
        boolean bl3 = false;
        FspLockHelper fspLockHelper = null;
        int n10 = 64;
        int n11 = 0;
        boolean bl2 = false;
        boolean bl = false;
        try {
            try {
                Object object;
                int n;
                block130: {
                    UnsignedInt32 unsignedInt32;
                    UnsignedInt32 unsignedInt322;
                    UnsignedInt32 unsignedInt323;
                    UnsignedInt16 unsignedInt16;
                    UnsignedInt16 unsignedInt162;
                    UnsignedInt16 unsignedInt163;
                    short s;
                    CIMValue cIMValue;
                    block128: {
                        fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n10);
                        fspLockHelper.addProcLock(omCecMgr.getObjectId());
                        fspLockHelper.lock();
                        if (GlobalConfig.callMethodsWithValues) {
                            unsignedInt167 = (UnsignedInt16)((CIMValue)vector.elementAt(0)).getValue();
                            s4 = unsignedInt167.shortValue();
                            unsignedInt324 = (UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue();
                            l3 = unsignedInt324.intValue();
                            unsignedInt82 = (UnsignedInt8)((CIMValue)vector.elementAt(2)).getValue();
                            s6 = unsignedInt82.shortValue();
                            unsignedInt166 = (UnsignedInt16)((CIMValue)vector.elementAt(3)).getValue();
                            s3 = unsignedInt166.shortValue();
                            unsignedInt165 = (UnsignedInt16)((CIMValue)vector.elementAt(4)).getValue();
                            n4 = unsignedInt165.intValue();
                            unsignedInt164 = (UnsignedInt16)((CIMProperty)vector.elementAt(5)).getValue().getValue();
                            unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.elementAt(6)).getValue().getValue();
                            bl4 = (Boolean)((CIMValue)vector.elementAt(7)).getValue();
                        } else {
                            unsignedInt167 = (UnsignedInt16)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                            s4 = unsignedInt167.shortValue();
                            unsignedInt324 = (UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                            l3 = unsignedInt324.intValue();
                            unsignedInt82 = (UnsignedInt8)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                            s6 = unsignedInt82.shortValue();
                            unsignedInt166 = (UnsignedInt16)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                            s3 = unsignedInt166.shortValue();
                            unsignedInt165 = (UnsignedInt16)((CIMProperty)vector.elementAt(4)).getValue().getValue();
                            n4 = unsignedInt165.intValue();
                            unsignedInt164 = (UnsignedInt16)((CIMProperty)vector.elementAt(5)).getValue().getValue();
                            unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.elementAt(6)).getValue().getValue();
                            bl4 = (Boolean)((CIMProperty)vector.elementAt(7)).getValue().getValue();
                        }
                        System.out.println("numProcs: " + s4);
                        System.out.println("numProcUnits: " + l3);
                        System.out.println("sharingMode: " + s6);
                        System.out.println("uncappedWeight: " + s3);
                        System.out.println("interactive: " + n4);
                        System.out.println("timeout: " + unsignedInt164);
                        System.out.println("detailLevel: " + unsignedInt8);
                        System.out.println("noRMCConnection: " + bl4);
                        bl9 = PIDlparFunctions.isLparInCluster(cIMObjectPath, providerCIMOMHandle);
                        if (bl9) {
                            System.out.println("addCPU: partition is in an eWLM group");
                        } else {
                            System.out.println("addCPU: partition is NOT in an eWLM group");
                        }
                        try {
                            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
                            string2 = (String)cIMInstance.getProperty(MOF_NAME).getValue().getValue();
                            System.out.println("lpar name: " + string2);
                            string = string2.substring(string2.indexOf(42) + 1);
                            System.out.println("cec name: " + string);
                            unsignedInt168 = new UnsignedInt16(string2.substring(0, string2.indexOf("*")));
                            n = unsignedInt168.intValue();
                            System.out.println("lparID = " + n);
                            s5 = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).shortValue();
                            if (130 == s5 || 129 == s5) {
                                n6 = 129;
                            } else if (2 == s5 || 1 == s5 || 4 == s5 || 3 == s5 || 66 == s5 || 65 == s5) {
                                n6 = 1;
                            }
                            System.out.println("PARTITION_TYPE = " + n6);
                            cIMObjectPath2 = PIResourcesAllocationUtils.constructCecPath(string, "root/ibmhscS1_0");
                            cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, providerCIMOMHandle.getClass(cIMObjectPath2, false), false);
                            n5 = ((UnsignedInt8)cIMInstance2.getProperty("Mode").getValue().getValue()).intValue();
                            System.out.println("mode = " + n5);
                            n7 = ((UnsignedInt8)cIMInstance2.getProperty("State").getValue().getValue()).intValue();
                            System.out.println("cecState = " + n7);
                            if (1 == n6 && !bl4) {
                                pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(string);
                                pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient(string2);
                                System.out.println("lpar name = " + string2);
                                System.out.println("mRMCClient = " + pIHSCRMCClient);
                                cIMValue = cIMInstance.getProperty("DLPARCapabilities").getValue();
                                if (cIMValue != null && (n11 = ((UnsignedInt32)cIMValue.getValue()).intValue()) > 15) {
                                    bl2 = true;
                                }
                                System.out.println("dlparCapabilities = " + n11);
                            }
                        }
                        catch (Throwable throwable) {
                            System.out.println(" couldn't get instances  -- bailing.... ");
                            System.out.println("Caught exception during provider setup: " + throwable);
                            throwable.printStackTrace();
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                            throw new PIHscServerException("294E", null);
                        }
                        if (n7 == 3) {
                            System.out.println("CEC is powered off - can't do DLPAR op!");
                            throw new PIHscServerException("2912", null);
                        }
                        cIMValue3 = cIMInstance.getProperty("CurProcMode").getValue();
                        System.out.println("procModeVal = " + cIMValue3);
                        bl11 = false;
                        if (cIMValue3 != null) {
                            s = ((UnsignedInt8)cIMValue3.getValue()).shortValue();
                        } else {
                            bl11 = true;
                            s = 255;
                        }
                        cIMValue4 = cIMInstance.getProperty("CurSharingMode").getValue();
                        System.out.println("lparSharingModeVal = " + cIMValue4);
                        short s7 = ((UnsignedInt8)cIMValue4.getValue()).shortValue();
                        if (s4 == -1 && l3 == -1L) {
                            System.out.println("THIS IS A SET: not adding procs/proc units---------------");
                            bl3 = true;
                        }
                        if (s == 255) {
                            bl5 = true;
                        } else {
                            cIMValue2 = cIMInstance.getProperty("CurUncappedWeight").getValue();
                            System.out.println("currentUncappedWeightVal = " + cIMValue2);
                            if (cIMValue2 != null) {
                                s2 = ((UnsignedInt8)cIMValue2.getValue()).shortValue();
                            }
                            System.out.println("in addCPU: currUWeight = " + s2);
                        }
                        if (n5 != 0) {
                            if (s3 != -1) {
                                if (s == 255) {
                                    System.out.println("ERROR - uncapped and dedicated parameters passed in - invalid combination");
                                    throw new PIHscServerException("294E", null);
                                }
                                if (s6 != 255 && s6 == 0 && s3 != 0) {
                                    System.out.println("ERROR - setting sharingMode to capped, uncapped parameter must be 0");
                                    System.out.println("sharing mode = " + s6);
                                    System.out.println("uncappedWeight = " + s3);
                                    throw new PIHscServerException("294E", null);
                                }
                                if (s6 == 255 && s7 == 0 && s3 != 0) {
                                    throw new PIHscServerException("294E", null);
                                }
                            } else if (s != 255 && s7 == 0) {
                                System.out.println("Setting uncapped weight to 0 for capped mode");
                                System.out.println("ignoring uncapped weight");
                                s3 = 0;
                            } else if (s != 255) {
                                bl5 = true;
                                System.out.println("ignoring uncapped weight");
                                if (cIMValue2 != null) {
                                    unsignedInt166 = new UnsignedInt16(((UnsignedInt8)cIMValue2.getValue()).intValue());
                                    System.out.println("uncappedWeightVal = " + cIMValue2);
                                    s3 = unsignedInt166.shortValue();
                                }
                            }
                        }
                        if (s == 255) {
                            n3 = ((UnsignedInt16)cIMInstance.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                            n8 = ((UnsignedInt16)cIMInstance.getProperty("PendAllocProcs").getValue().getValue()).intValue();
                            System.out.println("addCpu: currentCPU = " + n3);
                            System.out.println("addCpu: pendingCPU = " + n8);
                            if (!bl3 && n3 != n8 && !bl9) {
                                PIDlparFunctions.syncPendingProcstoCurrentProcsDedicated(omCecMgr, unsignedInt168, n3);
                            }
                        } else {
                            n3 = ((UnsignedInt16)cIMInstance.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                            n8 = ((UnsignedInt16)cIMInstance.getProperty("PendAllocProcs").getValue().getValue()).intValue();
                            System.out.println("addCpu: current virtual CPU = " + n3);
                            System.out.println("addCpu: pending virtual CPU = " + n8);
                            l2 = ((UnsignedInt32)cIMInstance.getProperty("CurAllocProcUnits").getValue().getValue()).longValue();
                            l4 = ((UnsignedInt32)cIMInstance.getProperty("PendAllocProcUnits").getValue().getValue()).longValue();
                            System.out.println("addCpu: currentProcUnits = " + l2);
                            System.out.println("addCpu: pendingProcUnits = " + l4);
                            if (!(bl3 || n3 == n8 && l2 == l4 || bl9)) {
                                PIDlparFunctions.syncPendingProcstoCurrentProcsShared(omCecMgr, unsignedInt168, s7, n3, l2, s3);
                            }
                        }
                        if (n5 != 0) {
                            n9 = ((UnsignedInt16)cIMInstance.getProperty("CurMaxProcs").getValue().getValue()).intValue();
                            System.out.println("addCpu: max CPU " + n9);
                            if (255 != s) {
                                l6 = ((UnsignedInt32)cIMInstance.getProperty("CurMaxProcUnits").getValue().getValue()).intValue();
                                System.out.println("addCpu: maxProcUnits " + l6);
                            }
                            if (!bl3) {
                                if (s == 255) {
                                    if (n3 + s4 > n9) {
                                        System.out.println("Above maximum!");
                                        System.out.println("maximum CPU: " + n9);
                                        System.out.println("number assigned: " + n3);
                                        int n12 = n9 - n3;
                                        String string4 = Integer.toString(n12);
                                        System.out.println("most that can be added: " + string4);
                                        throw new PIHscServerException("2904", new String[]{string4}, null);
                                    }
                                } else {
                                    if (s4 != -1 && n3 + s4 > n9) {
                                        System.out.println("Above VIRTUAL maximum!");
                                        System.out.println("maximum VIRTUAL CPU: " + n9);
                                        System.out.println("number requested to be assigned: " + n3);
                                        int n13 = n9 - n3;
                                        String string5 = Integer.toString(n13);
                                        System.out.println("most that can be added: " + string5);
                                        throw new PIHscServerException("2904", new String[]{string5}, null);
                                    }
                                    if (l3 != -1L && l2 + l3 > l6) {
                                        System.out.println("Above maximum!");
                                        System.out.println("maximum Proc Units: " + l6);
                                        System.out.println("number assigned: " + l2);
                                        long l8 = l6 - l2;
                                        String string6 = Long.toString(l8);
                                        System.out.println("most that can be added: " + string6);
                                        throw new PIHscServerException("2904", new String[]{string6}, null);
                                    }
                                }
                            }
                            if (n4 != 65535) {
                                if (129 != n6) {
                                    System.out.println("ERROR: trying to set interactive performance on an RPA partition");
                                    throw new PIHscServerException("294E", null);
                                }
                                unsignedInt1610 = (UnsignedInt16)cIMInstance.getProperty("CurMinInteractivePerf").getValue().getValue();
                                unsignedInt1611 = (UnsignedInt16)cIMInstance.getProperty("CurAllocInteractivePerf").getValue().getValue();
                                unsignedInt1612 = (UnsignedInt16)cIMInstance.getProperty("CurMaxInteractivePerf").getValue().getValue();
                                System.out.println("in addCpu: minInteractPerf = " + unsignedInt1610);
                                System.out.println("in addCpu: maxInteractPerf = " + unsignedInt1612);
                                cIMValue = null;
                                if (bl3) {
                                    cIMValue = new UnsignedInt32(l2);
                                } else {
                                    long l9 = 0L;
                                    if (l7 == 0L) {
                                        l7 = PIResourcesAllocationUtils.getAvailProcessing(cIMInstance, cIMInstance2, s, providerCIMOMHandle, string3);
                                    }
                                    l9 = l2 + l7;
                                    cIMValue = new UnsignedInt32(l9);
                                }
                                unsignedInt163 = new UnsignedInt16(n4 + unsignedInt1611.intValue());
                                unsignedInt169 = PIResourcesAllocationUtils.checkInterPerfForAlloc(unsignedInt1610, unsignedInt163, unsignedInt1612, (UnsignedInt32)cIMValue, cIMObjectPath, string, providerCIMOMHandle);
                                System.out.println("activatePartition -> allocatedInteractPerf = " + unsignedInt169);
                            }
                        }
                        cIMValue = (UnsignedInt8)cIMValue3.getValue();
                        unsignedInt163 = new UnsignedInt16(-1);
                        unsignedInt162 = new UnsignedInt16(-1);
                        UnsignedInt16 unsignedInt1613 = new UnsignedInt16(-1);
                        unsignedInt16 = new UnsignedInt16(-1);
                        unsignedInt323 = new UnsignedInt32(-1L);
                        unsignedInt322 = new UnsignedInt32(-1L);
                        UnsignedInt32 unsignedInt325 = new UnsignedInt32(-1L);
                        unsignedInt32 = new UnsignedInt32(-1L);
                        try {
                            int n14;
                            short s8;
                            int n15 = ((UnsignedInt16)cIMInstance2.getProperty("MaxI5OSProcUnits").getValue().getValue()).intValue();
                            if (n5 == 0) break block128;
                            if (s6 != 255 && s6 != s7) {
                                s8 = 1;
                                boolean bl13 = false;
                                if (1 == s6 && 0 == s7) {
                                    bl13 = true;
                                }
                                if (129 == n6 && n15 > 0 && bl13) {
                                    long l8;
                                    int l13;
                                    if (n9 > n15) {
                                        throw new PIHscServerException("296B", new String[]{string2}, null);
                                    }
                                    n14 = 1;
                                    int bl12 = 16;
                                    int n12 = l13 = n3;
                                    long l9 = l8 = l2;
                                    int n13 = 16;
                                    object = PIResourcesAllocationUtils.checkProcsForAlloc(cIMInstance, s, cIMInstance2, 0, l8, providerCIMOMHandle, string3, s6, l9, l13, n12, n13, n14 != 0);
                                    if (((PIResourcesAllocationUtils.AllocProcAndLparInfo)object).i5OSCapacityCheckingFailed) {
                                        throw new PIHscServerException("296B", new String[]{String.valueOf(n)}, null);
                                    }
                                    HashSet<UnsignedInt16> hashSet = new HashSet<UnsignedInt16>();
                                    Hashtable hashtable = new Hashtable();
                                    if (null != ((PIResourcesAllocationUtils.AllocProcAndLparInfo)object).lparIDs) {
                                        for (int i = 0; i < ((PIResourcesAllocationUtils.AllocProcAndLparInfo)object).lparIDs.length; ++i) {
                                            hashSet.add(((PIResourcesAllocationUtils.AllocProcAndLparInfo)object).lparIDs[i]);
                                            hashtable.put(((PIResourcesAllocationUtils.AllocProcAndLparInfo)object).lparIDs[i], ((PIResourcesAllocationUtils.AllocProcAndLparInfo)object).lparProcTypes.get(((PIResourcesAllocationUtils.AllocProcAndLparInfo)object).lparIDs[i]));
                                        }
                                        PILparActivateFunc.setStolenLparsToNotBootable(hashSet, hashtable, omCecMgr, null, (PIResourcesAllocationUtils.AllocProcAndLparInfo)object);
                                    }
                                }
                                try {
                                    if (s6 == 0) {
                                        System.out.println("addCpu:  uWeight = " + s3);
                                        System.out.println("addCpu: uncapped to capped - set pending command");
                                        omCecMgr.getCmdHelper().setLparPendingSharedProcessors(unsignedInt168, (UnsignedInt8)cIMValue, unsignedInt163, unsignedInt162, unsignedInt16, unsignedInt323, unsignedInt322, unsignedInt32, new UnsignedInt8(0));
                                        if (s2 != 0) {
                                            if (129 == n6) {
                                                System.out.println("addCpu: uncapped to capped - vary command");
                                                omCecMgr.getCmdHelper().varyOnOffProcessing(unsignedInt168, unsignedInt164, unsignedInt162, new UnsignedInt8(0), unsignedInt322, new UnsignedInt16(-1));
                                            } else {
                                                System.out.println("addCpu: uncapped to capped - drmgr command");
                                                if (!bl4) {
                                                    PIDlparFunctions.rmcDLPARCpuOp(pIHSCRMCClient, (short)-1, -1L, s2, unsignedInt164.intValue(), unsignedInt8.shortValue(), "r", bl2);
                                                } else {
                                                    System.out.println("addCpu: no RMC connection - will not issue RMC command to partition");
                                                }
                                            }
                                        }
                                        bl = true;
                                    }
                                    omCecMgr.getCmdHelper().setLparPendingProcessoringMode(unsignedInt168, (UnsignedInt8)cIMValue, unsignedInt82);
                                }
                                catch (Throwable throwable) {
                                    System.out.println("addCpu: failed somewhere trying to set the mode to capped");
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                    throwable.printStackTrace();
                                    if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
                                    throw new PIHscServerException("294E", throwable);
                                }
                            }
                            if (!bl3) {
                                if (s == 255) {
                                    unsignedInt1613 = unsignedInt162 = new UnsignedInt16(n3 + s4);
                                } else {
                                    s8 = s4 == -1 ? (short)0 : s4;
                                    long l12 = l3 == -1L ? 0L : l3;
                                    unsignedInt1613 = unsignedInt162 = new UnsignedInt16(n3 + s8);
                                    unsignedInt325 = unsignedInt322 = new UnsignedInt32(l2 + l12);
                                }
                            }
                            if (!bl3) {
                                CIMValue cIMValue5 = cIMInstance.getProperty("CurSharingMode").getValue();
                                short s9 = ((UnsignedInt8)cIMValue5.getValue()).shortValue();
                                boolean bl12 = false;
                                if (129 == n6 && n15 > 0 && s9 == 1) {
                                    bl12 = true;
                                }
                                n14 = 2;
                                try {
                                    long l10;
                                    block129: {
                                        System.out.println("in addCpu: checkProcsForAlloc -------------");
                                        try {
                                            if (s == 255) {
                                                boolean throwable = false;
                                                allocProcAndLparInfo = PIResourcesAllocationUtils.checkProcsForAlloc(cIMInstance, s, cIMInstance2, 0, (long)unsignedInt162.intValue() * 100L, providerCIMOMHandle, string3, s9, (long)unsignedInt1613.intValue() * 100L, unsignedInt162.intValue(), unsignedInt1613.intValue(), n14, throwable);
                                                break block129;
                                            }
                                            if (l3 != -1L) {
                                                boolean cIMValue6 = false;
                                                allocProcAndLparInfo = PIResourcesAllocationUtils.checkProcsForAlloc(cIMInstance, s, cIMInstance2, 0, unsignedInt322.longValue(), providerCIMOMHandle, string3, s9, unsignedInt325.longValue(), unsignedInt162.intValue(), unsignedInt1613.intValue(), n14, cIMValue6);
                                                break block129;
                                            }
                                            if (bl12) {
                                                boolean bl13 = true;
                                                allocProcAndLparInfo = PIResourcesAllocationUtils.checkProcsForAlloc(cIMInstance, s, cIMInstance2, 0, unsignedInt322.longValue(), providerCIMOMHandle, string3, s9, unsignedInt325.longValue(), unsignedInt162.intValue(), unsignedInt1613.intValue(), n14, bl13);
                                            }
                                        }
                                        catch (Throwable hashSet) {
                                            System.out.println("BARFED - trying to checkProcsForAlloc");
                                            HSCLogUtils.serverLog(hashSet, HSCLogUtils._PartActClassLogInfo);
                                            hashSet.printStackTrace();
                                        }
                                    }
                                    System.out.println("in addCpu: procConfigData = " + allocProcAndLparInfo);
                                    if (null != allocProcAndLparInfo && allocProcAndLparInfo.i5OSCapacityCheckingFailed) {
                                        String string4 = "";
                                        String string5 = "";
                                        int n16 = 0;
                                        double d = 0.0;
                                        if (allocProcAndLparInfo.allocatedProc != null) {
                                            n16 = allocProcAndLparInfo.allocatedProc.intValue();
                                            int n17 = n16 - n3;
                                            string4 = Integer.toString(n17);
                                        }
                                        if (allocProcAndLparInfo.allocatedProcUnits != null) {
                                            long l11 = 0L;
                                            int n18 = 0;
                                            d = allocProcAndLparInfo.allocatedProcUnits.intValue();
                                            if (s == 255) {
                                                n18 = allocProcAndLparInfo.allocatedProcUnits.intValue() - n3 * 100;
                                                string5 = Integer.toString(n18 / 100);
                                            } else {
                                                l11 = allocProcAndLparInfo.allocatedProcUnits.longValue() - l2;
                                                string5 = Double.toString((double)l11 / 100.0);
                                            }
                                        }
                                        if (s == 255) {
                                            throw new PIHscServerException("2965", new String[]{string5}, null);
                                        }
                                        if (s9 != 0) throw new PIHscServerException("2967", new String[]{string4}, null);
                                        throw new PIHscServerException("2966", new String[]{string5}, null);
                                    }
                                    if ((s == 255 || l3 != -1L) && null == allocProcAndLparInfo) {
                                        System.out.println("addCpu:NOT ENOUGH PROCESSING AVAILABLE FOR DLPAR ADD OPERATION.");
                                        throw new PIHscServerException("2914", null);
                                    }
                                    if (s == 255) {
                                        int n19 = allocProcAndLparInfo.allocatedProc.intValue();
                                        if (n19 < s4) {
                                            System.out.println("addCpu:NOT ENOUGH PROCESSING AVAILABLE FOR DLPAR ADD OPERATION.");
                                            throw new PIHscServerException("2914", null);
                                        }
                                    } else if (l3 != -1L && (l10 = allocProcAndLparInfo.allocatedProcUnits.longValue()) < l3) {
                                        System.out.println("addCpu:NOT ENOUGH PROCESSING AVAILABLE FOR DLPAR ADD OPERATION.");
                                        throw new PIHscServerException("2914", null);
                                    }
                                    HashSet<UnsignedInt16> hashSet = new HashSet<UnsignedInt16>();
                                    Hashtable hashtable = new Hashtable();
                                    if ((s == 255 || l3 != -1L || bl12) && null != allocProcAndLparInfo.lparIDs) {
                                        for (int i = 0; i < allocProcAndLparInfo.lparIDs.length; ++i) {
                                            hashSet.add(allocProcAndLparInfo.lparIDs[i]);
                                            hashtable.put(allocProcAndLparInfo.lparIDs[i], allocProcAndLparInfo.lparProcTypes.get(allocProcAndLparInfo.lparIDs[i]));
                                        }
                                        PILparActivateFunc.setStolenLparsToNotBootable(hashSet, hashtable, omCecMgr, null, allocProcAndLparInfo);
                                    }
                                }
                                catch (Throwable throwable) {
                                    System.out.println("addCpu: caught something trying to get avail processing ----- " + throwable);
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                    throwable.printStackTrace();
                                    if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
                                    throw new PIHscServerException("294E", throwable);
                                }
                            }
                            if (255 == s) {
                                if (!bl3) {
                                    omCecMgr.getCmdHelper().setLparPendingDedicatedProcessors(unsignedInt168, unsignedInt163, unsignedInt162, unsignedInt16);
                                }
                            } else if (bl3 && bl) {
                                System.out.println("addCpu: - just setting uncappedToCapped - already did setLparPendingSharedProcessors");
                            } else {
                                omCecMgr.getCmdHelper().setLparPendingSharedProcessors(unsignedInt168, (UnsignedInt8)cIMValue, unsignedInt163, unsignedInt162, unsignedInt16, unsignedInt323, unsignedInt322, unsignedInt32, new UnsignedInt8(s3));
                            }
                            if (n4 != 65535) {
                                omCecMgr.getCmdHelper().setLparPendingPerformance(unsignedInt168, unsignedInt1610, unsignedInt169, unsignedInt1612);
                            }
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                            if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
                            System.out.println("addCpu: caught exception during setPending operation - " + throwable);
                            throwable.printStackTrace();
                            throw new PIHscServerException("294E", throwable);
                        }
                    }
                    if (n5 == 0) {
                        if (s == 255) {
                            unsignedInt162 = new UnsignedInt16(n3 + s4);
                        } else {
                            if (s4 != -1) {
                                unsignedInt162 = new UnsignedInt16(n3 + s4);
                            }
                            if (l3 != -1L) {
                                unsignedInt322 = new UnsignedInt32(l2 + l3);
                            }
                        }
                    }
                    if (bl3 && bl && n4 == 65535) {
                        System.out.println("addCpu: ignoring procs and only setting uncapped to capped");
                    } else {
                        try {
                            if (129 == n6) {
                                System.out.println("addCpu: going to add procs to OS400 partition------");
                                omCecMgr.getCmdHelper().varyOnOffProcessing(unsignedInt168, unsignedInt164, unsignedInt162, new UnsignedInt8(s3), unsignedInt322, unsignedInt165);
                                break block130;
                            }
                            if (!bl4) {
                                if (!bl3) {
                                    System.out.println("addCpu: going to add procs/procunits to RPA partition------");
                                    PIDlparFunctions.rmcDLPARCpuOp(pIHSCRMCClient, s4, l3, (short)-1, unsignedInt164.intValue(), unsignedInt8.shortValue(), "a", bl2);
                                }
                                if (bl5 || bl) break block130;
                                if (s3 < s2) {
                                    PIDlparFunctions.rmcDLPARCpuOp(pIHSCRMCClient, (short)-1, -1L, (short)(s2 - s3), unsignedInt164.intValue(), unsignedInt8.shortValue(), "r", bl2);
                                    break block130;
                                }
                                if (s3 > s2) {
                                    PIDlparFunctions.rmcDLPARCpuOp(pIHSCRMCClient, (short)-1, -1L, (short)(s3 - s2), unsignedInt164.intValue(), unsignedInt8.shortValue(), "a", bl2);
                                    break block130;
                                } else {
                                    System.out.println("addCpu: ignoring call to set uncapped weight to current value.");
                                }
                                break block130;
                            }
                            System.out.println("THERE IS NO RMC CONNECTION - JUST IGNORE -----");
                        }
                        catch (Throwable throwable) {
                            block131: {
                                System.out.println("in addCpu: attempt to vary on resources failed");
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                System.out.println("in addCpu: attempt to roll back after failed vary on");
                                try {
                                    if (n5 == 0) break block131;
                                    if (255 == s) {
                                        if (!bl3) {
                                            omCecMgr.getCmdHelper().setLparPendingDedicatedProcessors(unsignedInt168, unsignedInt163, new UnsignedInt16(n3), unsignedInt16);
                                        }
                                        break block131;
                                    }
                                    if (bl) {
                                        s2 = 0;
                                    }
                                    omCecMgr.getCmdHelper().setLparPendingSharedProcessors(unsignedInt168, (UnsignedInt8)cIMValue, unsignedInt163, new UnsignedInt16(n3), unsignedInt16, unsignedInt323, new UnsignedInt32(l2), unsignedInt32, new UnsignedInt8(s2));
                                }
                                catch (Throwable throwable2) {
                                    HSCLogUtils.serverLog(throwable2, HSCLogUtils._PartActClassLogInfo);
                                    if (throwable2 instanceof PIHscServerException) throw (PIHscServerException)throwable2;
                                    System.out.println("addCpu: caught exception during ROLL BACK  - " + throwable2);
                                    throwable2.printStackTrace();
                                    throw new PIHscServerException("294E", throwable2);
                                }
                            }
                            if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
                            System.out.println("addCpu: caught exception during VARY ON operation - " + throwable);
                            throwable.printStackTrace();
                            throw new PIHscServerException("294E", throwable);
                        }
                    }
                }
                if (n5 != 0) {
                    PIDlparFunctions.deFastActivate(new Integer(n), null, string, omCecMgr);
                }
                System.out.println("addCpu: Successful ---- ");
                UnsignedInt16 unsignedInt1614 = new UnsignedInt16(n2);
                UnsignedInt32 unsignedInt326 = new UnsignedInt32(l);
                Boolean bl15 = new Boolean(false);
                object = "addCpu:  ";
                UnsignedInt8 unsignedInt83 = new UnsignedInt8(unsignedInt166.shortValue());
                if (GlobalConfig.callMethodsWithValues) {
                    vector2.addElement(new CIMValue((Object)bl15));
                    vector2.addElement(new CIMValue(object));
                    vector2.addElement(new CIMValue((Object)unsignedInt167));
                    vector2.addElement(new CIMValue((Object)unsignedInt324));
                    vector2.addElement(new CIMValue((Object)unsignedInt83));
                    vector2.addElement(new CIMValue((Object)unsignedInt165));
                } else {
                    vector2.addElement(new CIMProperty("IsError", new CIMValue((Object)bl15)));
                    vector2.addElement(new CIMProperty("InfoMsg", new CIMValue(object)));
                    vector2.addElement(new CIMProperty("ProcSuccess", new CIMValue((Object)unsignedInt167)));
                    vector2.addElement(new CIMProperty("ProcUnitSuccess", new CIMValue((Object)unsignedInt324)));
                    vector2.addElement(new CIMProperty("UncappedWeightSuccess", new CIMValue((Object)unsignedInt83)));
                    vector2.addElement(new CIMProperty("InteractiveSuccess", new CIMValue((Object)unsignedInt165)));
                }
                System.out.println("leaving addCpu: results = " + vector2);
                cIMValue2 = new CIMValue((Object)new UnsignedInt8(0));
                Object var100_130 = null;
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                System.out.println("leaving addCpu: caught exception - " + throwable);
                throwable.printStackTrace();
                if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
                throw new PIHscServerException("294E", throwable);
            }
        }
        catch (Throwable throwable2) {
            Object var100_131 = null;
            try {
                if (fspLockHelper != null) {
                    System.out.println("leaving addCpu: Releasing the FSP LOCK");
                    fspLockHelper.unlock();
                }
                Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
                throw throwable2;
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                throw throwable2;
            }
        }
        try {}
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return cIMValue2;
        }
        if (fspLockHelper != null) {
            System.out.println("leaving addCpu: Releasing the FSP LOCK");
            fspLockHelper.unlock();
        }
        Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
        return cIMValue2;
    }

    private static void rmcDLPARCpuOp(PIHSCRMCClient pIHSCRMCClient, short n, long l, short s, int n2, short s2, String string, boolean bl) throws PIHscServerException {
        int n3;
        System.out.println("in<- PIDlparFunctions : rmcDLPARCpuOp");
        if (string.equals("a")) {
            if (l != -1L) {
                try {
                    System.out.println("Starting RMC call for Proc Units");
                    pIHSCRMCClient.rmcDLPARCpuOp(-1, l, -1, n2, s2, string);
                    System.out.println("Finished RMC Entitled Capacity call for operation: " + string);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    if (throwable instanceof HSCRMCException) {
                        System.out.println("rmcDLPARCpuOp: caught RMC exception during RMC VARY ON operation - " + throwable);
                        throwable.printStackTrace();
                        throw new PIHscServerException("294E", throwable);
                    }
                    if (!(throwable instanceof PIHscServerException)) {
                        System.out.println("addCpu: caught non-PIHscServerException exception during RMC VARY ON operation - " + throwable);
                        throwable.printStackTrace();
                        throw new PIHscServerException("294E", throwable);
                    }
                    System.out.println("addCpu: caught PIHscServerException exception during RMC VARY ON operation - " + throwable);
                    throw (PIHscServerException)throwable;
                }
            } else {
                System.out.println("---------- NO_PROC_UNITS ---------------");
            }
            if (n != -1) {
                try {
                    System.out.println("Starting RMC call to add Procs");
                    if (bl) {
                        pIHSCRMCClient.rmcDLPARCpuOp(n, -1L, -1, n2, s2, string);
                    } else {
                        for (n3 = 0; n3 < n; ++n3) {
                            pIHSCRMCClient.rmcDLPARCpuOp(1, -1L, -1, n2, s2, string);
                        }
                    }
                    System.out.println("Finished RMC call to add Procs");
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    if (throwable instanceof HSCRMCException) {
                        System.out.println("rmcDLPARCpuOp: caught RMC exception during RMC VARY ON operation - " + throwable);
                        throwable.printStackTrace();
                        throw new PIHscServerException("294E", throwable);
                    }
                    if (!(throwable instanceof PIHscServerException)) {
                        System.out.println("rmcDLPARCpuOp: caught non-PIHscServerException exception during RMC VARY ON operation - " + throwable);
                        throwable.printStackTrace();
                        throw new PIHscServerException("294E", throwable);
                    }
                    System.out.println("rmcDLPARCpuOp: caught PIHscServerException exception during RMC VARY ON operation - " + throwable);
                    throw (PIHscServerException)throwable;
                }
            } else {
                System.out.println("---------- NO_PROCS ---------------");
            }
        } else {
            if (n != -1) {
                try {
                    System.out.println("Starting RMC call to remove Procs");
                    if (bl) {
                        pIHSCRMCClient.rmcDLPARCpuOp(n, -1L, -1, n2, s2, string);
                    } else {
                        for (n3 = 0; n3 < n; ++n3) {
                            pIHSCRMCClient.rmcDLPARCpuOp(1, -1L, -1, n2, s2, string);
                        }
                    }
                    System.out.println("Finished RMC call to remove Procs");
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    if (throwable instanceof HSCRMCException) {
                        System.out.println("rmcDLPARCpuOp: caught RMC exception during RMC VARY OFF operation - " + throwable);
                        throwable.printStackTrace();
                        throw new PIHscServerException("294E", throwable);
                    }
                    if (!(throwable instanceof PIHscServerException)) {
                        System.out.println("rmcDLPARCpuOp: caught non-PIHscServerException exception during RMC VARY OFF operation - " + throwable);
                        throwable.printStackTrace();
                        throw new PIHscServerException("294E", throwable);
                    }
                    System.out.println("rmcDLPARCpuOp: caught PIHscServerException exception during RMC VARY OFF operation - " + throwable);
                    throw (PIHscServerException)throwable;
                }
            } else {
                System.out.println("---------- NO_PROCS ---------------");
            }
            if (l != -1L) {
                try {
                    System.out.println("Starting RMC call for Proc Units");
                    pIHSCRMCClient.rmcDLPARCpuOp(-1, l, -1, n2, s2, string);
                    System.out.println("Finished RMC Entitled Capacity call for operation: " + string);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    if (throwable instanceof HSCRMCException) {
                        System.out.println("rmcDLPARCpuOp: caught RMC exception during RMC VARY OFF operation - " + throwable);
                        throwable.printStackTrace();
                        throw new PIHscServerException("294E", throwable);
                    }
                    if (!(throwable instanceof PIHscServerException)) {
                        System.out.println("rmcDLPARCpuOp: caught non-PIHscServerException exception during RMC VARY OFF operation - " + throwable);
                        throwable.printStackTrace();
                        throw new PIHscServerException("294E", throwable);
                    }
                    System.out.println("rmcDLPARCpuOp: caught PIHscServerException exception during RMC VARY OFF operation - " + throwable);
                    throw (PIHscServerException)throwable;
                }
            } else {
                System.out.println("---------- NO_PROC_UNITS ---------------");
            }
        }
        if (s != -1) {
            try {
                System.out.println("Started RMC call to modify uncapped weight");
                pIHSCRMCClient.rmcDLPARCpuOp(-1, -1L, s, n2, s2, string);
                System.out.println("Finished RMC call to add uncapped weight");
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                if (throwable instanceof HSCRMCException) {
                    System.out.println("rmcDLPARCpuOp: caught RMC exception during RMC uncappedWeight operation - " + throwable);
                    throwable.printStackTrace();
                    throw new PIHscServerException("294E", throwable);
                }
                if (!(throwable instanceof PIHscServerException)) {
                    System.out.println("rmcDLPARCpuOp: caught non-PIHscServerException exception during RMC uncappedWeight operation - " + throwable);
                    throwable.printStackTrace();
                    throw new PIHscServerException("294E", throwable);
                }
                System.out.println("rmcDLPARCpuOp: caught PIHscServerException exception during RMC uncappedWeight operation - " + throwable);
                throw (PIHscServerException)throwable;
            }
        } else {
            System.out.println("---------- NO_UNCAPPED_WEIGHT ---------------");
        }
        System.out.println("out-> PIDlparFunctions : rmcDLPARCpuOp");
    }

    /*
     * Loose catch block
     */
    public static void varyOnOffProcessing(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, OmCecMgr omCecMgr, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        block10: {
            System.out.println("in<- PIDlparFunctions : varyOnOffProcessing");
            Object var5_5 = null;
            boolean bl = false;
            FspLockHelper fspLockHelper = null;
            int n = 64;
            fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n);
            fspLockHelper.addProcLock(omCecMgr.getObjectId());
            fspLockHelper.lock();
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            UnsignedInt16 unsignedInt162 = (UnsignedInt16)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            UnsignedInt32 unsignedInt32 = (UnsignedInt32)((CIMProperty)vector.elementAt(2)).getValue().getValue();
            UnsignedInt16 unsignedInt163 = (UnsignedInt16)((CIMProperty)vector.elementAt(3)).getValue().getValue();
            UnsignedInt8 unsignedInt8 = new UnsignedInt8(unsignedInt163.shortValue());
            UnsignedInt16 unsignedInt164 = (UnsignedInt16)((CIMProperty)vector.elementAt(4)).getValue().getValue();
            UnsignedInt16 unsignedInt165 = (UnsignedInt16)((CIMProperty)vector.elementAt(5)).getValue().getValue();
            omCecMgr.getCmdHelper().varyOnOffProcessing(unsignedInt16, unsignedInt165, unsignedInt162, unsignedInt8, unsignedInt32, unsignedInt164);
            System.out.println("out-> PIDlparFunctions : varyOnOffProcessing");
            Object var17_17 = null;
            try {
                if (fspLockHelper != null) {
                    System.out.println("leaving addCpu: Releasing the FSP LOCK");
                    fspLockHelper.unlock();
                }
                Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            break block10;
            {
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    System.out.println("leaving addCpu: caught exception - " + throwable);
                    throwable.printStackTrace();
                    if (!(throwable instanceof PIHscServerException)) {
                        throw new PIHscServerException("294E", throwable);
                    }
                    throw (PIHscServerException)throwable;
                }
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                try {
                    if (fspLockHelper != null) {
                        System.out.println("leaving addCpu: Releasing the FSP LOCK");
                        fspLockHelper.unlock();
                    }
                    Trace.trace("aplphscT", "<- PIDLPARUtils.addCpu method");
                }
                catch (Throwable throwable2) {
                    throwable2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private static Hashtable getLparProcessorInfo(CIMInstance cIMInstance, CIMInstance cIMInstance2, OmCecMgr omCecMgr, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        short s;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        CIMValue cIMValue = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        cIMValue = cIMInstance.getProperty("CurProcMode").getValue();
        System.out.println("procModeVal = " + cIMValue);
        bl = false;
        if (cIMValue != null) {
            s = ((UnsignedInt8)cIMValue.getValue()).shortValue();
        } else {
            bl = true;
            s = 255;
        }
        hashtable.put("CurProcMode", new UnsignedInt8(s));
        hashtable.put("CurMaxProcs", (UnsignedInt16)cIMInstance.getProperty("CurMaxProcs").getValue().getValue());
        hashtable.put("CurMinProcs", (UnsignedInt16)cIMInstance.getProperty("CurMinProcs").getValue().getValue());
        hashtable.put("CurAllocProcs", (UnsignedInt16)cIMInstance.getProperty("CurAllocProcs").getValue().getValue());
        if (cIMInstance.getProperty("CurMaxProcUnits").getValue() == null) {
            hashtable.put("CurMaxProcUnits", new UnsignedInt32(-1L));
        } else {
            hashtable.put("CurMaxProcUnits", (UnsignedInt32)cIMInstance.getProperty("CurMaxProcUnits").getValue().getValue());
        }
        if (cIMInstance.getProperty("CurMinProcUnits").getValue() == null) {
            hashtable.put("CurMinProcUnits", new UnsignedInt32(-1L));
        } else {
            hashtable.put("CurMinProcUnits", (UnsignedInt32)cIMInstance.getProperty("CurMinProcUnits").getValue().getValue());
        }
        if (cIMInstance.getProperty("CurAllocProcUnits").getValue() == null) {
            hashtable.put("CurAllocProcUnits", new UnsignedInt32(-1L));
        } else {
            hashtable.put("CurAllocProcUnits", (UnsignedInt32)cIMInstance.getProperty("CurAllocProcUnits").getValue().getValue());
        }
        if (cIMInstance.getProperty("CurAllocInteractivePerf").getValue() == null) {
            hashtable.put("CurAllocInteractivePerf", new UnsignedInt16(65535));
        } else {
            hashtable.put("CurAllocInteractivePerf", (UnsignedInt16)cIMInstance.getProperty("CurAllocInteractivePerf").getValue().getValue());
        }
        if (cIMInstance.getProperty("CurMaxInteractivePerf").getValue() == null) {
            hashtable.put("CurMaxInteractivePerf", new UnsignedInt16(65535));
        } else {
            hashtable.put("CurMaxInteractivePerf", (UnsignedInt16)cIMInstance.getProperty("CurMaxInteractivePerf").getValue().getValue());
        }
        if (cIMInstance.getProperty("CurMinInteractivePerf").getValue() == null) {
            hashtable.put("CurMinInteractivePerf", new UnsignedInt16(65535));
        } else {
            hashtable.put("CurMinInteractivePerf", (UnsignedInt16)cIMInstance.getProperty("CurMinInteractivePerf").getValue().getValue());
        }
        if (cIMInstance.getProperty("CurSharingMode").getValue() == null) {
            hashtable.put("CurSharingMode", new UnsignedInt8(255));
        } else {
            hashtable.put("CurSharingMode", (UnsignedInt8)cIMInstance.getProperty("CurSharingMode").getValue().getValue());
        }
        if (cIMInstance.getProperty("CurUncappedWeight").getValue() == null) {
            hashtable.put("CurUncappedWeight", new UnsignedInt16(65535));
        } else {
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMInstance.getProperty("CurUncappedWeight").getValue().getValue();
            hashtable.put("CurUncappedWeight", new UnsignedInt16(unsignedInt8.intValue()));
        }
        return hashtable;
    }

    public static CIMValue getProcessorData(CIMObjectPath cIMObjectPath, Vector vector, OmCecMgr omCecMgr, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMInstance cIMInstance2 = null;
        Object var7_7 = null;
        boolean bl = false;
        long l = 0L;
        boolean bl2 = false;
        long l2 = 0L;
        boolean bl3 = false;
        long l3 = 0L;
        boolean bl4 = false;
        long l4 = 0L;
        boolean bl5 = false;
        Hashtable hashtable = null;
        long l5 = 0L;
        long l6 = 0L;
        String string = cIMObjectPath.getNameSpace();
        Object var29_21 = null;
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            System.out.println("ERROR: cannot find partition instance");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        System.out.println("Partition instance: " + cIMInstance);
        if (cIMInstance == null) {
            System.out.println("ERROR: cannot find partition instance");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        String string2 = (String)cIMInstance.getProperty(MOF_NAME).getValue().getValue();
        String string3 = string2.substring(string2.indexOf(42) + 1);
        System.out.println("cec name: " + string3);
        int n = Integer.parseInt(string2.substring(0, string2.indexOf("*")));
        System.out.println("partition slot ID: " + n);
        try {
            cIMObjectPath2 = PIResourcesAllocationUtils.constructCecPath(string3, "root/ibmhscS1_0");
            cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, providerCIMOMHandle.getClass(cIMObjectPath2, false), false);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.serverLog(cIMException, HSCLogUtils._PartActClassLogInfo);
            System.out.println("ERROR: managed system doesn't exist");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        if (cIMInstance2 == null) {
            System.out.println("ERROR: managed system doesn't exist");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        System.out.println("in getProcessorData:  cecInst = " + cIMInstance2);
        System.out.println("=============================================================");
        System.out.println("in getProcessorData:  lparInst = " + cIMInstance);
        hashtable = PIDlparFunctions.getLparProcessorInfo(cIMInstance, cIMInstance2, omCecMgr, providerCIMOMHandle);
        short s = ((UnsignedInt8)hashtable.get("CurProcMode")).shortValue();
        try {
            l5 = PIResourcesAllocationUtils.getAvailProcessing(cIMInstance, cIMInstance2, s, providerCIMOMHandle, string);
            System.out.println("availProcessing = " + l5);
            if (s == 255) {
                l5 /= 100L;
            }
        }
        catch (Exception exception) {
            HSCLogUtils.serverLog(exception, HSCLogUtils._PartActClassLogInfo);
            System.out.println("ERROR: can't get processor data");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        vector.addElement(new CIMProperty("CurProcMode", new CIMValue((Object)((UnsignedInt8)hashtable.get("CurProcMode")))));
        vector.addElement(new CIMProperty("CurAvailProcUnits", new CIMValue((Object)new UnsignedInt32(l5))));
        vector.addElement(new CIMProperty("CurAllocProcs", new CIMValue((Object)((UnsignedInt16)hashtable.get("CurAllocProcs")))));
        vector.addElement(new CIMProperty("CurMaxProcs", new CIMValue((Object)((UnsignedInt16)hashtable.get("CurMaxProcs")))));
        vector.addElement(new CIMProperty("CurMinProcs", new CIMValue((Object)((UnsignedInt16)hashtable.get("CurMinProcs")))));
        vector.addElement(new CIMProperty("CurAllocProcUnits", new CIMValue((Object)((UnsignedInt32)hashtable.get("CurAllocProcUnits")))));
        vector.addElement(new CIMProperty("CurMaxProcUnits", new CIMValue((Object)((UnsignedInt32)hashtable.get("CurMaxProcUnits")))));
        vector.addElement(new CIMProperty("CurMinProcUnits", new CIMValue((Object)((UnsignedInt32)hashtable.get("CurMinProcUnits")))));
        vector.addElement(new CIMProperty("CurSharingMode", new CIMValue((Object)((UnsignedInt8)hashtable.get("CurSharingMode")))));
        vector.addElement(new CIMProperty("CurUncappedWeight", new CIMValue((Object)((UnsignedInt16)hashtable.get("CurUncappedWeight")))));
        vector.addElement(new CIMProperty("CurAllocInteractivePerf", new CIMValue((Object)((UnsignedInt16)hashtable.get("CurAllocInteractivePerf")))));
        vector.addElement(new CIMProperty("CurMaxInteractivePerf", new CIMValue((Object)((UnsignedInt16)hashtable.get("CurMaxInteractivePerf")))));
        vector.addElement(new CIMProperty("CurMinInteractivePerf", new CIMValue((Object)((UnsignedInt16)hashtable.get("CurMinInteractivePerf")))));
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static int getOperType(int n, int n2) {
        if (n == n2) {
            return 1;
        }
        if (n2 == 0) {
            return 2;
        }
        if (n2 == -1) {
            return 4;
        }
        return 3;
    }

    protected static void deFastActivate(Integer n, Integer n2, String string, OmCecMgr omCecMgr) throws PIHscServerException {
        PIHMCSaveArea pIHMCSaveArea = PIHMCSaveArea.getPIHMCSaveAreaInstance(string);
        if (pIHMCSaveArea == null) {
            System.out.println("deFastActivate:: saveArea table is null for CecName: " + string);
        }
        try {
            if (n != null && n > 0) {
                pIHMCSaveArea.setFastActivation(n, false);
            }
            if (n2 != null && n2 > 0) {
                pIHMCSaveArea.setFastActivation(n2, false);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("05E9", null);
            }
            throw (PIHscServerException)throwable;
        }
    }

    public static CIMValue getIoSlotInfo(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        PIDlparFunctions.debug("in<-PIDlparFunctions : getIoSlotInfo");
        System.out.println("in<-PIDlparFunctions : getIoSlotInfo");
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMProperty.getValue().getValue();
        CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(1);
        UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMProperty2.getValue().getValue();
        CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(2);
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMProperty3.getValue().getValue();
        FspIoSlot[] fspIoSlotArray = omCecMgr.getCmdHelper().getIoSlotsInfo(unsignedInt16, unsignedInt162, unsignedInt32);
        PIDlparFunctions.debug("->PIDlparFunctions : getIoSlotInfo");
        return PIDlparFunctions.goodResponse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CIMValue addIo(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException, CIMException {
        CIMValue cIMValue;
        System.out.println("in<-PIDlparFunctions : addIo");
        UnsignedInt32 unsignedInt32 = null;
        UnsignedInt16 unsignedInt16 = null;
        CIMInstance cIMInstance = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n3 = 0;
        boolean bl = false;
        PIHSCRMCClientFactory pIHSCRMCClientFactory = null;
        PIHSCRMCClient pIHSCRMCClient = null;
        int n4 = 0;
        FspLockHelper fspLockHelper = null;
        int n5 = 64;
        try {
            try {
                Object object;
                int n;
                Vector vector3;
                int n2;
                fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n5);
                fspLockHelper.addAllSlotLock(omCecMgr.getObjectId());
                fspLockHelper.lock();
                System.out.println("addIo: inParams = " + vector);
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
                UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMProperty.getValue().getValue();
                Vector vector4 = null;
                CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(1);
                vector4 = (Vector)cIMProperty2.getValue().getValue();
                CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(2);
                Vector vector5 = (Vector)cIMProperty3.getValue().getValue();
                CIMProperty cIMProperty4 = (CIMProperty)vector.elementAt(3);
                Vector vector6 = (Vector)cIMProperty4.getValue().getValue();
                CIMProperty cIMProperty5 = (CIMProperty)vector.elementAt(4);
                Vector vector7 = (Vector)cIMProperty5.getValue().getValue();
                CIMProperty cIMProperty6 = (CIMProperty)vector.elementAt(5);
                UnsignedInt16 unsignedInt163 = (UnsignedInt16)cIMProperty6.getValue().getValue();
                CIMProperty cIMProperty7 = (CIMProperty)vector.elementAt(6);
                UnsignedInt16 unsignedInt164 = (UnsignedInt16)cIMProperty7.getValue().getValue();
                CIMProperty cIMProperty8 = (CIMProperty)vector.elementAt(7);
                UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty8.getValue().getValue();
                CIMProperty cIMProperty9 = (CIMProperty)vector.elementAt(8);
                boolean bl2 = (Boolean)cIMProperty9.getValue().getValue();
                int n6 = vector5.size();
                UnsignedInt8[] unsignedInt8Array = new UnsignedInt8[n6];
                System.out.println(" size of drcIndices/numSlots = " + n6);
                System.out.println(" size of srcLparIds = " + vector4.size());
                System.out.println(" size of poolIDs = " + vector7.size());
                for (n2 = 0; n2 < n6; ++n2) {
                    unsignedInt8Array[n2] = new UnsignedInt8(0);
                }
                try {
                    cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
                    string = (String)cIMInstance.getProperty(MOF_NAME).getValue().getValue();
                    System.out.println("target lpar name: " + string);
                    string2 = string.substring(string.indexOf(42) + 1);
                    System.out.println("cec name: " + string2);
                    n2 = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).shortValue();
                    if (130 == n2 || 129 == n2) {
                        n3 = 129;
                    } else if (2 == n2 || 1 == n2 || 4 == n2 || 3 == n2 || 66 == n2 || 65 == n2) {
                        n3 = 1;
                    }
                    System.out.println("PARTITION_TYPE = " + n3);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    System.out.println("Caught exception trying to get lparInst: " + throwable);
                    throwable.printStackTrace();
                    throw new PIHscServerException("2928", null);
                }
                if (1 == n3 && !bl2) {
                    try {
                        pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(string2);
                        pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient(string);
                        System.out.println("lpar name = " + string);
                        System.out.println("mRMCClient = " + pIHSCRMCClient);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                        System.out.println("addIo: Exception while trying to create RMC Client");
                        throw new PIHscServerException("2928", null);
                    }
                }
                if ((vector3 = PIResourcesAllocationUtils.getAccessibleLparIds(string2, cIMObjectPath.getNameSpace(), providerCIMOMHandle)) == null) {
                    vector3 = new Vector();
                }
                for (n = 0; n < vector4.size(); ++n) {
                    boolean bl3 = false;
                    object = (UnsignedInt16)vector4.elementAt(n);
                    int n7 = object.intValue();
                    System.out.println("srcLparIdVal = " + n7);
                    if (object.equals((Object)UNASSIGNED) || n7 == 0) {
                        System.out.println("addIo: THE SLOT IS CURRENTLY UNASSIGNED--------");
                        continue;
                    }
                    if (!vector3.contains(object)) {
                        System.out.println("addIo: bad slot - trying to add with no access");
                        unsignedInt8Array[n] = new UnsignedInt8(7);
                        continue;
                    }
                    if (n7 == unsignedInt162.intValue()) {
                        System.out.println("bad slot - adding already owned -- CLIENT should have caught");
                        unsignedInt8Array[n] = new UnsignedInt8(7);
                        continue;
                    }
                    for (int i = 0; i < n; ++i) {
                        int n8 = ((UnsignedInt16)vector4.elementAt(i)).intValue();
                        if (n7 != n8) continue;
                        System.out.println("srcLparId = " + object + "   and compared element = " + (UnsignedInt16)vector4.elementAt(i));
                        if (unsignedInt8Array[i].shortValue() == 7) {
                            System.out.println("already has one SSDS failure - skip it");
                            unsignedInt8Array[n] = new UnsignedInt8(7);
                            bl3 = true;
                            continue;
                        }
                        bl3 = true;
                        System.out.println("skipping the TURKEY - previous SSDS success");
                    }
                    if (bl3) continue;
                    try {
                        string3 = object.intValue() + "*" + string2;
                        System.out.println("srcLparName name: " + string3);
                        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscS1_0");
                        cIMObjectPath2.addKey(MOF_NAME, new CIMValue((Object)string3));
                        cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                        CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, providerCIMOMHandle.getClass(cIMObjectPath2, false), false);
                        UnsignedInt8 unsignedInt82 = (UnsignedInt8)cIMInstance2.getProperty("DefinitionState").getValue().getValue();
                        if (unsignedInt82 == null) {
                            System.out.println("addIo: Failed to set lpar slot definition state");
                            unsignedInt8Array[n] = new UnsignedInt8(7);
                            continue;
                        }
                        int n9 = unsignedInt82.intValue();
                        int n10 = 0;
                        if (n9 == 130) {
                            n10 = 129;
                        } else if (n9 == 2) {
                            n10 = 1;
                        } else if (n9 == 4) {
                            n10 = 3;
                        } else if (n9 == 66) {
                            n10 = 65;
                        } else {
                            if (n9 == 129 || n9 == 1 || n9 == 3 || n9 == 65) continue;
                            System.out.println("addIo: Failed to set lpar slot definition state");
                            unsignedInt8Array[n] = new UnsignedInt8(7);
                            continue;
                        }
                        if (n10 == 0) continue;
                        omCecMgr.getCmdHelper().setLparSlotDefinitionState((UnsignedInt16)object, new UnsignedInt8((short)n10));
                        continue;
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                        System.out.println("addIo: Failed to set lpar slot defination state");
                        unsignedInt8Array[n] = new UnsignedInt8(7);
                    }
                }
                System.out.println("in addIo: number of slots passed in = " + n6);
                for (n = 0; n < n6; ++n) {
                    unsignedInt32 = (UnsignedInt32)vector5.elementAt(n);
                    unsignedInt16 = (UnsignedInt16)vector7.elementAt(n);
                    if (unsignedInt8Array[n].shortValue() == 7) {
                        System.out.println(" continuing beyond a known failure");
                        continue;
                    }
                    try {
                        PIResourcesAllocationUtils.IOInfo iOInfo = PIResourcesAllocationUtils.buildIOInfo(PIResourcesAllocationUtils.constructCecPath(string2, "root/ibmhscS1_0"), unsignedInt162, providerCIMOMHandle);
                        if (iOInfo == null) {
                            System.out.println("couldn't retrieve io info for partition .......");
                            unsignedInt8Array[n] = new UnsignedInt8(7);
                            continue;
                        }
                        object = (PIResourcesAllocationUtils.SlotInstLparIDPair)iOInfo.ioSlotInfoTable.get(unsignedInt32);
                        if (object == null) {
                            System.out.println("couldn't retrieve io slot info for partition .......");
                            unsignedInt8Array[n] = new UnsignedInt8(7);
                            continue;
                        }
                        CIMInstance cIMInstance3 = object.ioSlotInst;
                        if (1 == n3) {
                            boolean bl4 = PICommonUtilMethods.underIOPAndStorageDev(cIMInstance3, cIMObjectPath.getNameSpace());
                            System.out.println("isStorageUnderIOP = " + bl4);
                            System.out.println("slotInst = " + cIMInstance3);
                            if (bl4) {
                                throw new PIHscServerException("063F", null);
                            }
                        }
                        System.out.println("if this works it's a miracle ---- slotInst " + cIMInstance3);
                        if (PIResourcesAllocationUtils.checkIOSlotStateStatus(cIMInstance3)) {
                            System.out.println(" trying to set slot ownership - calling method ");
                            try {
                                omCecMgr.getCmdHelper().setIoSlotOwnerAndPoolId(unsignedInt32, unsignedInt162, unsignedInt16, IO_PRIORITY_DESIRED);
                            }
                            catch (Throwable throwable) {
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                System.out.println(" caught an exception trying to call set ----- " + throwable);
                                throwable.printStackTrace();
                                unsignedInt8Array[n] = new UnsignedInt8(7);
                                continue;
                            }
                            if (129 == n3) {
                                try {
                                    omCecMgr.getCmdHelper().varyOnOffIo(unsignedInt162, unsignedInt163, unsignedInt32, VARY_ON, unsignedInt8);
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                    System.out.println("caught exception trying to vary on slot OS400 " + throwable);
                                    throwable.printStackTrace();
                                    try {
                                        omCecMgr.getCmdHelper().setIoSlotOwnerAndPoolId(unsignedInt32, UNASSIGNED, unsignedInt16, IO_PRIORITY_DESIRED);
                                    }
                                    catch (Throwable throwable2) {
                                        HSCLogUtils.serverLog(throwable2, HSCLogUtils._PartActClassLogInfo);
                                        System.out.println(" addIo: OS400 recovery - EXCEPTION!!! ");
                                        throwable2.printStackTrace();
                                    }
                                    unsignedInt8Array[n] = new UnsignedInt8(7);
                                }
                                continue;
                            }
                            if (1 == n3 && !bl2) {
                                System.out.println("Starting RMC IO ADD operation on slot ploc " + vector6.elementAt(n));
                                String[] stringArray = new String[]{(String)vector6.elementAt(n)};
                                try {
                                    System.out.println("Starting RMC IO ADD operation");
                                    n4 = pIHSCRMCClient.rmcDLPAROp(stringArray.length, unsignedInt163.intValue(), unsignedInt164.shortValue(), "slot", stringArray, "a");
                                }
                                catch (HSCRMCException hSCRMCException) {
                                    HSCLogUtils.serverLog(hSCRMCException, HSCLogUtils._PartActClassLogInfo);
                                    System.out.println("RMC ADD IO operation failed ");
                                    System.out.println(" UNSUCCESSFULLY varied on the slot via RMC");
                                    System.out.println(" physical location code = " + vector6.elementAt(n));
                                    hSCRMCException.printStackTrace();
                                    try {
                                        System.out.println("RMC ADD IO operation failed -- setting slot back to unassigned --");
                                        omCecMgr.getCmdHelper().setIoSlotOwnerAndPoolId(unsignedInt32, UNASSIGNED, unsignedInt16, IO_PRIORITY_DESIRED);
                                    }
                                    catch (Throwable throwable) {
                                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                        System.out.println(" addIo: RPA recovery - EXCEPTION!!! ");
                                        throwable.printStackTrace();
                                    }
                                    unsignedInt8Array[n] = new UnsignedInt8(7);
                                }
                                System.out.println("Finished RMC IO ADD operation - total = " + n4);
                                continue;
                            }
                            System.out.println(" got some unknown partition type -------------");
                            continue;
                        }
                        System.out.println(" slot not in correct state to set ownership.... ");
                        unsignedInt8Array[n] = new UnsignedInt8(3);
                        continue;
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                        System.out.println(" caught an exception trying to call set ----- " + throwable);
                        throwable.printStackTrace();
                        unsignedInt8Array[n] = new UnsignedInt8(7);
                    }
                }
                vector2.addElement(new CIMProperty(MOF_IO_RESULTS, new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
                cIMValue = PIDlparFunctions.goodResponse();
                Object var49_67 = null;
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                System.out.println("addIo: unexpected exception");
                throwable.printStackTrace();
                if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
                throw new PIHscServerException("2928", null);
            }
        }
        catch (Throwable throwable3) {
            Object var49_68 = null;
            try {
                if (fspLockHelper != null) {
                    System.out.println("leaving addIo: Releasing the FSP LOCK");
                    fspLockHelper.unlock();
                }
                Trace.trace("aplphscT", "<- PIDLPARUtils.addIo method");
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throwable4.printStackTrace();
                throw throwable3;
            }
        }
        try {}
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return cIMValue;
        }
        if (fspLockHelper != null) {
            System.out.println("leaving addIo: Releasing the FSP LOCK");
            fspLockHelper.unlock();
        }
        Trace.trace("aplphscT", "<- PIDLPARUtils.addIo method");
        return cIMValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CIMValue removeIo(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        System.out.println("in<-PIDlparFunctions : removeIo");
        UnsignedInt32 unsignedInt32 = null;
        UnsignedInt16 unsignedInt16 = null;
        CIMInstance cIMInstance = null;
        String string = null;
        String string2 = null;
        int n4 = 0;
        boolean bl = false;
        PIHSCRMCClientFactory pIHSCRMCClientFactory = null;
        PIHSCRMCClient pIHSCRMCClient = null;
        Object var14_14 = null;
        CIMInstance cIMInstance2 = null;
        boolean bl2 = false;
        OmCecActResourceUpdater omCecActResourceUpdater = new OmCecActResourceUpdater(omCecMgr);
        FspLockHelper fspLockHelper = null;
        int n5 = 64;
        try {
            CIMValue cIMValue;
            try {
                int n;
                int n2;
                String[] stringArray;
                Vector vector3;
                int n3;
                fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n5);
                fspLockHelper.addAllSlotLock(omCecMgr.getObjectId());
                fspLockHelper.lock();
                System.out.println("in<-PIDlparFunctions : inParams = " + vector);
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
                UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMProperty.getValue().getValue();
                CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(1);
                Vector vector4 = (Vector)cIMProperty2.getValue().getValue();
                CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(2);
                Vector vector5 = (Vector)cIMProperty3.getValue().getValue();
                CIMProperty cIMProperty4 = (CIMProperty)vector.elementAt(3);
                Vector vector6 = (Vector)cIMProperty4.getValue().getValue();
                CIMProperty cIMProperty5 = (CIMProperty)vector.elementAt(4);
                UnsignedInt16 unsignedInt163 = (UnsignedInt16)cIMProperty5.getValue().getValue();
                CIMProperty cIMProperty6 = (CIMProperty)vector.elementAt(5);
                UnsignedInt16 unsignedInt164 = (UnsignedInt16)cIMProperty6.getValue().getValue();
                CIMProperty cIMProperty7 = (CIMProperty)vector.elementAt(6);
                UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty7.getValue().getValue();
                CIMProperty cIMProperty8 = (CIMProperty)vector.elementAt(7);
                boolean bl3 = (Boolean)cIMProperty8.getValue().getValue();
                int n6 = vector4.size();
                UnsignedInt8[] unsignedInt8Array = new UnsignedInt8[n6];
                System.out.println("in removeIo: number of slots passed in = " + n6);
                for (n3 = 0; n3 < n6; ++n3) {
                    unsignedInt8Array[n3] = new UnsignedInt8(0);
                }
                try {
                    cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
                    string = (String)cIMInstance.getProperty(MOF_NAME).getValue().getValue();
                    System.out.println("target lpar name: " + string);
                    string2 = string.substring(string.indexOf(42) + 1);
                    System.out.println("cec name: " + string2);
                    n3 = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).shortValue();
                    if (130 == n3 || 129 == n3) {
                        n4 = 129;
                    } else if (2 == n3 || 1 == n3 || 4 == n3 || 3 == n3 || 66 == n3 || 65 == n3) {
                        n4 = 1;
                    }
                    System.out.println("PARTITION_TYPE = " + n4);
                    vector3 = null;
                    vector3 = CimomWrapper.references((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscS1_0"), cIMObjectPath, "Element", true, true, null);
                    System.out.println("Current activated profile association = " + vector3);
                    if (vector3 != null && vector3.size() > 0) {
                        CIMInstance cIMInstance3 = (CIMInstance)vector3.firstElement();
                        stringArray = (CIMObjectPath)cIMInstance3.getProperty("Setting").getValue().getValue();
                        cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)stringArray, providerCIMOMHandle.getClass((CIMObjectPath)stringArray, false), false);
                    }
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    System.out.println(" couldn't get lpar inst  -- bailing.... ");
                    System.out.println("Caught exception trying to get lparInst: " + throwable);
                    throwable.printStackTrace();
                    throw new PIHscServerException("2929", null);
                }
                if (cIMInstance2 == null) {
                    System.out.println(" there is NO ACTIVATED profile - no check for required slots");
                } else {
                    Vector vector7 = new Vector();
                    vector3 = new Vector();
                    try {
                        vector7 = (Vector)cIMInstance2.getProperty("IOSlots").getValue().getValue();
                        vector3 = (Vector)cIMInstance2.getProperty("IORequirement").getValue().getValue();
                    }
                    catch (Throwable throwable) {
                        System.out.println("in removeIo: IO vectors not initialized..................");
                    }
                    System.out.println("IOSlots = " + vector7);
                    System.out.println("IORequirement = " + vector3);
                    for (int i = 0; i < n6; ++i) {
                        unsignedInt32 = (UnsignedInt32)vector4.elementAt(i);
                        for (int j = 0; j < vector7.size(); ++j) {
                            System.out.println("drcIndex = " + unsignedInt32.toString());
                            System.out.println("Profile IOSlot = " + vector7.elementAt(j).toString());
                            if (!unsignedInt32.toString().equals(vector7.elementAt(j).toString()) || !((String)vector3.elementAt(j)).equalsIgnoreCase("R")) continue;
                            System.out.println("found a REQUIRED slot......... " + unsignedInt32);
                            unsignedInt8Array[i] = new UnsignedInt8(2);
                            bl2 = true;
                        }
                    }
                }
                if (1 == n4 && !bl3) {
                    try {
                        pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(string2);
                        pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient(string);
                        System.out.println("lpar name = " + string);
                        System.out.println("mRMCClient = " + pIHSCRMCClient);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                        System.out.println("removeIo: Exception while trying to create RMC Client");
                        throw new PIHscServerException("2929", null);
                    }
                    n2 = 0;
                    int n7 = n6;
                    Vector vector8 = new Vector();
                    stringArray = new Vector();
                    for (n = 0; n < n6; ++n) {
                        if (unsignedInt8Array[n].shortValue() != 0) continue;
                        String[] stringArray2 = new String[]{(String)vector5.elementAt(n)};
                        try {
                            System.out.println("Starting RMC IO REMOVE operation");
                            int n8 = 0;
                            n8 = pIHSCRMCClient.rmcDLPAROp(stringArray2.length, unsignedInt163.intValue(), unsignedInt164.shortValue(), "slot", stringArray2, "r");
                            System.out.println("Finished RMC IO REMOVE operation - cmdTotal = " + n8);
                            System.out.println("Finished RMC IO REMOVE operation - running total = " + ++n2);
                            continue;
                        }
                        catch (HSCRMCException hSCRMCException) {
                            HSCLogUtils.serverLog(hSCRMCException, HSCLogUtils._PartActClassLogInfo);
                            System.out.println("RMC IO operation failed ");
                            hSCRMCException.printStackTrace();
                            String string3 = hSCRMCException.getMessage();
                            System.out.println(" =============== begin exception msg ===============");
                            System.out.println("exception msg = " + string3);
                            System.out.println(" =============== end exception msg ===============");
                            bl = true;
                            unsignedInt8Array[n] = new UnsignedInt8(7);
                        }
                    }
                    System.out.println("total successes for RMC = " + n2);
                } else {
                    for (n2 = 0; n2 < n6; ++n2) {
                        if (unsignedInt8Array[n2].shortValue() != 0) continue;
                        unsignedInt32 = (UnsignedInt32)vector4.elementAt(n2);
                        System.out.println(" vary off the slot " + unsignedInt32);
                        try {
                            if (bl3) {
                                System.out.println(" Do a FORCE vary off of the slot " + unsignedInt32);
                                omCecMgr.getCmdHelper().varyOnOffIo(unsignedInt162, unsignedInt163, unsignedInt32, VARY_OFF_FORCE, unsignedInt8);
                                continue;
                            }
                            System.out.println(" Do a NORMAL vary off of the slot " + unsignedInt32);
                            omCecMgr.getCmdHelper().varyOnOffIo(unsignedInt162, unsignedInt163, unsignedInt32, VARY_OFF, unsignedInt8);
                            continue;
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                            System.out.println("caught excetpion trying to vary off slot " + throwable);
                            throwable.printStackTrace();
                            unsignedInt8Array[n2] = new UnsignedInt8(7);
                        }
                    }
                }
                for (n2 = 0; n2 < n6; ++n2) {
                    unsignedInt32 = (UnsignedInt32)vector4.elementAt(n2);
                    unsignedInt16 = (UnsignedInt16)vector6.elementAt(n2);
                    if (unsignedInt8Array[n2].shortValue() != 0) {
                        System.out.println("skipping failed slot " + unsignedInt32);
                        continue;
                    }
                    try {
                        omCecMgr.getCmdHelper().setIoSlotOwnerAndPoolId(unsignedInt32, UNASSIGNED, unsignedInt16, IO_PRIORITY_DESIRED);
                        unsignedInt8Array[n2] = new UnsignedInt8(0);
                        if (1 != n4 || bl3) continue;
                        System.out.println("removeIo: updating io slot info --------------");
                        omCecActResourceUpdater.updateRemoveIoSlotOwnerAndPoolId(unsignedInt32);
                        System.out.println("removeIo: updated io slot info --------------");
                        continue;
                    }
                    catch (PIHscServerException pIHscServerException) {
                        HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._PartActClassLogInfo);
                        unsignedInt8Array[n2] = new UnsignedInt8(7);
                        try {
                            if (1 == n4 && !bl3) {
                                System.out.println("Starting RMC IO ADD operation");
                                String string4 = (String)vector5.elementAt(n2);
                                stringArray = new String[]{string4};
                                n = pIHSCRMCClient.rmcDLPAROp(1, unsignedInt163.intValue(), unsignedInt164.shortValue(), "slot", stringArray, "a");
                                System.out.println("Finished RMC IO ADD operation - total = " + n);
                                continue;
                            }
                            System.out.println(" os400 trying to vary on slot where failed to set unassigned");
                            omCecMgr.getCmdHelper().varyOnOffIo(unsignedInt162, unsignedInt163, unsignedInt32, VARY_ON, unsignedInt8);
                            continue;
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                            System.out.println("removeIo: RECOVERY FAILED - WE ARE OUT OF SYNC");
                        }
                    }
                }
                vector2.addElement(new CIMProperty(MOF_IO_RESULTS, new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
                cIMValue = PIDlparFunctions.goodResponse();
                Object var47_62 = null;
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                System.out.println("removeIo: unexpected exception");
                throwable.printStackTrace();
                if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
                throw new PIHscServerException("2929", null);
            }
            try {
                if (fspLockHelper != null) {
                    System.out.println("leaving removeIo: Releasing the FSP LOCK");
                    fspLockHelper.unlock();
                }
                Trace.trace("aplphscT", "<- PIDLPARUtils.removeIo method");
                return cIMValue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return cIMValue;
        }
        catch (Throwable throwable2) {
            Object var47_63 = null;
            try {}
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                throw throwable2;
            }
            if (fspLockHelper != null) {
                System.out.println("leaving removeIo: Releasing the FSP LOCK");
                fspLockHelper.unlock();
            }
            Trace.trace("aplphscT", "<- PIDLPARUtils.removeIo method");
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CIMValue moveIo(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        System.out.println("in<-PIDlparFunctions : moveIo");
        System.out.println("inParams = " + vector);
        UnsignedInt32 unsignedInt32 = null;
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt16 unsignedInt162 = null;
        CIMInstance cIMInstance2 = null;
        CIMInstance cIMInstance3 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        PIHSCRMCClientFactory pIHSCRMCClientFactory = null;
        PIHSCRMCClient pIHSCRMCClient = null;
        PIHSCRMCClient pIHSCRMCClient2 = null;
        Object var19_19 = null;
        CIMInstance cIMInstance4 = null;
        boolean bl2 = false;
        int n5 = 0;
        OmCecActResourceUpdater omCecActResourceUpdater = new OmCecActResourceUpdater(omCecMgr);
        FspLockHelper fspLockHelper = null;
        int n6 = 64;
        try {
            CIMValue cIMValue;
            try {
                int n;
                Object object;
                String[] stringArray;
                UnsignedInt8[] unsignedInt8Array;
                int n7;
                boolean bl4;
                UnsignedInt8 unsignedInt8;
                UnsignedInt16 unsignedInt165;
                UnsignedInt16 unsignedInt164;
                Vector vector4;
                Vector vector3;
                Object object2;
                UnsignedInt16 unsignedInt163;
                block75: {
                    block76: {
                        block74: {
                            block73: {
                                CIMInstance cIMInstance;
                                int n2;
                                String string;
                                String string2;
                                fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n6);
                                fspLockHelper.addAllSlotLock(omCecMgr.getObjectId());
                                fspLockHelper.lock();
                                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
                                unsignedInt163 = (UnsignedInt16)cIMProperty.getValue().getValue();
                                boolean bl3 = false;
                                try {
                                    string2 = unsignedInt163 + "*" + omCecMgr.getCecName();
                                    object2 = new CIMObjectPath("IBMHSC_Partition", cIMObjectPath.getNameSpace());
                                    object2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                                    object2.addKey(MOF_NAME, new CIMValue((Object)string2));
                                    string = PIHmcAccessUtils.getInternalResInstId((CIMObjectPath)object2);
                                    vector3 = new Vector();
                                    vector3.addElement(string);
                                    bl3 = PIHscProviderUtils.checkPermission(vector3, "dlparOperation");
                                }
                                catch (Throwable throwable) {
                                    throw new PIHscServerException("1584");
                                }
                                if (!bl3) {
                                    throw new PIHscServerException("1584");
                                }
                                string2 = (CIMProperty)vector.elementAt(1);
                                object2 = (Vector)string2.getValue().getValue();
                                string = (CIMProperty)vector.elementAt(2);
                                vector3 = (Vector)string.getValue().getValue();
                                CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(3);
                                vector4 = (Vector)cIMProperty2.getValue().getValue();
                                CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(4);
                                unsignedInt164 = (UnsignedInt16)cIMProperty3.getValue().getValue();
                                CIMProperty cIMProperty4 = (CIMProperty)vector.elementAt(5);
                                unsignedInt165 = (UnsignedInt16)cIMProperty4.getValue().getValue();
                                CIMProperty cIMProperty5 = (CIMProperty)vector.elementAt(6);
                                unsignedInt8 = (UnsignedInt8)cIMProperty5.getValue().getValue();
                                CIMProperty cIMProperty6 = (CIMProperty)vector.elementAt(7);
                                bl4 = (Boolean)cIMProperty6.getValue().getValue();
                                n7 = ((Vector)object2).size();
                                unsignedInt8Array = new UnsignedInt8[n7];
                                System.out.println("in moveIo: number of slots passed in = " + n7);
                                for (n2 = 0; n2 < n7; ++n2) {
                                    unsignedInt8Array[n2] = new UnsignedInt8(0);
                                }
                                try {
                                    cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
                                    string3 = (String)cIMInstance2.getProperty(MOF_NAME).getValue().getValue();
                                    unsignedInt162 = new UnsignedInt16(string3.substring(0, string3.indexOf("*")));
                                    System.out.println("target lpar name: " + string3);
                                    System.out.println("target lpar ID: " + unsignedInt162);
                                    string4 = string3.substring(string3.indexOf(42) + 1);
                                    System.out.println("cec name: " + string4);
                                    n2 = ((UnsignedInt8)cIMInstance2.getProperty("DefinitionState").getValue().getValue()).shortValue();
                                    if (130 == n2 || 129 == n2) {
                                        n3 = 129;
                                    } else if (2 == n2 || 1 == n2 || 4 == n2 || 3 == n2 || 66 == n2 || 65 == n2) {
                                        n3 = 1;
                                    }
                                    System.out.println("SOURCE PARTITION_TYPE = " + n3);
                                    stringArray = null;
                                    stringArray = CimomWrapper.references((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscS1_0"), cIMObjectPath, "Element", true, true, null);
                                    System.out.println("Current activated profile association = " + stringArray);
                                    cIMInstance = CimomWrapper.referenceNames((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscS1_0"), cIMObjectPath, null).elements();
                                    if (stringArray != null && stringArray.size() > 0) {
                                        object = (String[])stringArray.firstElement();
                                        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)object.getProperty("Setting").getValue().getValue();
                                        cIMInstance4 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, providerCIMOMHandle.getClass(cIMObjectPath2, false), false);
                                    }
                                    if (cIMInstance4 != null) {
                                        System.out.println(" there is an ACTIVATED profile----");
                                    } else {
                                        System.out.println(" there is NO ACTIVATED profile---- ?????");
                                    }
                                    object = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscS1_0");
                                    string5 = String.valueOf(unsignedInt163);
                                    string5 = string5 + "*" + string4;
                                    System.out.println("destPartName = " + string5);
                                    object.addKey(MOF_NAME, new CIMValue((Object)string5));
                                    object.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                                    cIMInstance3 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)object, providerCIMOMHandle.getClass((CIMObjectPath)object, false), false);
                                    short s = ((UnsignedInt8)cIMInstance3.getProperty("DefinitionState").getValue().getValue()).shortValue();
                                    if (130 == s || 129 == s) {
                                        n4 = 129;
                                    } else if (2 == s || 1 == s || 4 == s || 3 == s || 66 == s || 65 == s) {
                                        n4 = 1;
                                    }
                                    System.out.println("DESTINATION PARTITION_TYPE = " + n4);
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                    System.out.println(" couldn't get the necessary lpar instances   -- bailing.... ");
                                    System.out.println("Caught exception trying to get lparInst: " + throwable);
                                    throwable.printStackTrace();
                                    throw new PIHscServerException("2930", null);
                                }
                                if (1 == n4) {
                                    for (n2 = 0; n2 < ((Vector)object2).size(); ++n2) {
                                        stringArray = (UnsignedInt32)((Vector)object2).elementAt(n2);
                                        System.out.println("slotIndex = " + stringArray);
                                        cIMInstance = PIDlparFunctions.getIoSlotInstFromDrcIndex((UnsignedInt32)stringArray, omCecMgr, cIMObjectPath.getNameSpace(), providerCIMOMHandle);
                                        System.out.println("slotInst = " + cIMInstance);
                                        if (cIMInstance == null) continue;
                                        boolean bl5 = PICommonUtilMethods.underIOPAndStorageDev(cIMInstance, cIMObjectPath.getNameSpace());
                                        System.out.println("DLPAR isStorageUnderIOP = " + bl5);
                                        System.out.println("DLPAR slotInst = " + cIMInstance);
                                        if (!bl5) continue;
                                        throw new PIHscServerException("063F", null);
                                    }
                                }
                                if (cIMInstance4 == null) {
                                    System.out.println(" there is NO ACTIVATED profile - no check for required slots");
                                } else {
                                    Vector vector5 = new Vector();
                                    stringArray = new Vector();
                                    try {
                                        vector5 = (Vector)cIMInstance4.getProperty("IOSlots").getValue().getValue();
                                        stringArray = (Vector)cIMInstance4.getProperty("IORequirement").getValue().getValue();
                                    }
                                    catch (Throwable throwable) {
                                        System.out.println("in removeIo: IO vectors not initialized..................");
                                    }
                                    System.out.println("IOSlots = " + vector5);
                                    System.out.println("IORequirement = " + stringArray);
                                    for (int i = 0; i < n7; ++i) {
                                        unsignedInt32 = (UnsignedInt32)((Vector)object2).elementAt(i);
                                        for (int j = 0; j < vector5.size(); ++j) {
                                            System.out.println("drcIndex = " + unsignedInt32.toString());
                                            System.out.println("Profile IOSlot = " + vector5.elementAt(j).toString());
                                            if (!unsignedInt32.toString().equals(vector5.elementAt(j).toString()) || !((String)stringArray.elementAt(j)).equalsIgnoreCase("R")) continue;
                                            System.out.println("found a REQUIRED slot......... " + unsignedInt32);
                                            unsignedInt8Array[i] = new UnsignedInt8(2);
                                            bl2 = true;
                                        }
                                    }
                                }
                                System.out.println("Requesting SLOT LOCKS for IO slots to be moved.......");
                                for (n = 0; n < n7; ++n) {
                                    if (unsignedInt8Array[n].shortValue() != 0) continue;
                                    unsignedInt32 = (UnsignedInt32)((Vector)object2).elementAt(n);
                                    System.out.println(" set pending slot lock owner for slot " + unsignedInt32);
                                    try {
                                        omCecMgr.getCmdHelper().setPendingSlotLockOwner(unsignedInt32, unsignedInt162);
                                        continue;
                                    }
                                    catch (Throwable throwable) {
                                        System.out.println("caught exception trying to pending slot lock owner " + throwable);
                                        throwable.printStackTrace();
                                        unsignedInt8Array[n] = new UnsignedInt8(7);
                                    }
                                }
                                if (1 == n3 && !bl4) {
                                    try {
                                        pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(string4);
                                        pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient(string3);
                                        System.out.println("lpar name = " + string3);
                                        System.out.println("mRMCClient = " + pIHSCRMCClient);
                                    }
                                    catch (Throwable throwable) {
                                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                        System.out.println("moveIo: Exception while trying to create Source RMC Client");
                                        throw new PIHscServerException("2930", null);
                                    }
                                }
                                if (1 == n4 && !bl4) {
                                    try {
                                        if (null == pIHSCRMCClientFactory) {
                                            pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(string4);
                                        }
                                        pIHSCRMCClient2 = pIHSCRMCClientFactory.createRMCClient(string5);
                                        System.out.println("dest lpar name = " + string5);
                                        System.out.println("destRMCClient = " + pIHSCRMCClient2);
                                    }
                                    catch (Throwable throwable) {
                                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                        System.out.println("moveIo: Exception while trying to create Destination RMC Client");
                                        throw new PIHscServerException("2930", null);
                                    }
                                }
                                if (1 != n3 || bl4) break block73;
                                n = n7;
                                stringArray = new Vector();
                                break block74;
                            }
                            if (129 != n3) break block75;
                            break block76;
                        }
                        for (int i = 0; i < n7; ++i) {
                            if (unsignedInt8Array[i].shortValue() != 0) continue;
                            object = new String[]{(String)vector3.elementAt(i)};
                            try {
                                System.out.println("Starting RMC IO REMOVE operation");
                                int n8 = 0;
                                n8 = pIHSCRMCClient.rmcDLPAROp(((String[])object).length, unsignedInt164.intValue(), unsignedInt165.shortValue(), "slot", (String[])object, "r");
                                System.out.println("Finished RMC IO REMOVE operation - cmdTotal = " + n8);
                                System.out.println("Finished RMC IO REMOVE operation - running total = " + ++n5);
                                continue;
                            }
                            catch (HSCRMCException hSCRMCException) {
                                HSCLogUtils.serverLog(hSCRMCException, HSCLogUtils._PartActClassLogInfo);
                                System.out.println("RMC IO operation failed ");
                                hSCRMCException.printStackTrace();
                                String string6 = hSCRMCException.getMessage();
                                System.out.println(" =============== begin exception msg ===============");
                                System.out.println("exception msg = " + string6);
                                System.out.println(" =============== end exception msg ===============");
                                bl = true;
                                unsignedInt8Array[i] = new UnsignedInt8(7);
                            }
                        }
                        System.out.println("total successes for RMC = " + n5);
                        break block75;
                    }
                    for (n = 0; n < n7; ++n) {
                        if (unsignedInt8Array[n].shortValue() != 0) continue;
                        unsignedInt32 = (UnsignedInt32)((Vector)object2).elementAt(n);
                        try {
                            if (bl4) {
                                System.out.println(" IO MOVE: Vary Off FORCE the slot " + unsignedInt32);
                                omCecMgr.getCmdHelper().varyOnOffIo(unsignedInt162, unsignedInt164, unsignedInt32, VARY_OFF_FORCE, unsignedInt8);
                                continue;
                            }
                            System.out.println(" IO MOVE: Vary Off NORMAL the slot " + unsignedInt32);
                            omCecMgr.getCmdHelper().varyOnOffIo(unsignedInt162, unsignedInt164, unsignedInt32, VARY_OFF, unsignedInt8);
                            continue;
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                            System.out.println("caught excetpion trying to vary off slot " + throwable);
                            throwable.printStackTrace();
                            unsignedInt8Array[n] = new UnsignedInt8(7);
                        }
                    }
                }
                for (n = 0; n < n7; ++n) {
                    block70: {
                        unsignedInt32 = (UnsignedInt32)((Vector)object2).elementAt(n);
                        stringArray = new String[]{(String)vector3.elementAt(n)};
                        unsignedInt16 = (UnsignedInt16)vector4.elementAt(n);
                        if (unsignedInt8Array[n].shortValue() == 7) {
                            System.out.println("moveIo:  while setting ownership:  continuing beyond a known failure");
                            continue;
                        }
                        System.out.println("moveIo: trying to set slot ownership - calling method -  ");
                        System.out.println("moveIo: drcIndex = " + unsignedInt32);
                        System.out.println("moveIo: destLparID = " + unsignedInt163);
                        try {
                            omCecMgr.getCmdHelper().setIoSlotOwnerAndPoolId(unsignedInt32, unsignedInt163, unsignedInt16, IO_PRIORITY_DESIRED);
                            if (1 != n3 || bl4) break block70;
                            System.out.println("moveIo: updating io slot info --------------");
                            omCecActResourceUpdater.updateRemoveIoSlotOwnerAndPoolId(unsignedInt32);
                            System.out.println("moveIo: updated io slot info --------------");
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                            System.out.println("moveIo: caught an exception trying to call set slot ownership---- " + throwable);
                            throwable.printStackTrace();
                            unsignedInt8Array[n] = new UnsignedInt8(7);
                            try {
                                if (129 == n3) {
                                    omCecMgr.getCmdHelper().varyOnOffIo(unsignedInt162, unsignedInt164, unsignedInt32, VARY_ON, unsignedInt8);
                                    System.out.println("moveIo recovery: successfully varied back on a slot after ");
                                    System.out.println("moveIo recovery: a failed attempt to set ownership ");
                                    System.out.println("moveIo recovery: slot drcIndex = " + unsignedInt32);
                                    continue;
                                }
                                if (1 != n3 || bl4) continue;
                                n5 = pIHSCRMCClient.rmcDLPAROp(1, unsignedInt164.intValue(), unsignedInt165.shortValue(), "slot", stringArray, "a");
                                System.out.println("moveIo recovery: successfully varied back on a slot after ");
                                System.out.println("moveIo recovery: a failed attempt to set ownership ");
                                System.out.println("moveIo recovery: slot physical location code = " + stringArray[0]);
                                System.out.println("moveIo recovery: total = " + n5);
                            }
                            catch (Throwable throwable2) {
                                HSCLogUtils.serverLog(throwable2, HSCLogUtils._PartActClassLogInfo);
                                System.out.println("moveIo recovery: Unable vary back on the slot after failure to set ownership to destination lpar.");
                                System.out.println("moveIo recovery: We are offically OUT OF SYNC");
                                System.out.println("moveIo recovery: caught exception " + throwable2);
                                throwable2.printStackTrace();
                            }
                            continue;
                        }
                    }
                    if (129 == n4) {
                        try {
                            omCecMgr.getCmdHelper().varyOnOffIo(unsignedInt163, unsignedInt164, unsignedInt32, VARY_ON, unsignedInt8);
                        }
                        catch (Throwable throwable) {
                            block71: {
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                System.out.println("moveIo: caught exception trying to vary on slot OS400 " + throwable);
                                throwable.printStackTrace();
                                try {
                                    omCecMgr.getCmdHelper().setIoSlotOwnerAndPoolId(unsignedInt32, unsignedInt162, UNASSIGNED, IO_PRIORITY_DESIRED);
                                    if (129 == n3) {
                                        omCecMgr.getCmdHelper().varyOnOffIo(unsignedInt162, unsignedInt164, unsignedInt32, VARY_ON, unsignedInt8);
                                        System.out.println("moveIo recovery: successfully varied back on a slot after ");
                                        System.out.println("moveIo recovery: a failed attempt to set ownership ");
                                        System.out.println("moveIo recovery: slot drcIndex = " + unsignedInt32);
                                        break block71;
                                    }
                                    if (1 == n3 && !bl4) {
                                        n5 = pIHSCRMCClient.rmcDLPAROp(1, unsignedInt164.intValue(), unsignedInt165.shortValue(), "slot", stringArray, "a");
                                        System.out.println("moveIo recovery: successfully varied back on a slot after ");
                                        System.out.println("moveIo recovery: a failed attempt to set ownership ");
                                        System.out.println("moveIo recovery: slot physical location code = " + stringArray[0]);
                                        System.out.println("moveIo recovery: total = " + n5);
                                    }
                                }
                                catch (Throwable throwable3) {
                                    HSCLogUtils.serverLog(throwable3, HSCLogUtils._PartActClassLogInfo);
                                    System.out.println("moveIo: caught an exception trying to call set unassigned ----- " + throwable3);
                                    System.out.println("moveIo: Unable to set ownership back to original owner and vary on the slot.");
                                    System.out.println("moveIo: We are offically OUT OF SYNC");
                                    throwable3.printStackTrace();
                                }
                            }
                            unsignedInt8Array[n] = new UnsignedInt8(7);
                        }
                        continue;
                    }
                    if (1 != n4 || bl4) continue;
                    n5 = 0;
                    System.out.println("moveIo: PHYSICAL LOCATION CODE = " + stringArray[0]);
                    try {
                        System.out.println("moveIo: Starting RMC IO ADD operation");
                        n5 = pIHSCRMCClient2.rmcDLPAROp(1, unsignedInt164.intValue(), unsignedInt165.shortValue(), "slot", stringArray, "a");
                        System.out.println("moveIo: Finished RMC IO ADD operation - total = " + n5);
                    }
                    catch (HSCRMCException hSCRMCException) {
                        HSCLogUtils.serverLog(hSCRMCException, HSCLogUtils._PartActClassLogInfo);
                        System.out.println("moveIo: RMC IO operation failed ");
                        hSCRMCException.printStackTrace();
                        object = hSCRMCException.getMessage();
                        System.out.println("moveIo: exception msg = " + (String)object);
                        n5 = hSCRMCException.getNumberOfSuccesses();
                        System.out.println("moveIo: total successful = " + n5);
                    }
                    System.out.println("moveIo: total successes for RMC = " + n5);
                    if (n5 < 1) {
                        block72: {
                            unsignedInt8Array[n] = new UnsignedInt8(7);
                            try {
                                omCecMgr.getCmdHelper().setIoSlotOwnerAndPoolId(unsignedInt32, unsignedInt162, UNASSIGNED, IO_PRIORITY_DESIRED);
                                if (129 == n3) {
                                    omCecMgr.getCmdHelper().varyOnOffIo(unsignedInt162, unsignedInt164, unsignedInt32, VARY_ON, unsignedInt8);
                                    System.out.println("moveIo recovery: successfully varied back on a slot after ");
                                    System.out.println("moveIo recovery: a failed attempt to set ownership ");
                                    System.out.println("moveIo recovery: slot drcIndex = " + unsignedInt32);
                                    break block72;
                                }
                                if (1 == n3 && !bl4) {
                                    n5 = pIHSCRMCClient.rmcDLPAROp(1, unsignedInt164.intValue(), unsignedInt165.shortValue(), "slot", stringArray, "a");
                                    System.out.println("moveIo recovery: successfully varied back on a slot after ");
                                    System.out.println("moveIo recovery: a failed attempt to set ownership ");
                                    System.out.println("moveIo recovery: slot physical location code = " + stringArray[0]);
                                    System.out.println("moveIo recovery: total = " + n5);
                                }
                            }
                            catch (Throwable throwable) {
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                System.out.println("moveIo: Unable to set ownership back to original owner and vary on the slot.");
                                System.out.println("moveIo: We are offically OUT OF SYNC");
                                System.out.println("moveIo: caught exception " + throwable);
                                throwable.printStackTrace();
                            }
                        }
                        System.out.println("moveIo:  UNSUCCESSFULLY varied on the slot via RMC");
                        System.out.println("moveIo:  physical location code = " + stringArray[0]);
                        unsignedInt8Array[n] = new UnsignedInt8(7);
                        continue;
                    }
                    System.out.println(" successfully varied on the slot via RMC");
                    System.out.println(" physical location code = " + vector3.elementAt(n));
                }
                vector2.addElement(new CIMProperty(MOF_IO_RESULTS, new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
                cIMValue = PIDlparFunctions.goodResponse();
                Object var52_75 = null;
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                System.out.println("removeIo: unexpected exception");
                throwable.printStackTrace();
                if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
                throw new PIHscServerException("2930", null);
            }
            try {
                if (fspLockHelper != null) {
                    System.out.println("leaving moveIo: Releasing the FSP LOCK");
                    fspLockHelper.unlock();
                }
                Trace.trace("aplphscT", "<- PIDLPARUtils.moveIo method");
                return cIMValue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return cIMValue;
        }
        catch (Throwable throwable4) {
            Object var52_76 = null;
            try {}
            catch (Throwable throwable5) {
                throwable5.printStackTrace();
                throw throwable4;
            }
            if (fspLockHelper != null) {
                System.out.println("leaving moveIo: Releasing the FSP LOCK");
                fspLockHelper.unlock();
            }
            Trace.trace("aplphscT", "<- PIDLPARUtils.moveIo method");
            throw throwable4;
        }
    }

    public static CIMValue varyOnOffPHB(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException, CIMException {
        System.out.println("in<- PIDlparFunctions : varyOnOffPHB");
        CIMInstance cIMInstance = null;
        String string = "RMC PHB:  ";
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        int n = 0;
        String string4 = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
        int n2 = ((UnsignedInt16)((CIMProperty)vector.elementAt(1)).getValue().getValue()).intValue();
        short s = ((UnsignedInt16)((CIMProperty)vector.elementAt(2)).getValue().getValue()).shortValue();
        String string5 = (String)((CIMProperty)vector.elementAt(3)).getValue().getValue();
        int n3 = ((UnsignedInt16)((CIMProperty)vector.elementAt(4)).getValue().getValue()).intValue();
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(5);
        boolean bl2 = (Boolean)cIMProperty.getValue().getValue();
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
            string2 = (String)cIMInstance.getProperty(MOF_NAME).getValue().getValue();
            string3 = string2.substring(string2.indexOf(42) + 1);
            n = Integer.parseInt(string2.substring(0, string2.indexOf("*")));
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            System.out.println("ERROR: cannot find partition instance.");
            throwable.printStackTrace();
            throw new PIHscServerException("2950", null);
        }
        System.out.println("lparName = " + string2);
        System.out.println("cecName = " + string3);
        System.out.println("lparID = " + n);
        System.out.println("destLparID = " + n3);
        if (n != n3) {
            System.out.println("in varyOnOffPHB -- lparID = " + n);
            System.out.println("in varyOnOffPHB -- destLparID = " + n3);
            string2 = String.valueOf(n3) + "*" + string3;
            System.out.println("in varyOnOffPHB - Move - dest lpar = " + string2);
        }
        PIHSCRMCClientFactory pIHSCRMCClientFactory = null;
        PIHSCRMCClient pIHSCRMCClient = null;
        try {
            pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(string3);
            pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient(string2);
            System.out.println("mRMCClient = " + pIHSCRMCClient);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            System.out.println("varyOnOffPHB: Exception while trying to create RMC Client");
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("2950", null);
            }
            throw (PIHscServerException)throwable;
        }
        if (!bl2) {
            try {
                System.out.println("Starting RMC PHB " + string5 + " operation");
                pIHSCRMCClient.rmcDLPARPHBOp(string4, n2, s, string5);
                System.out.println("Finished RMC PHB " + string5 + " operation");
            }
            catch (HSCRMCException hSCRMCException) {
                HSCLogUtils.serverLog(hSCRMCException, HSCLogUtils._PartActClassLogInfo);
                System.out.println("RMC PHB operation failed ");
                string = string + hSCRMCException.getMessage();
                bl = true;
            }
        }
        vector2.addElement(new CIMProperty("IsError", new CIMValue((Object)new Boolean(bl))));
        vector2.addElement(new CIMProperty("InfoMsg", new CIMValue((Object)string)));
        System.out.println("in<- PIDlparFunctions : varyOnOffPHB");
        return PIDlparFunctions.goodResponse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CIMValue varyOnOffIo(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        CIMValue cIMValue;
        PIDlparFunctions.debug("in<- PIDlparFunctions : varyOnOffIo");
        FspLockHelper fspLockHelper = null;
        int n = 64;
        try {
            try {
                fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n);
                fspLockHelper.addAllSlotLock(omCecMgr.getObjectId());
                fspLockHelper.lock();
                UnsignedInt32 unsignedInt32 = null;
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMProperty.getValue().getValue();
                CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(1);
                UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMProperty2.getValue().getValue();
                CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(2);
                Vector vector3 = (Vector)cIMProperty3.getValue().getValue();
                CIMProperty cIMProperty4 = (CIMProperty)vector.elementAt(3);
                UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty4.getValue().getValue();
                CIMProperty cIMProperty5 = (CIMProperty)vector.elementAt(4);
                UnsignedInt8 unsignedInt82 = (UnsignedInt8)cIMProperty5.getValue().getValue();
                int n2 = vector3.size();
                UnsignedInt8[] unsignedInt8Array = new UnsignedInt8[n2];
                System.out.println("in varyOnOffIo: number of slots passed in = " + n2);
                for (int i = 0; i < n2; ++i) {
                    unsignedInt32 = (UnsignedInt32)vector3.elementAt(i);
                    try {
                        omCecMgr.getCmdHelper().varyOnOffIo(unsignedInt16, unsignedInt162, unsignedInt32, unsignedInt8, unsignedInt82);
                        unsignedInt8Array[i] = new UnsignedInt8(0);
                        continue;
                    }
                    catch (PIHscServerException pIHscServerException) {
                        unsignedInt8Array[i] = new UnsignedInt8(7);
                    }
                }
                vector2.addElement(new CIMProperty(MOF_IO_RESULTS, new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
                PIDlparFunctions.debug("out-> PIDlparFunctions : varyOnOffIo");
                cIMValue = PIDlparFunctions.goodResponse();
                Object var21_22 = null;
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                System.out.println("varyOnOffIo: unexpected exception");
                throwable.printStackTrace();
                if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
                throw new PIHscServerException("2930", null);
            }
        }
        catch (Throwable throwable2) {
            Object var21_23 = null;
            try {
                if (fspLockHelper != null) {
                    System.out.println("leaving moveIo: Releasing the FSP LOCK");
                    fspLockHelper.unlock();
                }
                Trace.trace("aplphscT", "<- PIDLPARUtils.moveIo method");
                throw throwable2;
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                throw throwable2;
            }
        }
        try {}
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return cIMValue;
        }
        if (fspLockHelper != null) {
            System.out.println("leaving moveIo: Releasing the FSP LOCK");
            fspLockHelper.unlock();
        }
        Trace.trace("aplphscT", "<- PIDLPARUtils.moveIo method");
        return cIMValue;
    }

    public static CIMValue getVirtualIoSlotInfo(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        PIDlparFunctions.debug("in<-PIDlparFunctions : getVirtualIoSlotInfo");
        String string = "currentMaxSlots";
        String string2 = "pendingMaxSlots";
        String string3 = "slotCount";
        String string4 = "virtualSlotNumber";
        String string5 = "configState";
        String string6 = "runtimeState";
        FspLparVioSlotStates fspLparVioSlotStates = null;
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMProperty.getValue().getValue();
        CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(1);
        UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMProperty2.getValue().getValue();
        CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(2);
        UnsignedInt16 unsignedInt163 = (UnsignedInt16)cIMProperty3.getValue().getValue();
        fspLparVioSlotStates = omCecMgr.getCmdHelper().getFspLparVioSlotStates(unsignedInt16, unsignedInt162, unsignedInt163);
        VioSlotState[] vioSlotStateArray = fspLparVioSlotStates.getVioSlotStates();
        vector2.setSize(6);
        vector2.setElementAt(new CIMProperty(string, new CIMValue((Object)fspLparVioSlotStates.getCurMaxVirtualIOSlots())), 0);
        vector2.setElementAt(new CIMProperty(string2, new CIMValue((Object)fspLparVioSlotStates.getPendMaxVirtualIOSlots())), 1);
        vector2.setElementAt(new CIMProperty(string3, new CIMValue((Object)new UnsignedInt16(vioSlotStateArray.length))), 2);
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        for (int i = 0; i < vioSlotStateArray.length; ++i) {
            Hashtable hashtable = (Hashtable)((Object)vioSlotStateArray[i]);
            vector3.add(i, hashtable.get(string4));
            vector4.add(i, hashtable.get(string5));
            vector5.add(i, hashtable.get(string6));
        }
        vector2.setElementAt(new CIMProperty(string4, new CIMValue(vector3, new CIMDataType(23))), 3);
        vector2.setElementAt(new CIMProperty(string5, new CIMValue(vector4, new CIMDataType(21))), 4);
        vector2.setElementAt(new CIMProperty(string6, new CIMValue(vector5, new CIMDataType(21))), 5);
        PIDlparFunctions.debug("->PIDlparFunctions : getVirtualIoSlotInfo");
        return PIDlparFunctions.goodResponse();
    }

    private static CIMValue goodResponse() {
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    private static CIMValue badResponse() {
        return new CIMValue((Object)new UnsignedInt8(1));
    }

    public static CIMValue addVirtualEthernet(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, OmCecMgr omCecMgr) throws PIHscServerException {
        CIMValue cIMValue;
        block50: {
            RObject rObject = null;
            RObject rObject2 = null;
            int n = 0;
            int n2 = 0;
            Vector vector3 = null;
            int n3 = 0;
            Vector<Object> vector4 = new Vector<Object>();
            Vector<String> vector5 = new Vector<String>();
            Vector<Object> vector6 = new Vector<Object>();
            Hashtable hashtable = null;
            PIHSCRMCClientFactory pIHSCRMCClientFactory = null;
            PIHSCRMCClient pIHSCRMCClient = null;
            FspLockHelper fspLockHelper = null;
            Trace.trace("aplphscT", "-> PIDlparFunctions.addVirtualEthernet");
            System.out.println("In addVirtualEthernet");
            PIVirtualEthernetMACAddressUtils pIVirtualEthernetMACAddressUtils = new PIVirtualEthernetMACAddressUtils(omCecMgr);
            int n4 = 64;
            try {
                Object object;
                Object object2;
                int n5;
                boolean bl;
                short s;
                UnsignedInt16 unsignedInt16;
                Vector vector7;
                Vector vector8;
                Vector vector9;
                Vector vector10;
                Vector vector11;
                Vector vector12;
                Vector vector13;
                if (GlobalConfig.callMethodsWithValues) {
                    vector13 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                    vector12 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                    vector11 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
                    vector10 = (Vector)((CIMValue)vector.elementAt(3)).getValue();
                    vector9 = (Vector)((CIMValue)vector.elementAt(4)).getValue();
                    vector8 = (Vector)((CIMValue)vector.elementAt(5)).getValue();
                    vector7 = (Vector)((CIMValue)vector.elementAt(6)).getValue();
                    unsignedInt16 = (UnsignedInt16)((CIMValue)vector.elementAt(7)).getValue();
                    s = ((UnsignedInt8)((CIMValue)vector.elementAt(8)).getValue()).shortValue();
                    bl = (Boolean)((CIMValue)vector.elementAt(9)).getValue();
                } else {
                    vector13 = (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                    vector12 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                    vector11 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                    vector10 = (Vector)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                    vector9 = (Vector)((CIMProperty)vector.elementAt(4)).getValue().getValue();
                    vector8 = (Vector)((CIMProperty)vector.elementAt(5)).getValue().getValue();
                    vector7 = (Vector)((CIMProperty)vector.elementAt(6)).getValue().getValue();
                    unsignedInt16 = (UnsignedInt16)((CIMProperty)vector.elementAt(7)).getValue().getValue();
                    s = ((UnsignedInt8)((CIMProperty)vector.elementAt(8)).getValue().getValue()).shortValue();
                    bl = (Boolean)((CIMProperty)vector.elementAt(9)).getValue().getValue();
                }
                FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
                String string = PIDlparFunctions.getNameFromKeys(cIMObjectPath);
                Trace.trace("aplphscF", "The partition name is :" + string);
                System.out.println("The partition name is :" + string);
                OmLparMgr omLparMgr = omCecMgr.getLparMgr(string);
                if (omLparMgr == null) {
                    System.out.println("The lpar manager not available in repository");
                    Trace.trace("aplphscT", "The lpar manager not available in repository");
                    Trace.trace("aplphscT", "<- PIDlparFunctions.addVirtualEthernet");
                    throw new PIHscServerException("2916", null);
                }
                rObject = omLparMgr.getObject();
                short s2 = ((UnsignedInt8)rObject.getProperty("DefinitionState")).shortValue();
                Trace.trace("aplphscF", "The Partition def state is :" + s2);
                System.out.println("The Partition def state is :" + s2);
                if (2 == s2 || 4 == s2) {
                    System.out.println("Its an AIX partition");
                    if (!bl) {
                        String string2 = string.substring(string.indexOf(42) + 1);
                        Trace.trace("aplphscF", "The cec name is :" + string2);
                        System.out.println("The cec name is :" + string2);
                        try {
                            pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(string2);
                            pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient(string);
                            Trace.trace("aplphscF", "The mRMCClient = " + pIHSCRMCClient);
                            System.out.println("mRMCClient = " + pIHSCRMCClient);
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                            System.out.println("Got Exception while trying to create RMC Client");
                            throw new PIHscServerException("2925", throwable);
                        }
                    }
                }
                rObject2 = omCecMgr.getObject();
                System.out.println("The R cec instance is : " + rObject2);
                n2 = ((UnsignedInt16)rObject2.getProperty(R50ComputerSystem.Index_MaxVLANIDsPerPort)).intValue();
                if (3 <= Trace.LEVEL) {
                    Trace.trace("aplphscD", "The max VLAN IDs :" + n2);
                }
                System.out.println("The max VLAN IDs :" + n2);
                n = ((UnsignedInt16)rObject.getProperty("CurMaxVirtualIOSlots")).intValue();
                if (3 <= Trace.LEVEL) {
                    Trace.trace("aplphscD", "The max virtual slots is :" + n);
                }
                System.out.println("The max virtual slots is :" + n);
                vector3 = PIDlparFunctions.getExistingVirtualSlotNums(rObject);
                Trace.trace("aplphscF", "The existing Virtual slots are :" + vector3);
                System.out.println("The existing Virtual slots are :" + vector3);
                int n6 = omLparMgr.getLparIndex();
                UnsignedInt16 unsignedInt162 = new UnsignedInt16(n6);
                int n7 = vector13.size();
                short[] sArray = new short[n7];
                UnsignedInt8 unsignedInt8 = new UnsignedInt8(0);
                fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n4);
                fspLockHelper.addCecLock(omCecMgr.getObjectId());
                fspLockHelper.lock();
                for (n5 = 0; n5 < n7; ++n5) {
                    int n8;
                    int n9;
                    int n10;
                    object2 = (UnsignedInt16)vector13.elementAt(n5);
                    if (vector3.contains(object2)) {
                        System.out.println("The slot already exists");
                        Trace.trace("aplphscF", "The slot already exists");
                        sArray[n5] = 13;
                        continue;
                    }
                    if (object2.intValue() < 2 || object2.intValue() >= n) {
                        System.out.println("The slot is not in the valid range");
                        Trace.trace("aplphscF", "The slot is not in the valid range");
                        sArray[n5] = 14;
                        continue;
                    }
                    object = (UnsignedInt16)vector11.elementAt(n5);
                    int n11 = object.intValue();
                    if (n11 < 1 || n11 > 4094) {
                        Trace.trace("aplphscF", "The Vlan id is not in the valid range");
                        System.out.println("The Vlan id is not in the valid range");
                        sArray[n5] = 15;
                        continue;
                    }
                    UnsignedInt8 unsignedInt82 = (UnsignedInt8)vector12.elementAt(n5);
                    short s3 = unsignedInt82.shortValue();
                    if (s3 != 1 && s3 != 0) {
                        sArray[n5] = 20;
                        continue;
                    }
                    int n12 = ((UnsignedInt16)vector10.elementAt(n5)).intValue();
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("aplphscD", "The number of additional vlan ids is :" + n12);
                    }
                    System.out.println("The number of additional vlan ids is :" + n12);
                    UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[n12];
                    int n13 = n3;
                    boolean bl2 = false;
                    for (n10 = 0; n10 < n12; ++n10) {
                        unsignedInt16Array[n10] = (UnsignedInt16)vector9.elementAt(n13);
                        n9 = unsignedInt16Array[n10].intValue();
                        if (n9 < 2 || n9 > 4094) {
                            bl2 = true;
                            sArray[n5] = 16;
                            break;
                        }
                        if (n9 == n11) {
                            bl2 = true;
                            sArray[n5] = 19;
                            break;
                        }
                        ++n13;
                    }
                    n3 += n12;
                    if (bl2) continue;
                    System.out.println("The additional vlan id is :" + unsignedInt16Array);
                    if (unsignedInt16Array != null && unsignedInt16Array.length != 0 && s3 == 0) {
                        sArray[n5] = 17;
                        continue;
                    }
                    if (unsignedInt16Array.length >= n2) {
                        sArray[n5] = 18;
                        continue;
                    }
                    bl2 = false;
                    block14: for (n10 = 0; n10 < n12; ++n10) {
                        n9 = unsignedInt16Array[n10].intValue();
                        for (n8 = n10 + 1; n8 < n12; ++n8) {
                            if (n9 != unsignedInt16Array[n8].intValue()) continue;
                            sArray[n5] = 19;
                            bl2 = true;
                            break block14;
                        }
                    }
                    if (bl2) continue;
                    UnsignedInt8 unsignedInt83 = (UnsignedInt8)vector7.elementAt(n5);
                    n8 = unsignedInt83.shortValue();
                    if (n8 != 1 && n8 != 2) {
                        sArray[n5] = 23;
                        continue;
                    }
                    UnsignedInt8 unsignedInt84 = (UnsignedInt8)vector8.elementAt(n5);
                    short s4 = unsignedInt84.shortValue();
                    if (s4 != 1 && s4 != 0) {
                        sArray[n5] = 36;
                        continue;
                    }
                    short[] sArray2 = new short[1];
                    UnsignedInt8 unsignedInt85 = new UnsignedInt8(0);
                    Vector vector14 = new Vector();
                    Vector<Object> vector15 = new Vector<Object>();
                    if (130 == s2) {
                        System.out.println("Its an os400 partition so get the drc index to vary off the slot");
                        try {
                            hashtable = null;
                            hashtable = fspCmdHelper.getVirtualIoDrcIndexAndName(unsignedInt162, (UnsignedInt16)object2);
                        }
                        catch (Throwable throwable) {
                            System.out.println("Got exception getting the DRC Index of the empty Virtual slot");
                            throwable.printStackTrace();
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                            sArray[n5] = 32;
                            continue;
                        }
                        System.out.println("Calling the varyOnOffSlots function");
                        System.out.println("The DRC Index is :" + hashtable.get(DRC_INDEX));
                        vector14.addElement(hashtable.get(DRC_INDEX));
                        vector15.addElement(object2);
                        PIDlparFunctions.varyOnOffSlots(vector14, unsignedInt162, fspCmdHelper, sArray2, unsignedInt16, unsignedInt8, unsignedInt85, vector15, false);
                        if (sArray2[0] != 11) {
                            sArray[n5] = sArray2[0];
                            continue;
                        }
                    }
                    FspVioEtherConfig fspVioEtherConfig = new FspVioEtherConfig();
                    fspVioEtherConfig.setIsIEEE(unsignedInt82);
                    fspVioEtherConfig.setPortVid((UnsignedInt16)object);
                    fspVioEtherConfig.setAdditionalVids(unsignedInt16Array);
                    fspVioEtherConfig.setPriority(unsignedInt83);
                    fspVioEtherConfig.setIsTrunk(unsignedInt84);
                    fspVioEtherConfig.setMACAddress(pIVirtualEthernetMACAddressUtils.getMACAddress(unsignedInt162, (UnsignedInt16)object2));
                    System.out.println("The Virtual Ethernet Config is :" + fspVioEtherConfig);
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("aplphscD", "The Virtual Ethernet Config is :" + fspVioEtherConfig);
                    }
                    try {
                        System.out.println("Setting the Virtual ethernet");
                        fspCmdHelper.setVirtualEthernetSlotConfiguration(unsignedInt162, (UnsignedInt16)object2, fspVioEtherConfig);
                        System.out.println(" Finished Setting the Virtual ethernet");
                    }
                    catch (Throwable throwable) {
                        System.out.println("Got exception seting the the Virtual ethernet slot");
                        throwable.printStackTrace();
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                        if (130 == s2) {
                            unsignedInt85 = new UnsignedInt8(1);
                            System.out.println("Calling the varyon slot since the set failed");
                            PIDlparFunctions.varyOnOffSlots(vector14, unsignedInt162, fspCmdHelper, sArray2, unsignedInt16, unsignedInt8, unsignedInt85, vector15, false);
                        }
                        sArray[n5] = 21;
                        continue;
                    }
                    if (130 != s2) {
                        FspVioEtherConfig fspVioEtherConfig2 = null;
                        try {
                            System.out.println("Getting the Virtual ethernet for DRCs");
                            fspVioEtherConfig2 = fspCmdHelper.getVirtualEthernetSlotConfiguration(unsignedInt162, (UnsignedInt16)object2);
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                            throwable.printStackTrace();
                            sArray[n5] = 32;
                            UnsignedInt16[] unsignedInt16Array2 = new UnsignedInt16[]{object2};
                            short[] sArray3 = new short[1];
                            PIDlparFunctions.revertTheSet(unsignedInt162, unsignedInt16Array2, sArray3, fspCmdHelper);
                            if (sArray3[0] != 28) continue;
                            sArray[n5] = 31;
                            continue;
                        }
                        vector5.addElement(fspVioEtherConfig2.getDrcName());
                        vector6.addElement(fspVioEtherConfig2.getDrcIndex());
                        System.out.println("The drcIndex is :" + fspVioEtherConfig2.getDrcIndex());
                        Trace.trace("aplphscF", "The drcIndex is :" + fspVioEtherConfig2.getDrcIndex());
                    } else {
                        System.out.println("The drcName is :" + hashtable.get(DRC_NAME));
                        Trace.trace("aplphscF", "The drcName is :" + hashtable.get(DRC_NAME));
                        vector5.addElement((String)hashtable.get(DRC_NAME));
                        vector6.addElement(hashtable.get(DRC_INDEX));
                    }
                    sArray[n5] = 11;
                    vector4.addElement(object2);
                    System.out.println("The slot number is :" + object2);
                }
                System.out.println("Finished the setting of the slots");
                if (vector4.size() > 0) {
                    System.out.println("The Partition def state is :" + s2);
                    if (130 == s2) {
                        System.out.println("Its an OS400 partition");
                        short[] sArray4 = new short[vector4.size()];
                        object2 = new UnsignedInt8(1);
                        System.out.println("Calling the varyOnOffSlots function");
                        PIDlparFunctions.varyOnOffSlots(vector6, unsignedInt162, fspCmdHelper, sArray4, unsignedInt16, unsignedInt8, (UnsignedInt8)object2, vector4, true);
                        System.out.println("updating the results array");
                        PIDlparFunctions.UpdateResultsArray(sArray, vector13, vector4, sArray4);
                    } else {
                        System.out.println("Its an AIX partition");
                        if (!bl) {
                            n5 = PIDlparFunctions.doRMCFlows(pIHSCRMCClient, vector5, unsignedInt16, s, "slot", "a");
                            Trace.trace("aplphscF", "The number of successes after the RMC call is:" + n5);
                            System.out.println("The number of successes after the RMC call is:" + n5);
                            System.out.println("The number of elements in the before RMC is:" + vector5.size());
                            if (n5 != vector5.size()) {
                                object2 = PIDlparFunctions.slotTrim(vector4, n5);
                                object = new short[((Vector)object2).size()];
                                System.out.println("Calling the revert function for the RMC failures");
                                PIDlparFunctions.revertTheSet(unsignedInt162, ((Vector)object2).toArray(new UnsignedInt16[((Vector)object2).size()]), (short[])object, fspCmdHelper);
                                PIDlparFunctions.setTheResultsArray((short[])object);
                                System.out.println("updating the results array");
                                PIDlparFunctions.UpdateResultsArray(sArray, vector13, (Vector)object2, (short[])object);
                            }
                        }
                    }
                }
                if (vector2.size() == 0) {
                    vector2.setSize(1);
                }
                if (GlobalConfig.callMethodsWithValues) {
                    vector2.setElementAt(new CIMValue((Object)sArray, new CIMDataType(21)), 0);
                } else {
                    vector2.setElementAt(new CIMProperty(VIRTUAL_IO_RESULTS, new CIMValue((Object)sArray, new CIMDataType(21))), 0);
                }
                System.out.println("The outParam Vector is :" + vector2);
                cIMValue = new CIMValue((Object)new UnsignedInt8(0));
                Object var64_70 = null;
                if (fspLockHelper == null) break block50;
                System.out.println("Releasing the FSP LOCK");
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    throwable.printStackTrace();
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("2925", throwable);
                }
                catch (Throwable throwable2) {
                    Object var64_71 = null;
                    if (fspLockHelper != null) {
                        System.out.println("Releasing the FSP LOCK");
                        fspLockHelper.unlock();
                    }
                    Trace.trace("aplphscT", "<- PIDLPARUtils.addVirtualEthernet method");
                    throw throwable2;
                }
            }
            fspLockHelper.unlock();
        }
        Trace.trace("aplphscT", "<- PIDLPARUtils.addVirtualEthernet method");
        return cIMValue;
    }

    private static void setTheResultsArray(short[] sArray) {
        Trace.trace("aplphscT", "-> PIDlparFunctions.setTheResultsArray");
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == 28) {
                sArray[i] = 34;
                continue;
            }
            if (sArray[i] != 11) continue;
            sArray[i] = 33;
        }
        Trace.trace("aplphscT", "<- PIDlparFunctions.setTheResultsArray");
    }

    private static Vector slotTrim(Vector vector, int n) {
        Trace.trace("aplphscT", "-> PIDlparFunctions.slotTrim");
        Vector vector2 = new Vector();
        for (int i = n; i < vector.size(); ++i) {
            vector2.addElement(vector.elementAt(i));
        }
        Trace.trace("aplphscT", "<- PIDlparFunctions.slotTrim");
        return vector2;
    }

    private static void slotTrimSuccess(Vector vector, int n, Vector vector2, short[] sArray, Vector vector3) {
        Trace.trace("aplphscT", "-> PIDlparFunctions.slotTrimSuccess");
        for (int i = n; i < vector.size(); ++i) {
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)vector.elementAt(i);
            int n2 = vector2.indexOf(unsignedInt16);
            sArray[n2] = 33;
            vector.remove(i);
            vector3.remove(i);
        }
        Trace.trace("aplphscT", "<- PIDlparFunctions.slotTrimSuccess");
    }

    public static CIMValue addVirtualSerialSCSI(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, OmCecMgr omCecMgr) throws PIHscServerException {
        CIMValue cIMValue;
        block59: {
            int n = 0;
            Vector vector3 = null;
            Vector<Object> vector4 = new Vector<Object>();
            Vector<String> vector5 = new Vector<String>();
            Vector<Object> vector6 = new Vector<Object>();
            Hashtable hashtable = null;
            PIHSCRMCClientFactory pIHSCRMCClientFactory = null;
            PIHSCRMCClient pIHSCRMCClient = null;
            FspLockHelper fspLockHelper = null;
            boolean bl = true;
            boolean bl2 = true;
            Trace.trace("aplphscT", "-> PIDLPARUtils.addVirtualSerialSCSI");
            System.out.println("In addVirtualSerialSCSI");
            int n2 = 64;
            try {
                Object object;
                Object object2;
                int n3;
                Object object3;
                boolean bl3;
                short s;
                UnsignedInt16 unsignedInt16;
                Vector vector7;
                Vector vector8;
                Vector vector9;
                Vector vector10;
                Vector vector11;
                Vector vector12;
                Vector vector13;
                if (GlobalConfig.callMethodsWithValues) {
                    vector13 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                    vector12 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                    vector11 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
                    vector10 = (Vector)((CIMValue)vector.elementAt(3)).getValue();
                    vector9 = (Vector)((CIMValue)vector.elementAt(4)).getValue();
                    vector8 = (Vector)((CIMValue)vector.elementAt(5)).getValue();
                    vector7 = (Vector)((CIMValue)vector.elementAt(6)).getValue();
                    unsignedInt16 = (UnsignedInt16)((CIMValue)vector.elementAt(7)).getValue();
                    s = ((UnsignedInt8)((CIMValue)vector.elementAt(8)).getValue()).shortValue();
                    bl3 = (Boolean)((CIMValue)vector.elementAt(9)).getValue();
                } else {
                    vector13 = (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                    vector12 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                    vector11 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                    vector10 = (Vector)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                    vector9 = (Vector)((CIMProperty)vector.elementAt(4)).getValue().getValue();
                    vector8 = (Vector)((CIMProperty)vector.elementAt(5)).getValue().getValue();
                    vector7 = (Vector)((CIMProperty)vector.elementAt(6)).getValue().getValue();
                    unsignedInt16 = (UnsignedInt16)((CIMProperty)vector.elementAt(7)).getValue().getValue();
                    s = ((UnsignedInt8)((CIMProperty)vector.elementAt(8)).getValue().getValue()).shortValue();
                    bl3 = (Boolean)((CIMProperty)vector.elementAt(9)).getValue().getValue();
                }
                FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
                String string = PIDlparFunctions.getNameFromKeys(cIMObjectPath);
                Trace.trace("aplphscF", "The partition name is :" + string);
                System.out.println("The partition name is :" + string);
                OmLparMgr omLparMgr = omCecMgr.getLparMgr(string);
                if (omLparMgr == null) {
                    Trace.trace("aplphscT", "The lpar manager not available in repository");
                    System.out.println("The lpar manager not available in repository");
                    Trace.trace("aplphscT", "<- PIDLPARUtils.addVirtualSerialSCSI");
                    throw new PIHscServerException("2916", null);
                }
                RObject rObject = omLparMgr.getObject();
                short s2 = ((UnsignedInt8)rObject.getProperty("DefinitionState")).shortValue();
                System.out.println("The Partition def state is :" + s2);
                if (2 == s2 || 4 == s2) {
                    System.out.println("Its an AIX partition");
                    if (!bl3) {
                        object3 = string.substring(string.indexOf(42) + 1);
                        Trace.trace("aplphscF", "The cec name is :" + (String)object3);
                        System.out.println("The cec name is :" + (String)object3);
                        try {
                            pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance((String)object3);
                            pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient(string);
                            Trace.trace("aplphscF", "The mRMCClient = " + pIHSCRMCClient);
                            System.out.println("mRMCClient = " + pIHSCRMCClient);
                        }
                        catch (Throwable throwable) {
                            System.out.println("Got Exception while trying to create RMC Client");
                            Trace.trace("aplphscT", "Got Exception while trying to create RMC Client");
                            Trace.trace("aplphscT", "<- PIDLPARUtils.addVirtualSerialSCSI");
                            throw new PIHscServerException("2925", throwable);
                        }
                    }
                    if (2 == s2) {
                        bl = false;
                    }
                } else if (130 == s2) {
                    object3 = omCecMgr.getObject();
                    long l = 0L;
                    try {
                        l = ((UnsignedInt32)((RObject)object3).getProperty("RuntimeCapability")).longValue();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if ((l & 0x2000000L) != 0L) {
                        bl = false;
                        bl2 = false;
                    }
                }
                n = ((UnsignedInt16)rObject.getProperty("CurMaxVirtualIOSlots")).intValue();
                Trace.trace("aplphscF", "The max virtual slots is :" + n);
                System.out.println("The max virtual slots is :" + n);
                vector3 = PIDlparFunctions.getExistingVirtualSlotNums(rObject);
                Trace.trace("aplphscF", "The existing Virtual slots are :" + vector3);
                System.out.println("The existing Virtual slots are :" + vector3);
                int n4 = omLparMgr.getLparIndex();
                Trace.trace("aplphscF", "The lpar id is :" + n4);
                System.out.println("The lpar id is :" + n4);
                UnsignedInt16 unsignedInt162 = new UnsignedInt16(n4);
                int n5 = vector13.size();
                short[] sArray = new short[n5];
                UnsignedInt8 unsignedInt8 = new UnsignedInt8(0);
                fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n2);
                fspLockHelper.addCecLock(omCecMgr.getObjectId());
                fspLockHelper.lock();
                for (n3 = 0; n3 < n5; ++n3) {
                    UnsignedInt8 unsignedInt82;
                    short s3;
                    object2 = (UnsignedInt16)vector13.elementAt(n3);
                    Trace.trace("aplphscF", "The slot  to add is :" + object2);
                    if (vector3.contains(object2)) {
                        Trace.trace("aplphscF", "The slot already exists ");
                        System.out.println("The slot already exists");
                        sArray[n3] = 13;
                        continue;
                    }
                    if (object2.intValue() < 2 || object2.intValue() >= n) {
                        Trace.trace("aplphscF", "The slot is not in the valid range");
                        System.out.println("The slot is not in the valid range");
                        sArray[n3] = 14;
                        continue;
                    }
                    object = (UnsignedInt8)vector12.elementAt(n3);
                    short s4 = object.shortValue();
                    if (s4 != 3 && s4 != 2) {
                        Trace.trace("aplphscF", "The device class is invalid");
                        System.out.println("The device class is invalid");
                        sArray[n3] = 29;
                        continue;
                    }
                    UnsignedInt8 unsignedInt83 = (UnsignedInt8)vector11.elementAt(n3);
                    short s5 = unsignedInt83.shortValue();
                    if (s5 != 0 && s5 != 1) {
                        Trace.trace("aplphscF", "The device attribute is invalid");
                        System.out.println("The device attr is invalid");
                        sArray[n3] = 22;
                        continue;
                    }
                    if (s5 == 1 && s4 == 3 && !bl) {
                        Trace.trace("aplphscF", "The partition cannot have SCSI server adapters");
                        System.out.println("The partition cannot have SCSI server adapters!");
                        sArray[n3] = 37;
                        continue;
                    }
                    if (s5 == 0 && s4 == 2 && !bl2) {
                        Trace.trace("aplphscF", "The partition cannot have serial client adapters");
                        System.out.println("The partition cannot have serial client adapters!");
                        sArray[n3] = 38;
                        continue;
                    }
                    UnsignedInt16 unsignedInt163 = (UnsignedInt16)vector9.elementAt(n3);
                    int n6 = unsignedInt163.intValue();
                    Trace.trace("aplphscF", "The server lpar is is :" + n6);
                    System.out.println("The server lpar is is :" + n6);
                    UnsignedInt16 unsignedInt164 = (UnsignedInt16)vector8.elementAt(n3);
                    int n7 = unsignedInt164.intValue();
                    Trace.trace("aplphscF", "The server slot id is :" + n7);
                    System.out.println("The server slot id is :" + n7);
                    if (s5 == 1) {
                        System.out.println("In server checks");
                        if (n6 != 65535) {
                            if (n6 < 1 || n6 > 254) {
                                Trace.trace("aplphscF", "Invalid server lpar id");
                                System.out.println("Invalid server lpar id");
                                sArray[n3] = 25;
                                continue;
                            }
                        } else if (n7 != 65535) {
                            Trace.trace("aplphscF", "Invalid virtual slot id");
                            System.out.println("Invalid virtual slot id");
                            sArray[n3] = 24;
                            continue;
                        }
                    }
                    if (s5 == 0) {
                        System.out.println("In client checks");
                        if (n6 == 65535) {
                            Trace.trace("aplphscF", "Invalid server lpar id");
                            System.out.println("Invalid server lpar id");
                            sArray[n3] = 25;
                            continue;
                        }
                        if (n7 == 65535) {
                            Trace.trace("aplphscF", "Invalid virtual slot id");
                            System.out.println("Invalid virtual slot id");
                            sArray[n3] = 24;
                            continue;
                        }
                        if (n7 < 0 || n7 > 65535) {
                            Trace.trace("aplphscF", "Invalid virtual slot id");
                            System.out.println("Invalid virtual slot id");
                            sArray[n3] = 24;
                            continue;
                        }
                    }
                    if ((s3 = (unsignedInt82 = (UnsignedInt8)vector10.elementAt(n3)).shortValue()) != 0) {
                        Trace.trace("aplphscF", "Invalid support HMC attribute");
                        System.out.println("Invalid support HMC attribute");
                        sArray[n3] = 26;
                        continue;
                    }
                    UnsignedInt8 unsignedInt84 = (UnsignedInt8)vector7.elementAt(n3);
                    short s6 = unsignedInt84.shortValue();
                    if (s6 != 1 && s6 != 2) {
                        Trace.trace("aplphscF", "Invalid required flag");
                        System.out.println("Invalid required flag");
                        sArray[n3] = 23;
                        continue;
                    }
                    short[] sArray2 = new short[1];
                    UnsignedInt8 unsignedInt85 = new UnsignedInt8(0);
                    Vector vector14 = new Vector();
                    Vector<Object> vector15 = new Vector<Object>();
                    if (130 == s2) {
                        System.out.println("Its an os400 partition so get the drc index to vary off the slot");
                        try {
                            hashtable = null;
                            hashtable = fspCmdHelper.getVirtualIoDrcIndexAndName(unsignedInt162, (UnsignedInt16)object2);
                        }
                        catch (Throwable throwable) {
                            System.out.println("Got exception getting the DRC Index of the empty Virtual slot");
                            throwable.printStackTrace();
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                            sArray[n3] = 32;
                            continue;
                        }
                        System.out.println("Calling the varyOnOffSlots function");
                        System.out.println("The DRC Index is :" + hashtable.get(DRC_INDEX));
                        vector14.addElement(hashtable.get(DRC_INDEX));
                        vector15.addElement(object2);
                        PIDlparFunctions.varyOnOffSlots(vector14, unsignedInt162, fspCmdHelper, sArray2, unsignedInt16, unsignedInt8, unsignedInt85, vector15, false);
                        if (sArray2[0] != 11) {
                            sArray[n3] = sArray2[0];
                            continue;
                        }
                    }
                    FspVioScsiConfig fspVioScsiConfig = new FspVioScsiConfig();
                    fspVioScsiConfig.setServerLparId(unsignedInt163);
                    fspVioScsiConfig.setServerVirtSlotNum(unsignedInt164);
                    fspVioScsiConfig.setVirtDeviceAttr(unsignedInt83);
                    fspVioScsiConfig.setSupportHmcClient(unsignedInt82);
                    fspVioScsiConfig.setPriorityFlag(unsignedInt84);
                    if (s4 == 3) {
                        System.out.println("Setting the device class to SCSI");
                        fspVioScsiConfig.setVirtDeviceClass(new UnsignedInt8(2));
                    } else if (s4 == 2) {
                        System.out.println("Setting the device class to Serial");
                        fspVioScsiConfig.setVirtDeviceClass(new UnsignedInt8(3));
                    }
                    System.out.println("The Virtual SCSI Config class is :" + fspVioScsiConfig);
                    try {
                        System.out.println("Sending the setVirtualScsiSerialConfig cmd");
                        fspCmdHelper.setVirtualScsiSerialConfig(unsignedInt162, (UnsignedInt16)object2, fspVioScsiConfig);
                        System.out.println("Finished the setVirtualScsiSerialConfig cmd");
                    }
                    catch (Throwable throwable) {
                        System.out.println("Got exception seting the the Virtual serial/scsi slot");
                        throwable.printStackTrace();
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                        if (130 == s2) {
                            unsignedInt85 = new UnsignedInt8(1);
                            System.out.println("Calling the varyon slot since the set failed");
                            PIDlparFunctions.varyOnOffSlots(vector14, unsignedInt162, fspCmdHelper, sArray2, unsignedInt16, unsignedInt8, unsignedInt85, vector15, false);
                        }
                        sArray[n3] = 21;
                        continue;
                    }
                    if (130 != s2) {
                        FspVioScsiConfig fspVioScsiConfig2 = null;
                        try {
                            System.out.println("Issuing the getVirtualScsiSerialConfig");
                            fspVioScsiConfig2 = fspCmdHelper.getVirtualScsiSerialConfig(unsignedInt162, (UnsignedInt16)object2);
                            System.out.println("Done the getVirtualScsiSerialConfig");
                        }
                        catch (Throwable throwable) {
                            System.out.println("Got exception getting the the Virtual serial/scsi slot");
                            throwable.printStackTrace();
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                            sArray[n3] = 32;
                            UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[]{object2};
                            short[] sArray3 = new short[1];
                            PIDlparFunctions.revertTheSet(unsignedInt162, unsignedInt16Array, sArray3, fspCmdHelper);
                            if (sArray3[0] != 28) continue;
                            sArray[n3] = 31;
                            continue;
                        }
                        System.out.println("Adding the drcName/drcIndex Info to the Vectors");
                        vector5.addElement(fspVioScsiConfig2.getDrcName());
                        Trace.trace("aplphscF", "The drcName is :" + fspVioScsiConfig2.getDrcName());
                        System.out.println("The drcName is :" + fspVioScsiConfig2.getDrcName());
                        vector6.addElement(fspVioScsiConfig2.getDrcIndex());
                        Trace.trace("aplphscF", "The drcIndex is :" + fspVioScsiConfig2.getDrcIndex());
                        System.out.println("The drcIndex is :" + fspVioScsiConfig2.getDrcIndex());
                    } else {
                        System.out.println("Adding the drcName/drcIndex Info to the Vectors");
                        vector5.addElement((String)hashtable.get(DRC_NAME));
                        vector6.addElement(hashtable.get(DRC_INDEX));
                        Trace.trace("aplphscF", "The drcName is :" + hashtable.get(DRC_NAME));
                        Trace.trace("aplphscF", "The drcIndex is :" + hashtable.get(DRC_INDEX));
                    }
                    sArray[n3] = 11;
                    vector4.addElement(object2);
                    System.out.println("The slot number is :" + object2);
                }
                System.out.println("Finished the setting of the slots");
                if (vector4.size() > 0) {
                    System.out.println("The Partition def state is :" + s2);
                    if (130 == s2) {
                        System.out.println("Its an OS400 partition");
                        short[] sArray4 = new short[vector4.size()];
                        object2 = new UnsignedInt8(1);
                        System.out.println("Calling the varyOnOffSlots function");
                        PIDlparFunctions.varyOnOffSlots(vector6, unsignedInt162, fspCmdHelper, sArray4, unsignedInt16, unsignedInt8, (UnsignedInt8)object2, vector4, true);
                        System.out.println("updating the results array");
                        PIDlparFunctions.UpdateResultsArray(sArray, vector13, vector4, sArray4);
                    } else {
                        System.out.println("Its an AIX partition");
                        if (!bl3) {
                            n3 = PIDlparFunctions.doRMCFlows(pIHSCRMCClient, vector5, unsignedInt16, s, "slot", "a");
                            Trace.trace("aplphscF", "The number of successes after the RMC call is:" + n3);
                            System.out.println("The number of successes after the RMC call is:" + n3);
                            System.out.println("The number of elements in the before RMC is:" + vector5.size());
                            if (n3 != vector5.size()) {
                                object2 = PIDlparFunctions.slotTrim(vector4, n3);
                                object = new short[((Vector)object2).size()];
                                System.out.println("Calling the revert function for the RMC failures");
                                PIDlparFunctions.revertTheSet(unsignedInt162, ((Vector)object2).toArray(new UnsignedInt16[((Vector)object2).size()]), (short[])object, fspCmdHelper);
                                PIDlparFunctions.setTheResultsArray((short[])object);
                                System.out.println("updating the results array");
                                PIDlparFunctions.UpdateResultsArray(sArray, vector13, (Vector)object2, (short[])object);
                            }
                        }
                    }
                }
                if (vector2.size() == 0) {
                    vector2.setSize(1);
                }
                if (GlobalConfig.callMethodsWithValues) {
                    vector2.setElementAt(new CIMValue((Object)sArray, new CIMDataType(21)), 0);
                } else {
                    vector2.setElementAt(new CIMProperty(VIRTUAL_IO_RESULTS, new CIMValue((Object)sArray, new CIMDataType(21))), 0);
                }
                System.out.println("The outParam Vector is :" + vector2);
                Trace.trace("aplphscT", "<- PIDLPARUtils.addVirtualSerial");
                cIMValue = new CIMValue((Object)new UnsignedInt8(0));
                Object var61_68 = null;
                if (fspLockHelper == null) break block59;
                System.out.println("Releasing the FSP LOCK");
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    throwable.printStackTrace();
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("2925", throwable);
                }
                catch (Throwable throwable2) {
                    Object var61_69 = null;
                    if (fspLockHelper != null) {
                        System.out.println("Releasing the FSP LOCK");
                        fspLockHelper.unlock();
                    }
                    Trace.trace("aplphscT", "<- PIDLPARUtils.addVirtualSerial");
                    throw throwable2;
                }
            }
            fspLockHelper.unlock();
        }
        Trace.trace("aplphscT", "<- PIDLPARUtils.addVirtualSerial");
        return cIMValue;
    }

    public static Vector getExistingVirtualSlotNums(RObject rObject) throws RException {
        Object object;
        UnsignedInt16 unsignedInt16;
        String string;
        Object object2;
        Object object3;
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        Trace.trace("aplphscT", "-> PIDlparFunctions.getExistingVirtualSlotNums");
        System.out.println("In getExistingVirtualSlotNums");
        Vector vector2 = rObject.associators(R50Define.AID_IBMHSC_LparVirtualSCSI);
        if (vector2 != null) {
            object3 = vector2.elements();
            while (object3.hasMoreElements()) {
                object2 = (RObject)object3.nextElement();
                string = (String)((RObject)object2).getProperty(MOF_NAME);
                unsignedInt16 = new UnsignedInt16(string);
                Trace.trace("aplphscF", "The virtual scsi slot number is :" + unsignedInt16);
                System.out.println("The virtual scsi slot number is :" + unsignedInt16);
                vector.addElement(unsignedInt16);
            }
        }
        if ((object3 = rObject.associators(R50Define.AID_IBMHSC_LparVirtualSerial)) != null) {
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (RObject)object2.nextElement();
                string = (String)((RObject)object).getProperty(MOF_NAME);
                unsignedInt16 = new UnsignedInt16(string);
                Trace.trace("aplphscF", "The virtual serial slot number is :" + unsignedInt16);
                System.out.println("The virtual serial slot number is :" + unsignedInt16);
                vector.addElement(unsignedInt16);
            }
        }
        if ((object2 = rObject.associators(R50Define.AID_IBMHSC_LparVirtualEthernet)) != null) {
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                RObject rObject2 = (RObject)object.nextElement();
                string = (String)rObject2.getProperty(MOF_NAME);
                unsignedInt16 = new UnsignedInt16(string);
                Trace.trace("aplphscF", "The virtual ethernet slot number is :" + unsignedInt16);
                System.out.println("The virtual ethernet slot number is :" + unsignedInt16);
                vector.addElement(unsignedInt16);
            }
        }
        Trace.trace("aplphscT", "<- PIDlparFunctions.getExistingVirtualSlotNums");
        return vector;
    }

    public static CIMValue removeVirtualSlots(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, OmCecMgr omCecMgr) throws PIHscServerException {
        CIMValue cIMValue;
        block29: {
            Hashtable hashtable;
            short[] sArray;
            UnsignedInt16 unsignedInt16;
            int n;
            RObject rObject;
            String string;
            FspCmdHelper fspCmdHelper;
            boolean bl;
            short s;
            UnsignedInt16 unsignedInt162;
            Vector vector3;
            int n2;
            FspLockHelper fspLockHelper;
            PIHSCRMCClient pIHSCRMCClient;
            PIHSCRMCClientFactory pIHSCRMCClientFactory;
            block27: {
                CIMValue cIMValue2;
                block28: {
                    Object var9_4 = null;
                    pIHSCRMCClientFactory = null;
                    pIHSCRMCClient = null;
                    fspLockHelper = null;
                    Trace.trace("aplphscT", "-> PIDLPARUtils.removeVirtualSlot");
                    System.out.println("In removeVirtualSlots");
                    n2 = 64;
                    if (GlobalConfig.callMethodsWithValues) {
                        vector3 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                        unsignedInt162 = (UnsignedInt16)((CIMValue)vector.elementAt(1)).getValue();
                        s = ((UnsignedInt8)((CIMValue)vector.elementAt(2)).getValue()).shortValue();
                        bl = (Boolean)((CIMValue)vector.elementAt(3)).getValue();
                    } else {
                        vector3 = (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                        unsignedInt162 = (UnsignedInt16)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                        s = ((UnsignedInt8)((CIMProperty)vector.elementAt(2)).getValue().getValue()).shortValue();
                        bl = (Boolean)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                    }
                    fspCmdHelper = omCecMgr.getCmdHelper();
                    string = PIDlparFunctions.getNameFromKeys(cIMObjectPath);
                    Trace.trace("aplphscF", "The partition name is :" + string);
                    System.out.println("The partition name is :" + string);
                    OmLparMgr omLparMgr = omCecMgr.getLparMgr(string);
                    if (omLparMgr == null) {
                        System.out.println("The lpar manager not available in repository");
                        Trace.trace("aplphscT", "The lpar manager not available in repository");
                        Trace.trace("aplphscT", "<- PIDLPARUtils.removeVirtualSlot");
                        throw new PIHscServerException("2916", null);
                    }
                    rObject = omLparMgr.getObject();
                    n = omLparMgr.getLparIndex();
                    unsignedInt16 = new UnsignedInt16(n);
                    int n3 = vector3.size();
                    sArray = new short[n3];
                    hashtable = PIDlparFunctions.slotInfoToRemove(rObject, vector3, sArray);
                    System.out.println("The Hashtable after the slotinfoToRemove :" + hashtable);
                    if (!hashtable.isEmpty()) break block27;
                    System.out.println("No valid slots available to remove");
                    PIDlparFunctions.updateParam(sArray, vector2);
                    cIMValue2 = new CIMValue((Object)new UnsignedInt8(0));
                    Object var33_25 = null;
                    if (fspLockHelper == null) break block28;
                    System.out.println("Releasing the FSP LOCK");
                    fspLockHelper.unlock();
                }
                Trace.trace("apcshscT", "<- removeVirtualSlot PIDLPARUtils. method");
                return cIMValue2;
            }
            try {
                UnsignedInt16 unsignedInt163;
                int n4;
                Object object;
                Vector vector4 = (Vector)hashtable.get(SLOT_ID);
                Vector vector5 = (Vector)hashtable.get(DRC_INDEX);
                Vector vector6 = (Vector)hashtable.get(DRC_NAME);
                fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n2);
                fspLockHelper.addCecLock(omCecMgr.getObjectId());
                fspLockHelper.lock();
                short s2 = ((UnsignedInt8)rObject.getProperty("DefinitionState")).shortValue();
                System.out.println("The Partition def state is :" + s2);
                if (2 == s2 || 4 == s2) {
                    System.out.println("Its an AIX partition");
                    if (!bl) {
                        object = string.substring(string.indexOf(42) + 1);
                        System.out.println("The cec name is :" + (String)object);
                        try {
                            pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance((String)object);
                            pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient(string);
                            System.out.println("mRMCClient = " + pIHSCRMCClient);
                        }
                        catch (Throwable throwable) {
                            System.out.println("Got Exception while trying to create RMC Client");
                        }
                        int n5 = PIDlparFunctions.doRMCFlows(pIHSCRMCClient, vector6, unsignedInt162, s, "slot", "r");
                        System.out.println("The number of successes after the RMC call is:" + n5);
                        System.out.println("The number of elements in the before RMC is:" + vector6.size());
                        if (n5 != vector6.size()) {
                            PIDlparFunctions.slotTrimSuccess(vector4, n5, vector3, sArray, vector6);
                        }
                    }
                } else {
                    System.out.println("Its an OS400 partition");
                    object = new short[vector4.size()];
                    UnsignedInt8 unsignedInt8 = new UnsignedInt8(0);
                    if (bl) {
                        System.out.println("Calling the varyOnOffSlots function with force vary off");
                        System.out.println("The drc Index vector is :" + vector5);
                        PIDlparFunctions.varyOnOffSlots(vector5, unsignedInt16, fspCmdHelper, object, unsignedInt162, unsignedInt8, VARY_OFF_FORCE, vector4, false);
                    } else {
                        System.out.println("Calling the varyOnOffSlots function with vary off");
                        System.out.println("The drc Index vector is :" + vector5);
                        PIDlparFunctions.varyOnOffSlots(vector5, unsignedInt16, fspCmdHelper, object, unsignedInt162, unsignedInt8, VARY_OFF, vector4, false);
                    }
                    System.out.println("updating the results array");
                    PIDlparFunctions.UpdateResultsArray(sArray, vector3, vector4, object);
                    PIDlparFunctions.slotTrimSuccess(vector4, object, vector5);
                }
                int n6 = vector4.size();
                short[] sArray2 = new short[n6];
                boolean bl2 = false;
                for (n4 = 0; n4 < n6; ++n4) {
                    unsignedInt163 = (UnsignedInt16)vector4.elementAt(n4);
                    try {
                        fspCmdHelper.clearVirtualIoSlotConfiguration(new UnsignedInt16(n), unsignedInt163);
                        sArray2[n4] = 11;
                        continue;
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                        sArray2[n4] = 28;
                        if (bl2) continue;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    System.out.println("updating the results array after the clear");
                    PIDlparFunctions.UpdateResultsArray(sArray, vector3, vector4, sArray2);
                    if (2 == s2 || 4 == s2) {
                        System.out.println("In remove Virtual RMC roll back");
                        PIDlparFunctions.slotTrimFailed(vector4, sArray2, vector6);
                        n4 = PIDlparFunctions.doRMCFlows(pIHSCRMCClient, vector6, unsignedInt162, s, "slot", "a");
                        System.out.println("The number of successes after the RMC call is:" + n4);
                        System.out.println("The number of elements in the before RMC is:" + vector6.size());
                    } else {
                        System.out.println("In remove Virtual Vary On roll back");
                        short[] sArray3 = new short[vector4.size()];
                        unsignedInt163 = new UnsignedInt8(0);
                        UnsignedInt8 unsignedInt8 = new UnsignedInt8(1);
                        PIDlparFunctions.varyOnOffSlots(vector5, unsignedInt16, fspCmdHelper, sArray3, unsignedInt162, (UnsignedInt8)unsignedInt163, unsignedInt8, vector4, false);
                    }
                }
                if (vector2.size() == 0) {
                    vector2.setSize(1);
                }
                if (GlobalConfig.callMethodsWithValues) {
                    vector2.setElementAt(new CIMValue((Object)sArray, new CIMDataType(21)), 0);
                } else {
                    vector2.setElementAt(new CIMProperty(VIRTUAL_IO_RESULTS, new CIMValue((Object)sArray, new CIMDataType(21))), 0);
                }
                cIMValue = new CIMValue((Object)new UnsignedInt8(0));
                Object var33_26 = null;
                if (fspLockHelper == null) break block29;
                System.out.println("Releasing the FSP LOCK");
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    throwable.printStackTrace();
                    if (throwable instanceof PIHscServerException) {
                        throw (PIHscServerException)throwable;
                    }
                    throw new PIHscServerException("2926", throwable);
                }
                catch (Throwable throwable2) {
                    Object var33_27 = null;
                    if (fspLockHelper != null) {
                        System.out.println("Releasing the FSP LOCK");
                        fspLockHelper.unlock();
                    }
                    Trace.trace("apcshscT", "<- removeVirtualSlot PIDLPARUtils. method");
                    throw throwable2;
                }
            }
            fspLockHelper.unlock();
        }
        Trace.trace("apcshscT", "<- removeVirtualSlot PIDLPARUtils. method");
        return cIMValue;
    }

    protected static void slotTrimFailed(Vector vector, short[] sArray, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            if (sArray[i] != 11) continue;
            vector.remove(i);
            vector2.remove(i);
        }
    }

    protected static void slotTrimSuccess(Vector vector, short[] sArray, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            if (sArray[i] == 11) continue;
            vector.remove(i);
            vector2.remove(i);
        }
    }

    protected static void updateParam(short[] sArray, Vector vector) {
        if (vector.size() == 0) {
            vector.setSize(1);
        }
        if (GlobalConfig.callMethodsWithValues) {
            vector.setElementAt(new CIMValue((Object)sArray, new CIMDataType(21)), 0);
        } else {
            vector.setElementAt(new CIMProperty(VIRTUAL_IO_RESULTS, new CIMValue((Object)sArray, new CIMDataType(21))), 0);
        }
    }

    public static Hashtable slotInfoToRemove(RObject rObject, Vector vector, short[] sArray) throws PIHscServerException, RException {
        int n;
        Object object;
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        Vector<UnsignedInt16> vector6 = new Vector<UnsignedInt16>();
        Vector vector7 = new Vector();
        Vector vector8 = new Vector();
        Hashtable hashtable = null;
        Hashtable hashtable2 = new Hashtable();
        RObject rObject2 = null;
        System.out.println("In slotInfoToRemove");
        Vector vector9 = rObject.associators(R50Define.AID_IBMHSC_ActivatedLparProfile);
        if (vector9 != null) {
            object = vector9.elements();
            while (object.hasMoreElements()) {
                rObject2 = (RObject)object.nextElement();
            }
        }
        if (rObject2 == null) {
            System.out.println("Not able to get the ACTIVATION PROFILE");
            throw new PIHscServerException("2926", null);
        }
        object = (Vector)rObject2.getProperty("VirSerialAdapters");
        Vector vector10 = (Vector)rObject2.getProperty("VirSerialSlotReqDesAttribute");
        Vector vector11 = (Vector)rObject2.getProperty("VirSCSIAdapters");
        Vector vector12 = (Vector)rObject2.getProperty("VirSCSISlotReqDesAttribute");
        Vector vector13 = (Vector)rObject2.getProperty("VirtualLanSlotIDs");
        Vector vector14 = (Vector)rObject2.getProperty("VLANSlotReqDesAttribute");
        try {
            hashtable = PIDlparFunctions.getExistingVirtualSlotInfo(rObject);
            System.out.println("The hashtable after the getExistingVirtualInfo : " + hashtable);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("2926", throwable);
        }
        vector2 = (Vector)hashtable.get(SLOT_ID);
        vector3 = (Vector)hashtable.get(DRC_INDEX);
        vector4 = (Vector)hashtable.get(DRC_NAME);
        vector5 = (Vector)hashtable.get(VIRT_CLASS);
        System.out.println("The size of the slot number vector after getExistingVirtualSlotInfo :" + vector2.size());
        for (n = 0; n < vector.size(); ++n) {
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)vector.elementAt(n);
            System.out.println("The system slot id is :" + unsignedInt16);
            if (unsignedInt16.intValue() < 2) {
                sArray[n] = 2;
                continue;
            }
            if (vector2.contains(unsignedInt16)) {
                System.out.println("The slot exists");
                int n2 = vector2.indexOf(unsignedInt16);
                short s = (Short)vector5.elementAt(n2);
                System.out.println("The class Type is :" + s);
                boolean bl = false;
                if (s == 3) {
                    if (vector11 != null && (bl = PIDlparFunctions.checkForRequired(unsignedInt16, vector11, vector12))) {
                        sArray[n] = 2;
                        continue;
                    }
                } else if (s == 2) {
                    if (object != null && (bl = PIDlparFunctions.checkForRequired(unsignedInt16, (Vector)object, vector10))) {
                        sArray[n] = 2;
                        continue;
                    }
                } else if (s == 1 && vector13 != null && (bl = PIDlparFunctions.checkForRequired(unsignedInt16, vector13, vector14))) {
                    sArray[n] = 2;
                    continue;
                }
                vector6.addElement(unsignedInt16);
                vector7.addElement(vector3.elementAt(n2));
                vector8.addElement(vector4.elementAt(n2));
                sArray[n] = 11;
                continue;
            }
            System.out.println("The does not slot exists");
            sArray[n] = 27;
        }
        n = vector6.size();
        System.out.println("The size of the rslotNum is :" + n);
        if (n == 0) {
            return hashtable2;
        }
        hashtable2.put(SLOT_ID, vector6);
        hashtable2.put(DRC_INDEX, vector7);
        hashtable2.put(DRC_NAME, vector8);
        return hashtable2;
    }

    public static boolean checkForRequired(UnsignedInt16 unsignedInt16, Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            System.out.println("The slot ID is :" + unsignedInt16);
            UnsignedInt16 unsignedInt162 = (UnsignedInt16)vector.elementAt(i);
            String string = (String)vector2.elementAt(i);
            System.out.println("The profile slot id is :" + unsignedInt162);
            System.out.println("The profile slot RD is :" + string);
            if (!unsignedInt16.toString().equals(unsignedInt162.toString()) || !string.equals("R")) continue;
            System.out.println("Its a required slot");
            return true;
        }
        return false;
    }

    public static Hashtable getExistingVirtualSlotInfo(RObject rObject) throws RException, PIHscServerException {
        Object object;
        UnsignedInt32 unsignedInt32;
        String string;
        UnsignedInt16 unsignedInt16;
        String string2;
        Object object2;
        Object object3;
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        Vector<UnsignedInt32> vector2 = new Vector<UnsignedInt32>();
        Vector<String> vector3 = new Vector<String>();
        Vector<Short> vector4 = new Vector<Short>();
        Hashtable<String, Vector<Object>> hashtable = new Hashtable<String, Vector<Object>>();
        System.out.println("In getExistingVirtualSlotNums");
        Vector vector5 = rObject.associators(R50Define.AID_IBMHSC_LparVirtualSCSI);
        System.out.println("vscsiObjVec = " + vector5);
        if (vector5 != null) {
            object3 = vector5.elements();
            while (object3.hasMoreElements()) {
                object2 = (RObject)object3.nextElement();
                string2 = (String)((RObject)object2).getProperty(MOF_NAME);
                unsignedInt16 = new UnsignedInt16(string2);
                System.out.println("The virtual scsi slot number is :" + unsignedInt16);
                string = (String)((RObject)object2).getProperty("DrcName");
                unsignedInt32 = (UnsignedInt32)((RObject)object2).getProperty("DrcIndex");
                System.out.println("The drc Name is :" + string);
                System.out.println("The drc Index is :" + unsignedInt32);
                vector.addElement(unsignedInt16);
                vector2.addElement(unsignedInt32);
                vector3.addElement(string);
                vector4.addElement(new Short(3));
            }
        }
        if ((object3 = rObject.associators(R50Define.AID_IBMHSC_LparVirtualSerial)) != null) {
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (RObject)object2.nextElement();
                string2 = (String)((RObject)object).getProperty(MOF_NAME);
                unsignedInt16 = new UnsignedInt16(string2);
                string = (String)((RObject)object).getProperty("DrcName");
                unsignedInt32 = (UnsignedInt32)((RObject)object).getProperty("DrcIndex");
                System.out.println("The drc Name is :" + string);
                System.out.println("The drc Index is :" + unsignedInt32);
                System.out.println("The virtual serial slot number is :" + unsignedInt16);
                vector.addElement(unsignedInt16);
                vector2.addElement(unsignedInt32);
                vector3.addElement(string);
                vector4.addElement(new Short(2));
            }
        }
        if ((object2 = rObject.associators(R50Define.AID_IBMHSC_LparVirtualEthernet)) != null) {
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                RObject rObject2 = (RObject)object.nextElement();
                string2 = (String)rObject2.getProperty(MOF_NAME);
                unsignedInt16 = new UnsignedInt16(string2);
                System.out.println("The virtual ethernet slot number is :" + unsignedInt16);
                string = (String)rObject2.getProperty("DrcName");
                unsignedInt32 = (UnsignedInt32)rObject2.getProperty("DrcIndex");
                System.out.println("The drc Name is :" + string);
                System.out.println("The drc Index is :" + unsignedInt32);
                System.out.println("The virtual serial slot number is :" + unsignedInt16);
                vector.addElement(unsignedInt16);
                vector2.addElement(unsignedInt32);
                vector3.addElement(string);
                vector4.addElement(new Short(1));
            }
        }
        hashtable.put(SLOT_ID, vector);
        hashtable.put(DRC_NAME, vector3);
        hashtable.put(DRC_INDEX, vector2);
        hashtable.put(VIRT_CLASS, vector4);
        return hashtable;
    }

    public static void revertTheSet(UnsignedInt16 unsignedInt16, UnsignedInt16[] unsignedInt16Array, short[] sArray, FspCmdHelper fspCmdHelper) throws PIHscServerException {
        if (3 <= Trace.LEVEL) {
            Trace.trace("aplphscD", "-> PIDLPARFunction. revertTheSet method");
        }
        System.out.println("In revertTheSet");
        for (int i = 0; i < unsignedInt16Array.length; ++i) {
            try {
                fspCmdHelper.clearVirtualIoSlotConfiguration(unsignedInt16, unsignedInt16Array[i]);
                sArray[i] = 11;
                continue;
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                sArray[i] = 28;
            }
        }
        if (3 <= Trace.LEVEL) {
            Trace.trace("aplphscD", "<- PIDLPARFunction. revertTheSet method");
        }
    }

    public static void varyOnOffSlots(Vector vector, UnsignedInt16 unsignedInt16, FspCmdHelper fspCmdHelper, short[] sArray, UnsignedInt16 unsignedInt162, UnsignedInt8 unsignedInt8, UnsignedInt8 unsignedInt82, Vector vector2, boolean bl) throws PIHscServerException {
        if (3 <= Trace.LEVEL) {
            Trace.trace("aplphscD", "-> PIDLPARFunction.varyOnOffSlots method");
        }
        UnsignedInt32 unsignedInt32 = null;
        System.out.println("In varyOnSlots");
        for (int i = 0; i < vector.size(); ++i) {
            unsignedInt32 = (UnsignedInt32)vector.elementAt(i);
            System.out.println("The drcindex is :" + unsignedInt32);
            try {
                fspCmdHelper.varyOnOffIo(unsignedInt16, unsignedInt162, unsignedInt32, unsignedInt82, unsignedInt8);
                sArray[i] = 11;
                continue;
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                if (bl) {
                    UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[]{(UnsignedInt16)vector2.elementAt(i)};
                    short[] sArray2 = new short[1];
                    PIDlparFunctions.revertTheSet(unsignedInt16, unsignedInt16Array, sArray2, fspCmdHelper);
                    if (sArray2[0] == 28) {
                        sArray[i] = 35;
                        continue;
                    }
                    sArray[i] = 30;
                    continue;
                }
                sArray[i] = 30;
            }
        }
        if (3 <= Trace.LEVEL) {
            Trace.trace("aplphscD", "<- PIDLPARFunction.varyOnOffSlots method");
        }
    }

    public static void UpdateResultsArray(short[] sArray, Vector vector, Vector vector2, short[] sArray2) {
        if (3 <= Trace.LEVEL) {
            Trace.trace("aplphscD", "<- PIDLPARFunction.UpdateResultsArray method");
        }
        for (int i = 0; i < sArray2.length; ++i) {
            if (sArray2[i] == 11) continue;
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)vector2.elementAt(i);
            int n = vector.indexOf(unsignedInt16);
            System.out.println("The index is : " + n);
            sArray[n] = sArray2[i];
        }
        if (3 <= Trace.LEVEL) {
            Trace.trace("aplphscD", "-> PIDLPARFunction.UpdateResultsArray method");
        }
    }

    public static int doRMCFlows(PIHSCRMCClient pIHSCRMCClient, Vector vector, UnsignedInt16 unsignedInt16, short s, String string, String string2) throws PIHscServerException {
        int n = 0;
        if (3 <= Trace.LEVEL) {
            Trace.trace("aplphscD", "<- PIDLPARFunction.doRMCFlows method");
        }
        try {
            System.out.println("Starting RMC for virtual IO " + string2 + " operation");
            n = pIHSCRMCClient.rmcDLPAROp(vector.size(), unsignedInt16.intValue(), s, string, vector.toArray(new String[vector.size()]), string2);
            System.out.println("Finished RMC for Virtual IO " + string2 + " operation - total = " + n);
            return n;
        }
        catch (HSCRMCException hSCRMCException) {
            System.out.println("RMC IO operation failed ");
            hSCRMCException.printStackTrace();
            String string3 = hSCRMCException.getMessage();
            System.out.println("exception msg = " + string3);
            n = hSCRMCException.getNumberOfSuccesses();
            return n;
        }
    }

    public static String getNameFromKeys(CIMObjectPath cIMObjectPath) throws CIMException {
        CIMProperty cIMProperty = null;
        String string = null;
        Vector vector = cIMObjectPath.getKeys();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            cIMProperty = (CIMProperty)vector.elementAt(i);
            if (!cIMProperty.getName().equals(MOF_NAME)) continue;
            string = (String)cIMProperty.getValue().getValue();
            break;
        }
        return string;
    }

    public static void syncPendingProcstoCurrentProcsDedicated(OmCecMgr omCecMgr, UnsignedInt16 unsignedInt16, int n) throws PIHscServerException {
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(n);
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(-1);
        UnsignedInt16 unsignedInt164 = new UnsignedInt16(-1);
        System.out.println("in syncPendingProcstoCurrentProcs: ");
        System.out.println("lparID = " + unsignedInt16);
        System.out.println("currentProcs = " + unsignedInt162);
        try {
            omCecMgr.getCmdHelper().setLparPendingDedicatedProcessors(unsignedInt16, unsignedInt163, unsignedInt162, unsignedInt164);
        }
        catch (Throwable throwable) {
            System.out.println("in syncPendingProcstoCurrentProcsDedicated: failed to sync ");
            throwable.printStackTrace();
            throw new PIHscServerException("0636", new String[]{unsignedInt16.toString()}, throwable);
        }
    }

    public static void syncPendingProcstoCurrentProcsShared(OmCecMgr omCecMgr, UnsignedInt16 unsignedInt16, short s, int n, long l, short s2) throws PIHscServerException {
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(s);
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(n);
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(-1);
        UnsignedInt16 unsignedInt164 = new UnsignedInt16(-1);
        UnsignedInt32 unsignedInt32 = new UnsignedInt32(l);
        UnsignedInt32 unsignedInt322 = new UnsignedInt32(-1L);
        UnsignedInt32 unsignedInt323 = new UnsignedInt32(-1L);
        UnsignedInt8 unsignedInt82 = new UnsignedInt8(s2);
        System.out.println("in syncPendingProcstoCurrentProcsShared: ");
        System.out.println("lparID = " + unsignedInt16);
        System.out.println("currSharingMode = " + s);
        System.out.println("currentProcs = " + n);
        System.out.println("currProcUnits = " + l);
        System.out.println("currUncappedWeight = " + s2);
        try {
            omCecMgr.getCmdHelper().setLparPendingSharedProcessors(unsignedInt16, unsignedInt8, unsignedInt163, unsignedInt162, unsignedInt164, unsignedInt322, unsignedInt32, unsignedInt323, unsignedInt82);
        }
        catch (Throwable throwable) {
            System.out.println("in syncPendingProcstoCurrentProcsShared: failed to sync ");
            throwable.printStackTrace();
            throw new PIHscServerException("0636", new String[]{unsignedInt16.toString()}, throwable);
        }
    }

    public static CIMInstance getIoSlotInstFromDrcIndex(UnsignedInt32 unsignedInt32, OmCecMgr omCecMgr, String string, ProviderCIMOMHandle providerCIMOMHandle) {
        String string2 = omCecMgr.drcIndexToFullLocCode(unsignedInt32);
        System.out.println("fullSlotLoc = " + string2);
        String string3 = "";
        if (string2.lastIndexOf(32) == -1) {
            return null;
        }
        string3 = string2.substring(0, string2.lastIndexOf(32));
        string3 = string3 + "*" + omCecMgr.getCecName();
        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_PCISlot", string);
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)string3));
        cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_PCISlot"));
        cIMObjectPath.addKey("DeviceID", new CIMValue((Object)unsignedInt32.toString()));
        System.out.println("slotPath = " + cIMObjectPath);
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = PIDlparFunctions.getCIMInstance(cIMObjectPath, providerCIMOMHandle);
            System.out.println("slotInst = " + cIMInstance);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return cIMInstance;
    }
}

